/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.AbleObject;
import java.io.Serializable;
import java.util.Hashtable;

public class AbleBufferConnection
implements Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    private AbleBean sourceObj;
    private AbleBean destObj;
    private String srcObjName;
    private String destObjName;
    private boolean valid;
    private int multiplicity = 1;
    private boolean inhibitory = false;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$String;

    private AbleBufferConnection() {
        this.valid = false;
    }

    public AbleBufferConnection(AbleBean ableBean, AbleBean ableBean2) throws AbleException {
        this.sourceObj = ableBean;
        this.srcObjName = ableBean.getName();
        this.destObj = ableBean2;
        this.destObjName = ableBean2.getName();
        this.valid = true;
        if (this.sourceObj == ableBean2) {
            throw new AbleException(Able.NlsMsg("Ex_CannotConnectSameObjects", new Object[]{this.srcObjName}));
        }
        if (this.sourceObj == null) {
            throw new AbleException(Able.NlsMsg("Ex_CannotConnectNullSource"));
        }
        if (ableBean2 == null) {
            throw new AbleException(Able.NlsMsg("Ex_CannotConnectNullDest"));
        }
        this.sourceObj.addDestBufferConnection(this);
        ableBean2.addSourceBufferConnection(this);
    }

    public AbleBean getSource() {
        return this.sourceObj;
    }

    public AbleBean getDest() {
        return this.destObj;
    }

    private void resolveObjectNames(Hashtable hashtable, String string, String string2) {
        this.sourceObj = (AbleBean)hashtable.get(string);
        this.destObj = (AbleBean)hashtable.get(string2);
        if (this.sourceObj == null || this.destObj == null) {
            this.valid = false;
        }
        if (this.sourceObj == this.destObj) {
            AbleLogger ableLogger = Able.TraceLog;
            if (this.sourceObj instanceof AbleObject) {
                ableLogger = ((AbleObject)this.sourceObj).getTraceLogger();
            }
            ableLogger.text(262144L, this, "resolveObjectNames", "Invalid connection: source and destination objects cannot be the same");
            this.valid = false;
        }
    }

    boolean equals(AbleBufferConnection ableBufferConnection) {
        return this.sourceObj == ableBufferConnection.sourceObj && this.destObj == ableBufferConnection.destObj;
    }

    public int hashCode() {
        int n = 0;
        if (this.sourceObj != null) {
            n ^= this.sourceObj.hashCode();
        }
        if (this.destObj != null) {
            n ^= this.destObj.hashCode();
        }
        return n;
    }

    boolean isSourceObject(AbleBean ableBean) {
        return ableBean == this.sourceObj;
    }

    public void process() throws AbleException {
        if (this.valid && this.sourceObj.isDataFlowEnabled()) {
            try {
                Class<?> clazz = null;
                Object object = this.sourceObj.getOutputBuffer();
                Object object2 = this.destObj.getInputBuffer();
                if (object2 != null) {
                    clazz = this.destObj.getInputBuffer().getClass();
                }
                if (clazz != null && object.getClass() != clazz) {
                    object = this.convertData(object, clazz);
                    this.destObj.setInputBuffer(object);
                } else {
                    this.destObj.setInputBuffer(this.sourceObj.getOutputBuffer());
                }
            }
            catch (AbleException ableException) {
                throw ableException;
            }
            catch (Exception exception) {
                this.sourceObj.getTraceLogger().exception(262144L, this, "process", exception);
                throw new AbleException(Able.NlsMsg("Ex_ConnectionProcessError", new Object[]{this.sourceObj.getName(), this.destObj.getName(), exception.getLocalizedMessage()}));
            }
        }
    }

    private Object convertData(Object object, Class clazz) {
        Object[] objectArray = object;
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            int n = ((String[])object).length;
            if (clazz.equals(array$D == null ? (array$D = AbleBufferConnection.class$("[D")) : array$D)) {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = Double.valueOf(stringArray[i]);
                }
                objectArray = dArray;
            } else if (clazz.equals(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleBufferConnection.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
                Object[] objectArray2 = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray2[i] = stringArray[i];
                }
                objectArray = objectArray2;
            }
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            int n = ((double[])object).length;
            if (clazz.equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbleBufferConnection.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = String.valueOf(dArray[i]);
                }
                objectArray = stringArray;
            } else if (clazz.equals(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleBufferConnection.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
                Object[] objectArray3 = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray3[i] = new Double(dArray[i]);
                }
                objectArray = objectArray3;
            }
        }
        return objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.valid) {
            stringBuffer.append(this.sourceObj.getName() + ".." + this.destObj.getName());
        } else {
            stringBuffer.append(Able.NlsMsg("INF_CONNECTION_INVALID"));
        }
        return stringBuffer.toString();
    }

    public void remove() {
        if (this.valid) {
            if (this.sourceObj != null) {
                this.sourceObj.removeDestBufferConnection(this);
            }
            if (this.destObj != null) {
                this.destObj.removeSourceBufferConnection(this);
            }
        }
        this.valid = false;
    }

    public void setMultiplicity(int n) {
        this.multiplicity = n;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public void setInhibitory(boolean bl) {
        this.inhibitory = bl;
    }

    public boolean getInhibitory() {
        return this.inhibitory;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

