/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.able.AbleBean;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.AbleMessageBundle;
import com.ibm.able.AblePreferences;
import com.ibm.able.AbleTraceLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.rmi.server.RMISocketFactory;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.WeakHashMap;

public class Able
implements Serializable {
    static final long serialVersionUID = 1998110200000000001L;
    public static final String Copyright = "(C) Copyright IBM Corporation 1999, 2005.";
    public static final String Copyright_Long = "Licensed Materials - Property of IBM\nPackage: com.ibm.able\n(C) Copyright IBM Corporation 1999, 2005. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String version = "2.3.0";
    public static final String Version = "ABLE Version 2.3.0 July 14, 2005";
    public static final boolean Debug = false;
    static final boolean RegressionTest = false;
    private static final String clsNm = "com.ibm.able.Able";
    static final String MessageBundleName = "com.ibm.able.AbleMessageBundle";
    public static final String PackageHomeProperty = "able.home";
    public static final String UserHome = System.getProperty("user.home") + File.separator;
    public static final String PropertiesFileDirectoryProperty = "able.prefdir";
    public static final String PropertiesFileHeader = "IBM Agent Building and Learning Environment Preferences File";
    public static final String PropertiesFileName = "able.preferences";
    public static final String GuiPropertiesFileName = "ablegui.preferences";
    public static final int ProcessingDisabled_PostingDisabled = 0;
    public static final int ProcessingDisabled_PostingEnabled = 1;
    public static final int ProcessingEnabled_PostingDisabled = 2;
    public static final int ProcessingEnabled_PostingEnabled = 3;
    private static ListResourceBundle wrkNlsMsgs;
    private static String wrkProductDirectory;
    private static URL wrkHomeUrl;
    private static String wrkLS;
    public static String LS;
    public static final AblePreferences Preferences;
    public static final long TRC_LOW = 262144L;
    public static final long TRC_MEDIUM = 524288L;
    public static final long TRC_HIGH = 0x100000L;
    public static final long TRC_NONE = 0L;
    public static final long TRC_LOW_INFER = 0x10000000000L;
    public static final long TRC_MEDIUM_INFER = 0x20000000000L;
    public static final long TRC_HIGH_INFER = 0x40000000000L;
    public static final long MSG_INFO = 1L;
    public static final long MSG_WARNING = 2L;
    public static final long MSG_ERROR = 4L;
    public static final long MSG_NONE = 0L;
    public static final long MSG_UNSPECIFIED = 0L;
    private static WeakHashMap beanLoggers;
    public static transient AbleLogger MessageLog;
    public static transient AbleLogger TraceLog;
    static ListResourceBundle NlsMsgs;
    public static String ProductDirectory;
    public static URL HomeUrl;
    public static int IndentLevel;
    private static final String Delim = "----------------------------------------------------------------------";
    public static RMISocketFactory SocketFactory;
    public static final int TraceStringFlavorHigh = 1;
    public static final int TraceStringFlavorMedium = 2;
    public static final int TraceStringFlavorLow = 3;
    public static final int TraceStringFlavorArl = 4;
    public static final int TraceStringFlavorXml = 5;

    private Able() {
    }

    public static String NlsMsg(String string) {
        try {
            return NlsMsgs.getString(string);
        }
        catch (Exception exception) {
            if (NlsMsgs == null) {
                System.err.println("\n++ NlsMsgs is NULL ++\n");
                exception.printStackTrace();
            }
            return new String("ABLE: Unknown message number <" + string + ">.");
        }
    }

    public static String NlsMsg(String string, Object[] objectArray) {
        try {
            String string2 = NlsMsgs.getString(string);
            String string3 = MessageFormat.format(string2, objectArray);
            return string3;
        }
        catch (Exception exception) {
            if (NlsMsgs == null) {
                System.err.println("\n++ NlsMsgs is NULL ++\n");
                exception.printStackTrace();
            }
            StringBuffer stringBuffer = new StringBuffer("ABLE: Unknown message key <" + string + ">.  Inserts: ");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("<{" + i + "}>  ");
            }
            return MessageFormat.format(stringBuffer.toString(), objectArray);
        }
    }

    public static void startMessageAndTraceLogging() {
        Able.startMessageLogging(Preferences.getMessageLogConsoleSeverity(), Preferences.getMessageLogFileSeverity(), Preferences.getMessageLogFileName());
        Able.startTraceLogging(Preferences.getTraceLogConsoleLevel(), Preferences.getTraceLogFileLevel(), Preferences.getTraceLogFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startMessageLogging(long l, long l2, String string) {
        AbleLogger ableLogger = MessageLog;
        synchronized (ableLogger) {
            if (l == 0L) {
                AbleTraceLogger.removeHandler(MessageLog, "AbleMessageConsole");
            } else {
                AbleTraceLogger.addConsoleHandler(MessageLog, "AbleMessageConsole", l);
            }
            if (l2 == 0L) {
                AbleTraceLogger.removeHandler(MessageLog, "AbleMessageFile");
            } else {
                AbleTraceLogger.addFileHandler(MessageLog, "AbleMessageFile", l2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startTraceLogging(long l, long l2, String string) {
        AbleLogger ableLogger = TraceLog;
        synchronized (ableLogger) {
            if (l == 0L) {
                AbleTraceLogger.removeHandler(TraceLog, "AbleTraceConsole");
            } else {
                AbleTraceLogger.addConsoleHandler(TraceLog, "AbleTraceConsole", l);
            }
            if (l2 == 0L) {
                AbleTraceLogger.removeHandler(TraceLog, "AbleTraceFile");
            } else {
                AbleTraceLogger.addFileHandler(TraceLog, "AbleTraceFile", l2, string);
            }
            Iterator iterator = beanLoggers.values().iterator();
            while (iterator != null && iterator.hasNext()) {
                AbleTraceLogger.copyLoggerHandlers(TraceLog, (AbleLogger)iterator.next());
            }
        }
    }

    public static void stopMessageAndTraceLogging() {
        Able.stopMessageLogging();
        Able.stopTraceLogging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopMessageLogging() {
        AbleLogger ableLogger = MessageLog;
        synchronized (ableLogger) {
            AbleTraceLogger.stopLogger(MessageLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopTraceLogging() {
        Object object = TraceLog;
        synchronized (object) {
            AbleTraceLogger.stopLogger(TraceLog);
        }
        object = beanLoggers.values().iterator();
        while (object != null && object.hasNext()) {
            AbleTraceLogger.stopLogger((AbleLogger)object.next());
        }
    }

    public static AbleLogger startBeanTraceLogging(AbleBean ableBean) throws AbleException {
        AbleLogger ableLogger = null;
        if (beanLoggers.containsKey(ableBean)) {
            ableLogger = (AbleLogger)beanLoggers.get(ableBean);
        } else {
            ableLogger = new AbleTraceLogger(ableBean.getName(), ableBean.getClass().getName());
            beanLoggers.put(ableBean, ableLogger);
            AbleTraceLogger.copyLoggerHandlers(TraceLog, ableLogger);
            ableBean.setTraceLogger(ableLogger);
        }
        return ableLogger;
    }

    public static void stopBeanTraceLogging(AbleBean ableBean) throws AbleException {
        AbleLogger ableLogger = ableBean.getTraceLogger();
        if (ableLogger.isBeanLogger()) {
            Enumeration enumeration = ableLogger.getHandlers();
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                vector.add(e);
                Enumeration enumeration2 = TraceLog.getHandlers();
                boolean bl = true;
                while (enumeration2.hasMoreElements()) {
                    if (!enumeration2.nextElement().equals(e)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                AbleTraceLogger.stopHandler(e);
            }
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ableLogger.removeHandler(vector.elementAt(i));
            }
        }
        beanLoggers.remove(ableBean);
        ableBean.setTraceLogger(TraceLog);
    }

    public static Object addTraceConsoleHandler(AbleBean ableBean, long l) throws AbleException {
        AbleLogger ableLogger = ableBean.getTraceLogger();
        if (!ableLogger.isBeanLogger()) {
            return null;
        }
        Object object = AbleTraceLogger.getHandler(ableLogger, "AbleBeanTraceConsole");
        if (object != null) {
            AbleTraceLogger.setHandlerLevel(ableLogger, "AbleBeanTraceConsole", l);
            return object;
        }
        AbleTraceLogger.removeHandler(ableLogger, "AbleTraceConsole");
        object = AbleTraceLogger.addConsoleHandler(ableLogger, "AbleBeanTraceConsole", l);
        return object;
    }

    public static void removeTraceConsoleHandler(AbleBean ableBean) throws AbleException {
        AbleLogger ableLogger = ableBean.getTraceLogger();
        if (ableLogger.isBeanLogger()) {
            AbleTraceLogger.removeHandler(ableLogger, "AbleTraceConsole");
        }
        AbleTraceLogger.removeHandler(ableLogger, "AbleBeanTraceConsole");
        Object object = AbleTraceLogger.getHandler(TraceLog, "AbleTraceConsole");
        if (object != null) {
            ableLogger.addHandler(object, TraceLog.getConsoleLogLevel());
        }
    }

    public static boolean hasTraceConsoleHandler(AbleLogger ableLogger) {
        if (AbleTraceLogger.hasHandler(ableLogger, "AbleTraceConsole")) {
            return true;
        }
        return AbleTraceLogger.hasHandler(ableLogger, "AbleBeanTraceConsole");
    }

    public static Object addTraceFileHandler(AbleBean ableBean, long l, String string) throws AbleException {
        AbleLogger ableLogger = ableBean.getTraceLogger();
        if (!ableLogger.isBeanLogger()) {
            return null;
        }
        Object object = AbleTraceLogger.getHandler(ableLogger, "AbleBeanTraceFile");
        if (object != null) {
            AbleTraceLogger.removeHandler(ableLogger, "AbleBeanTraceFile");
        }
        object = AbleTraceLogger.addFileHandler(ableLogger, "AbleBeanTraceFile", l, string);
        return object;
    }

    public static void removeTraceFileHandler(AbleBean ableBean) throws AbleException {
        AbleTraceLogger.removeHandler(ableBean.getTraceLogger(), "AbleBeanTraceFile");
    }

    public static boolean hasTraceFileHandler(AbleLogger ableLogger) {
        return AbleTraceLogger.hasHandler(ableLogger, "AbleTraceFile");
    }

    public static void setDefaultMessageAndTraceLogging() {
        Able.setMessageConsoleHandlerLevel(4L);
        Able.setMessageFileHandlerLevel(0L);
        Able.setTraceConsoleHandlerLevel(0L);
        Able.setTraceFileHandlerLevel(0L);
    }

    public static void setTraceConsoleHandlerLevel(long l) {
        AbleTraceLogger.setHandlerLevel(TraceLog, "AbleTraceConsole", l);
    }

    public static void setMessageConsoleHandlerLevel(long l) {
        AbleTraceLogger.setHandlerLevel(MessageLog, "AbleMessageConsole", l);
    }

    public static void setTraceFileHandlerLevel(long l) {
        AbleTraceLogger.setHandlerLevel(TraceLog, "AbleTraceFile", l);
    }

    public static void setMessageFileHandlerLevel(long l) {
        AbleTraceLogger.setHandlerLevel(MessageLog, "AbleMessageFile", l);
    }

    public static void setTraceFileHandlerLevel(long l, String string) {
        AbleTraceLogger.setHandlerLevel(TraceLog, "AbleTraceFile", l, string);
    }

    public static void setMessageFileHandlerLevel(long l, String string) {
        AbleTraceLogger.setHandlerLevel(MessageLog, "AbleMessageFile", l, string);
    }

    public static void setBeanTraceConsoleHandlerLevel(AbleBean ableBean, long l) throws AbleException {
        AbleLogger ableLogger = ableBean.getTraceLogger();
        AbleTraceLogger.setHandlerLevel(ableLogger, "AbleBeanTraceConsole", l);
    }

    public static void setBeanTraceFileHandlerLevel(AbleBean ableBean, long l, String string) throws AbleException {
        AbleLogger ableLogger = ableBean.getTraceLogger();
        AbleTraceLogger.setHandlerLevel(ableLogger, "AbleBeanTraceFile", l, string);
    }

    public static String AgentAddr(String string) {
        return "rmi://" + string + Preferences.getCommPort() + "/";
    }

    public static String AgentName(String string, String string2) {
        return Able.AgentAddr(string2) + string;
    }

    public static RMISocketFactory GetSocketFactory() {
        String string = "GetSocketFactory";
        if (SocketFactory != null) {
            return SocketFactory;
        }
        String string2 = Preferences.getSocketFactoryClass();
        if (string2.trim().length() == 0) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            SocketFactory = (RMISocketFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            Exception exception2;
            if (exception instanceof InvocationTargetException) {
                InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
                exception2 = (Exception)invocationTargetException.getTargetException();
            }
            if (TraceLog.isLogging()) {
                TraceLog.exception(262144L, clsNm, string, exception2);
            }
            MessageLog.message(262144L, (Object)clsNm, string, "Ex_SocketFactoryException", new Object[]{exception2.getLocalizedMessage(), string2});
        }
        return SocketFactory;
    }

    public static String[] ClsDelim(String string) {
        int n = Delim.length() - string.length() - IndentLevel;
        int n2 = n - 6;
        String string2 = "" + string + Delim.substring(0, n);
        String string3 = "--End " + string + Delim.substring(0, n2);
        return new String[]{string2, string3};
    }

    public static String getLocalPath(String string) throws IOException {
        Object object;
        String string2 = string;
        if (string == null) {
            return null;
        }
        if (string.startsWith("%user.home%")) {
            string2 = UserHome + string.substring(11);
        } else if (string.startsWith("%able.work%")) {
            string2 = Preferences.getWorkingDirectory() + string.substring(11);
        } else if (string.startsWith("%able.home%")) {
            string2 = ProductDirectory + string.substring(11);
        } else if (string.startsWith("%user.dir%")) {
            string2 = System.getProperty("user.dir", "") + string.substring(10);
        } else if (string.startsWith("%root%")) {
            object = Able.getLocalRootPath(null);
            string2 = (String)object + string.substring(6);
        }
        object = string2.toCharArray();
        for (int i = 0; i < ((char[])object).length; ++i) {
            if (object[i] != '\\' && object[i] != '/') continue;
            object[i] = File.separatorChar;
        }
        string2 = new String((char[])object);
        return string2;
    }

    public static String getLocalPathX(String string) {
        try {
            return Able.getLocalPath(string);
        }
        catch (IOException iOException) {
            if (TraceLog != null && TraceLog.isLogging()) {
                TraceLog.exception(262144L, clsNm, "getLocalPathX", iOException);
            }
            return string;
        }
    }

    public static String getSerializablePath(String string) throws IOException {
        Object object;
        String string2 = string;
        if (string == null) {
            return null;
        }
        if (UserHome != null && string.startsWith(UserHome)) {
            string2 = "%user.home%" + string.substring(UserHome.length());
        } else if (System.getProperty("user.dir", "?") != "?" && string.startsWith(System.getProperty("user.dir"))) {
            string2 = "%user.dir%" + string.substring(System.getProperty("user.dir").length());
        } else if (ProductDirectory != null && string.startsWith(ProductDirectory)) {
            string2 = "%able.home%" + string.substring(ProductDirectory.length());
        } else {
            object = Able.getLocalRootPath(null);
            if (string.startsWith((String)object)) {
                string2 = "%root%" + string.substring(((String)object).length());
            }
        }
        object = string2.toCharArray();
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (object[i] != 92 && object[i] != 47) continue;
            object[i] = 47;
        }
        string2 = new String((char[])object);
        return string2;
    }

    static String getSerializablePathX(String string) {
        try {
            return Able.getSerializablePath(string);
        }
        catch (IOException iOException) {
            if (TraceLog != null && TraceLog.isLogging()) {
                TraceLog.exception(262144L, clsNm, "getSerializablePathX", iOException);
            }
            return string;
        }
    }

    public static String getLocalRootPath(String string) throws IOException {
        String string2 = string;
        if (string == null) {
            string2 = Able.getLocalRootPath(System.getProperty("user.home"));
        } else {
            String string3 = new File(string).getCanonicalPath();
            string2 = new File(string3 + File.separator + "..").getCanonicalPath();
            while (!string3.equals(string2)) {
                string3 = new File(string3 + File.separator + "..").getCanonicalPath();
                string2 = new File(string3 + File.separator + "..").getCanonicalPath();
            }
        }
        return string2;
    }

    public static void runOS(String string) throws Exception {
        String string2 = System.getProperty("os.name").toUpperCase();
        if (string2.equals("AIX") || string2.equals("UNIX") || string2.equals("LINUX")) {
            Able.run(string, true);
        } else {
            Able.run(string, false);
        }
    }

    public static void run(String string) throws Exception {
        String string2 = System.getProperty("os.name").toUpperCase();
        if (string2.equals("AIX") || string2.equals("UNIX") || string2.equals("LINUX")) {
            Able.run(Able.getRunPrefixForOS() + " " + string, true);
        } else {
            Able.run(Able.getRunPrefixForOS() + " " + string, false);
        }
    }

    public static String getRunPrefixForOS() throws AbleException {
        String string = System.getProperty("os.name").toUpperCase();
        if (string.equals("AIX") || string.equals("UNIX") || string.equals("LINUX")) {
            return "";
        }
        if (string.equals("WINDOWS 95") || string.equals("WINDOWS 98")) {
            return "command.com /c start";
        }
        if (string.equals("WINDOWS NT")) {
            return "cmd /C start";
        }
        if (string.equals("WINDOWS 2000")) {
            return "cmd /c start";
        }
        if (string.equals("WINDOWS XP")) {
            return "cmd /c start";
        }
        if (string.startsWith("WINDOWS")) {
            return "cmd /c start";
        }
        if (string.equals("OS/2")) {
            return "";
        }
        throw new AbleException(Able.NlsMsg("EX_CMDS_NOT_SUPPORTED", new String[]{string}));
    }

    private static void run(String string, boolean bl) throws Exception {
        String string2 = "";
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        byte[] byArray = new byte[1024];
        if (TraceLog.isLogging()) {
            TraceLog.text(524288L, clsNm, "run", "Executing " + string);
        }
        try {
            process = runtime.exec(string);
        }
        catch (IOException iOException) {
            if (TraceLog.isLogging()) {
                TraceLog.exception(262144L, clsNm, "run", iOException);
            }
            throw new AbleException(Able.NlsMsg("EX_CANT_EXECUTE_CMD", new Object[]{string, iOException.getLocalizedMessage()}));
        }
        if (bl) {
            int n = -100;
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw new AbleException(Able.NlsMsg("EX_EXECUTION_INTERRUPTED"));
            }
        }
        InputStream inputStream = process.getErrorStream();
        try {
            inputStream.read(byArray);
            string2 = new String(byArray);
            throw new AbleException(string2);
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void sendMail(String string, Object[] objectArray, String string2, String string3) throws AbleException {
        for (int i = 0; i < objectArray.length; ++i) {
            Able.sendMail(string, (String)objectArray[i], string2, string3);
        }
    }

    public static void sendMail(String string, String string2, String string3, String string4) throws AbleException {
        String string5 = "SendMail";
        if (string4.trim().length() == 0) {
            if (TraceLog.isLogging()) {
                TraceLog.text(524288L, clsNm, string5, "Empty mail body, nothing to send.");
            }
            return;
        }
        String string6 = System.getProperty("mail.host", "");
        if (string6.trim().length() == 0) {
            throw new AbleException("System property <mail.host> not set.  Property needed for SMTP relay.");
        }
        String string7 = "mailto:";
        URL uRL = null;
        try {
            uRL = new URL(string7 + string2);
        }
        catch (MalformedURLException malformedURLException) {
            MessageLog.exception(262144L, clsNm, string5, malformedURLException);
            throw new AbleException("Invalid recipient <" + string2 + ">.", malformedURLException);
        }
        URLConnection uRLConnection = null;
        try {
            uRLConnection = uRL.openConnection();
        }
        catch (IOException iOException) {
            MessageLog.exception(262144L, clsNm, string5, iOException);
            throw new AbleException("Unable to open connection to SMTP relay <" + string6 + ">.", iOException);
        }
        uRLConnection.setDoInput(false);
        uRLConnection.setDoOutput(true);
        try {
            uRLConnection.connect();
        }
        catch (IOException iOException) {
            MessageLog.exception(262144L, clsNm, string5, iOException);
            throw new AbleException("Unable to connect to SMTP relay <" + string6 + ">.", iOException);
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(uRLConnection.getOutputStream()));
        }
        catch (IOException iOException) {
            MessageLog.exception(262144L, clsNm, string5, iOException);
            throw new AbleException("Unable to get output stream from SMTP relay <" + string6 + ">.", iOException);
        }
        printWriter.println("From: " + string);
        printWriter.println("To: " + string2);
        printWriter.println("Subject: " + string3);
        printWriter.println();
        StringReader stringReader = new StringReader(string4);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String string8 = bufferedReader.readLine();
            while (string8 != null) {
                printWriter.println(string8);
                string8 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            printWriter.close();
            MessageLog.exception(262144L, clsNm, string5, iOException);
            throw new AbleException("Error sending mail body.", iOException);
        }
        printWriter.flush();
        if (TraceLog.isLogging()) {
            TraceLog.text(524288L, clsNm, string5, "E-mail sent from <" + string + "> to <" + string2 + ">, subject <" + string3 + ">.");
        }
        printWriter.close();
    }

    public static String getSystemDescription() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            object = InetAddress.getLocalHost();
            stringBuffer.append("System: " + ((InetAddress)object).getHostName() + " " + ((InetAddress)object).getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            stringBuffer.append("System: unknown " + unknownHostException.getLocalizedMessage());
        }
        stringBuffer.append(LS + "os.name    = " + System.getProperty("os.name"));
        stringBuffer.append(LS + "os.arch    = " + System.getProperty("os.arch"));
        stringBuffer.append(LS + "os.version = " + System.getProperty("os.version"));
        stringBuffer.append(LS + "java.vm.name    = " + System.getProperty("java.vm.name"));
        stringBuffer.append(LS + "java.vm.vendor  = " + System.getProperty("java.vm.vendor"));
        stringBuffer.append(LS + "java.vm.version = " + System.getProperty("java.vm.version"));
        stringBuffer.append(LS + "java.home       = " + System.getProperty("java.home"));
        stringBuffer.append(LS + "java.class.path = " + System.getProperty("java.class.path"));
        stringBuffer.append(LS + LS + Version);
        object = stringBuffer.toString();
        return object;
    }

    private static String Copyright() {
        return Copyright;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            MessageLog.message(4L, clsNm, "main", "EX_SERIALIZED_FILE_REQUIRED");
            System.exit(0);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                TraceLog.text(0x100000L, clsNm, "main", "arg <{0}> = <{1}>", new Object[]{new Integer(i), stringArray[i]});
            }
        }
        String string = stringArray[0];
        try {
            MessageLog.message(1L, (Object)clsNm, "main", "INF_DESERIALIZING_FILE", string);
            AbleDefaultAgent ableDefaultAgent = (AbleDefaultAgent)AbleDefaultAgent.restoreFromSerializedFile(string);
            MessageLog.message(1L, (Object)clsNm, "main", "INF_STARTING_AGENT", ableDefaultAgent.getName());
            int n = ableDefaultAgent.getState();
            if (n == 1023) {
                ableDefaultAgent.resumeEnabledEventProcessing();
            } else {
                ableDefaultAgent.startEnabledEventProcessing();
            }
            while (true) {
                Thread.sleep(50L);
            }
        }
        catch (Exception exception) {
            if (TraceLog.isLogging()) {
                TraceLog.exception(262144L, clsNm, "main", exception);
            }
            MessageLog.text(4L, clsNm, "main", exception.getLocalizedMessage());
            System.exit(0);
            return;
        }
    }

    static {
        LS = AbleMessageBundle.LS;
        Preferences = new AblePreferences();
        beanLoggers = new WeakHashMap();
        MessageLog = AbleTraceLogger.getMessageLogger("AbleMessageLog", "Message logger");
        TraceLog = AbleTraceLogger.getTraceLogger("AbleTraceLog", "Trace logger");
        Able.startMessageAndTraceLogging();
        String string = System.getProperty(PackageHomeProperty, "");
        String string2 = "";
        string2 = string.trim().length() == 0 ? UserHome : string.trim();
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        wrkProductDirectory = string2 + File.separator;
        try {
            wrkHomeUrl = new URL("file", "", string2 + File.separator);
        }
        catch (MalformedURLException malformedURLException) {
            wrkHomeUrl = null;
            if (TraceLog.isLogging()) {
                TraceLog.text(262144L, clsNm, "STATIC", "Caught exception creating URL for product directory.");
            }
            MessageLog.exception(262144L, clsNm, "STATIC", malformedURLException);
        }
        if (TraceLog.isLogging()) {
            TraceLog.text(262144L, clsNm, "STATIC", "JVM: " + System.getProperty("java.vm.name") + " version " + System.getProperty("java.vm.version") + " by " + System.getProperty("java.vm.vendor"));
            TraceLog.text(262144L, clsNm, "STATIC", "Classpath: " + System.getProperty("java.class.path"));
            TraceLog.text(262144L, clsNm, "STATIC", "Native libraries: " + System.getProperty("java.library.path", "none specified by -Djava.library.path"));
            TraceLog.text(262144L, clsNm, "STATIC", "ProductDirectory: " + wrkProductDirectory);
            TraceLog.text(262144L, clsNm, "STATIC", "HomeUrl: " + wrkHomeUrl);
        }
        try {
            wrkNlsMsgs = (AbleMessageBundle)ResourceBundle.getBundle(MessageBundleName);
        }
        catch (MissingResourceException missingResourceException) {
            if (TraceLog.isLogging()) {
                TraceLog.exception(262144L, clsNm, "STATIC", missingResourceException);
            }
            MessageLog.text(4L, clsNm, "STATIC", missingResourceException.getLocalizedMessage());
        }
        String string3 = Preferences.getSmtpRelay();
        if (string3.trim().length() != 0) {
            System.getProperties().put("mail.host", string3);
            if (TraceLog.isLogging()) {
                TraceLog.text(262144L, clsNm, "STATIC", "SMTP relay is: " + string3);
            }
        } else if (TraceLog.isLogging()) {
            TraceLog.text(262144L, clsNm, "STATIC", "No SMTP relay specified.");
        }
        NlsMsgs = wrkNlsMsgs;
        ProductDirectory = wrkProductDirectory;
        HomeUrl = wrkHomeUrl;
        IndentLevel = 0;
        SocketFactory = null;
    }
}

