/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.research.util.list;

import com.ibm.research.util.list.EmptyListException;
import com.ibm.research.util.list.InvalidCurrentNodeException;
import com.ibm.research.util.list.ListException;
import com.ibm.research.util.list.ListNode;
import java.util.Enumeration;
import java.util.Vector;

public class List {
    private ListNode _head = null;
    private ListNode _tail = null;
    private ListNode _current = null;
    private long _size = 0L;

    public void addFirst(Object object) {
        this.insertAtStart(object);
    }

    public void addLast(Object object) {
        this.insertAtEnd(object);
    }

    public List clear() {
        if (this._size == 0L) {
            return this;
        }
        try {
            this.gotoHead();
            while (this._size > 0L) {
                this.deleteFromStart();
            }
        }
        catch (ListException listException) {
            System.err.println("ERROR :" + listException);
            System.err.println("Thrown in List class Clear method");
        }
        return this;
    }

    public boolean currentNodeValid() {
        return this._current != null;
    }

    public List delete() throws EmptyListException {
        if (this._size == 0L) {
            throw new EmptyListException();
        }
        if (this._size == 1L) {
            this._head = null;
            this._tail = null;
            this._current = null;
            this._size = 0L;
            return this;
        }
        if (this._current == this._head) {
            this.deleteFromStart();
            return this;
        }
        if (this._current == this._tail) {
            this.deleteFromEnd();
            return this;
        }
        this._current._lnPrev._lnNext = this._current._lnNext;
        this._current._lnNext._lnPrev = this._current._lnPrev;
        this._current = null;
        --this._size;
        return this;
    }

    public List deleteFromEnd() throws EmptyListException {
        if (this._size == 0L) {
            throw new EmptyListException();
        }
        if (this._size == 1L) {
            this._head = null;
            this._tail = null;
            this._current = null;
            this._size = 0L;
            return this;
        }
        this._tail._lnPrev._lnNext = null;
        if (this._current == this._tail) {
            this._current = this._tail._lnPrev;
        }
        this._tail = this._current;
        --this._size;
        return this;
    }

    public List deleteFromStart() throws EmptyListException {
        if (this._size == 0L) {
            throw new EmptyListException();
        }
        if (this._size == 1L) {
            this._head = null;
            this._tail = null;
            this._current = null;
            this._size = 0L;
            return this;
        }
        this._head._lnNext._lnPrev = null;
        if (this._current == this._head) {
            this._current = this._head._lnNext;
        }
        this._head = this._current;
        --this._size;
        return this;
    }

    public Enumeration enumerateData() {
        Vector<Object> vector = new Vector<Object>();
        if (this._size > 0L) {
            ListNode listNode = this._head;
            while (listNode != this._tail) {
                vector.addElement(listNode.getData());
                listNode = listNode._lnNext;
            }
            vector.addElement(this._tail.getData());
        }
        return vector.elements();
    }

    public boolean find(Object object) throws InvalidCurrentNodeException {
        ListNode listNode = this._current;
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        do {
            if (listNode.getData() != object) continue;
            this._current = listNode;
            return true;
        } while ((listNode = listNode._lnNext) != null);
        return false;
    }

    public Object getData() throws InvalidCurrentNodeException {
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        return this._current.getData();
    }

    public Object getDataNext() throws InvalidCurrentNodeException {
        if (this._current == null || this._current._lnNext == null) {
            throw new InvalidCurrentNodeException();
        }
        return this._current._lnNext.getData();
    }

    public Object getDataPrev() throws InvalidCurrentNodeException {
        if (this._current == null || this._current._lnPrev == null) {
            throw new InvalidCurrentNodeException();
        }
        return this._current._lnPrev.getData();
    }

    public List gotoHead() throws EmptyListException {
        if (this._size == 0L) {
            throw new EmptyListException();
        }
        this._current = this._head;
        return this;
    }

    public List gotoTail() throws EmptyListException {
        if (this._size == 0L) {
            throw new EmptyListException();
        }
        this._current = this._tail;
        return this;
    }

    public List insertAfter(Object object) throws InvalidCurrentNodeException {
        ListNode listNode = new ListNode(object);
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        if (this._current == this._tail) {
            this.insertAtEnd(object);
            return this;
        }
        listNode._lnNext = this._current._lnNext;
        listNode._lnPrev = this._current;
        this._current._lnNext = listNode;
        listNode._lnNext._lnPrev = listNode;
        this._current = listNode;
        ++this._size;
        return this;
    }

    public List insertAtEnd(Object object) {
        ListNode listNode = new ListNode(object);
        if (this._tail == null) {
            this._head = listNode;
            this._tail = listNode;
        } else {
            listNode._lnPrev = this._tail;
            this._tail._lnNext = listNode;
            this._tail = listNode;
        }
        ++this._size;
        this._current = listNode;
        return this;
    }

    public List insertAtStart(Object object) {
        ListNode listNode = new ListNode(object);
        if (this._head == null) {
            this._head = listNode;
            this._tail = listNode;
        } else {
            listNode._lnNext = this._head;
            this._head._lnPrev = listNode;
            this._head = listNode;
        }
        ++this._size;
        this._current = listNode;
        return this;
    }

    public List insertBefore(Object object) throws InvalidCurrentNodeException {
        ListNode listNode = new ListNode(object);
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        if (this._current == this._head) {
            this.insertAtStart(object);
            return this;
        }
        listNode._lnNext = this._current;
        listNode._lnPrev = this._current._lnPrev;
        listNode._lnPrev._lnNext = listNode;
        this._current._lnPrev = listNode;
        this._current = listNode;
        ++this._size;
        return this;
    }

    public boolean isEmpty() {
        return this._size == 0L;
    }

    public boolean isHead() {
        if (this._current == null) {
            return false;
        }
        return this._current == this._head;
    }

    public boolean isTail() {
        if (this._current == null) {
            return false;
        }
        return this._current == this._tail;
    }

    public List next() throws InvalidCurrentNodeException {
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        this._current = this._current._lnNext;
        return this;
    }

    public List previous() throws InvalidCurrentNodeException {
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        this._current = this._current._lnPrev;
        return this;
    }

    public void setData(Object object) {
        if (this._current == null) {
            return;
        }
        this._current.setData(object);
    }

    public long size() {
        return this._size;
    }
}

