/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.research.util;

public class Coords {
    private int xCoord;
    private int yCoord;

    public Coords(int n, int n2) {
        this.xCoord = n;
        this.yCoord = n2;
    }

    public static Coords bisection(Coords coords, Coords coords2, Coords coords3) {
        Coords coords4 = coords2.minus(coords);
        double d = coords4.magnitude();
        Coords coords5 = coords3.minus(coords);
        double d2 = coords5.magnitude();
        double d3 = (double)coords4.xCoord / d + (double)coords5.xCoord / d2;
        double d4 = (double)coords4.yCoord / d + (double)coords5.yCoord / d2;
        double d5 = Math.sqrt(d) * Math.sqrt(d2) / Math.sqrt(d3 * d3 + d4 * d4);
        if (coords4.cross(coords5) >= 0) {
            return new Coords(coords.xCoord + (int)(d3 * d5), coords.yCoord + (int)(d4 * d5));
        }
        return new Coords(coords.xCoord - (int)(d3 * d5), coords.yCoord - (int)(d4 * d5));
    }

    public int cross(Coords coords) {
        return this.xCoord * coords.yCoord - this.yCoord * coords.xCoord;
    }

    public static int crossProduct(Coords coords, Coords coords2) {
        return coords.cross(coords2);
    }

    public static Coords difference(Coords coords, Coords coords2) {
        return coords.minus(coords2);
    }

    public int dot(Coords coords) {
        return this.xCoord * coords.xCoord + this.yCoord * coords.yCoord;
    }

    public static int dotProduct(Coords coords, Coords coords2) {
        return coords.dot(coords2);
    }

    public double magnitude() {
        return Math.sqrt(this.xCoord * this.xCoord + this.yCoord * this.yCoord);
    }

    public static Coords midpoint(Coords coords, Coords coords2) {
        return new Coords((coords.xCoord + coords2.xCoord) / 2, (coords.yCoord + coords2.yCoord) / 2);
    }

    public Coords minus(Coords coords) {
        return new Coords(this.xCoord - coords.xCoord, this.yCoord - coords.yCoord);
    }

    public Coords normalize(double d) {
        double d2 = this.magnitude();
        return new Coords((int)((double)this.xCoord * d / d2), (int)((double)this.yCoord * d / d2));
    }

    public Coords plus(Coords coords) {
        return new Coords(this.xCoord + coords.xCoord, this.yCoord + coords.yCoord);
    }

    public Coords rotate90() {
        return new Coords(-this.yCoord, this.xCoord);
    }

    public Coords scale(double d) {
        return new Coords((int)((double)this.xCoord * d), (int)((double)this.yCoord * d));
    }

    public Coords scale(int n) {
        return new Coords(this.xCoord * n, this.yCoord * n);
    }

    public static Coords sum(Coords coords, Coords coords2) {
        return coords.plus(coords2);
    }

    public String toString() {
        return "(" + this.xCoord + ", " + this.yCoord + ")";
    }

    public int x() {
        return this.xCoord;
    }

    public int y() {
        return this.yCoord;
    }
}

