/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.research.geometry;

import java.awt.Point;

public class Points {
    public static final double distance(Point point, Point point2) {
        if (point == null || point2 == null) {
            return Double.NaN;
        }
        return Math.sqrt((point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y));
    }

    public static final Point midPoint(Point point, Point point2) {
        if (point == null) {
            return point2;
        }
        if (point2 == null) {
            return point;
        }
        return new Point((point2.x + point.x) / 2, (point2.y + point.y) / 2);
    }

    public static final Point ratioPoint(Point point, Point point2, int n, int n2) {
        if (point == null) {
            return point2;
        }
        if (point2 == null) {
            return point;
        }
        return new Point((n * point2.x + n2 * point.x) / (n + n2), (n * point2.y + n2 * point.y) / (n + n2));
    }

    public static final Point rotate(int n, int n2, double d) {
        return new Point((int)((double)n * Math.cos(d) - (double)n2 * Math.sin(d)), (int)((double)n * Math.sin(d) + (double)n2 * Math.cos(d)));
    }

    public static final void rotate(Point point, double d) {
        int n = (int)((double)point.x * Math.cos(d) - (double)point.y * Math.sin(d));
        int n2 = (int)((double)point.x * Math.sin(d) + (double)point.y * Math.cos(d));
        point.x = n;
        point.y = n2;
    }

    public static final double slope(Point point, Point point2) {
        if (point == null || point2 == null) {
            return Double.NaN;
        }
        if (point.x == point2.y) {
            if (point.y == point2.y) {
                return Double.NaN;
            }
            if (point.y > point2.y) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        return (point.y - point2.y) / (point2.x - point.x);
    }
}

