/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.research.awt.draw;

import com.ibm.research.awt.FontMetricized;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class DrawText {
    public static final int ALIGNMENT_BOTTOM = -1;
    public static final int ALIGNMENT_CENTER = 0;
    public static final int ALIGNMENT_TOP = 1;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = -1;
    protected static int iClassVerbose = 0;
    protected int iVerbose = 0;
    private static final String strClassName = "DrawText";
    private static String _strDefaultFontName = "Helvetica";
    private static int _iDefaultFontStyle = 0;
    private static int _iDefaultFontSize = 12;
    private String strText;
    private Color _colorText = Color.black;
    private FontMetricized _fontText;
    private int iAlignmentX = 0;
    private int iAlignmentY = 0;

    public static void setClassVerbose(int n) {
        iClassVerbose = n;
    }

    public static int getClassVerbose() {
        return iClassVerbose;
    }

    public DrawText() {
        this(null, _strDefaultFontName, _iDefaultFontStyle, _iDefaultFontSize);
    }

    public DrawText(String string, int n, int n2) {
        this(null, string, n, n2);
    }

    public DrawText(FontMetricized fontMetricized) {
        this(null, fontMetricized);
    }

    public DrawText(String string) {
        this(string, _strDefaultFontName, _iDefaultFontStyle, _iDefaultFontSize);
    }

    public DrawText(String string, String string2, int n, int n2) {
        this.setText(string);
        this.setFont(string2, n, n2);
    }

    public DrawText(String string, FontMetricized fontMetricized) {
        this.setText(string);
        this.setFont(fontMetricized);
    }

    public void setColor(Color color) {
        this._colorText = color;
    }

    public Color getColor() {
        return this._colorText;
    }

    public void setFont(String string, int n, int n2) {
        this._fontText = new FontMetricized(string, n, n2);
    }

    public void setText(String string) {
        if (this.iVerbose >= 1 && string == null) {
            System.out.println("[DrawText.setText(\"" + string + "\")] Warning: Null text.");
        }
        this.strText = string;
    }

    public String getText() {
        return this.strText;
    }

    public void draw(Graphics graphics, int n, int n2) {
        this._draw(graphics, n, n2);
    }

    public Dimension getSize() {
        return this._getSize();
    }

    public void setAlignmentX(int n) {
        this.iAlignmentX = n;
    }

    public void setAlignmentY(int n) {
        this.iAlignmentY = n;
    }

    public int getAlignmentX() {
        return this.iAlignmentX;
    }

    public int getAlignmentY() {
        return this.iAlignmentY;
    }

    public void setAlignments(int n, int n2) {
        this.iAlignmentX = n;
        this.iAlignmentY = n2;
    }

    public void setFont(FontMetricized fontMetricized) {
        this._fontText = fontMetricized;
    }

    public FontMetricized getFont() {
        return this._fontText;
    }

    public void setVerbose(int n) {
        this.iVerbose = n;
    }

    public int getVerbose() {
        return this.iVerbose;
    }

    int _alignX(int n, int n2) {
        int n3 = n + (n2 * (this.iAlignmentX - 1) >> 1);
        if (this.iVerbose >= 3) {
            System.out.println("[DrawText._alignX(" + n + "," + n2 + ")]; " + n3);
        }
        return n3;
    }

    int _alignY(int n, int n2) {
        int n3 = n + (n2 * (this.iAlignmentY - 1) >> 1);
        if (this.iVerbose >= 3) {
            System.out.println("[DrawText._alignY(" + n + "," + n2 + ")]; " + n3);
        }
        return n3;
    }

    private void _draw(Graphics graphics, int n, int n2) {
        Dimension dimension = this._getSize();
        this._drawText(graphics, this.strText, this._alignX(n, dimension.width), this._alignY(n2, dimension.height) + dimension.height - this._fontText.descent);
    }

    private void _drawText(Graphics graphics, String string, int n, int n2) {
        Color color;
        Font font;
        block5: {
            font = graphics.getFont();
            color = graphics.getColor();
            try {
                graphics.setFont(this._fontText);
                graphics.setColor(this._colorText);
                graphics.drawString(string, n, n2);
            }
            catch (NullPointerException nullPointerException) {
                if (this.iVerbose < 1) break block5;
                System.out.print("!?[DrawText]");
                if (string == null) {
                    System.out.println(" Can't draw null text.");
                }
                if (this._fontText == null) {
                    System.out.println(" Can't draw with null font.");
                }
                if (this._colorText == null) {
                    System.out.println(" Can't draw with null color.");
                }
                System.out.println(nullPointerException);
            }
        }
        graphics.setColor(color);
        graphics.setFont(font);
    }

    private Dimension _getSize() {
        return this._getMinimumSize();
    }

    private Dimension _getMinimumSize() {
        int n = this._fontText.metrics.stringWidth(this.strText);
        int n2 = this._fontText.height;
        return new Dimension(n, n2);
    }

    private Rectangle _getBounds(Point point) {
        Dimension dimension = this._getSize();
        Rectangle rectangle = new Rectangle(this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height), dimension.width, dimension.height);
        return rectangle;
    }
}

