/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.layout;

import com.ibm.graph.GraphLayoutManager;
import com.ibm.graph.InvalidNetException;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Tree;
import com.ibm.graph.Vertex;
import com.ibm.research.util.KeyMissingException;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;

public class LayoutTree
implements GraphLayoutManager {
    public static final int LEFT_TO_RIGHT = 0;
    public static final int TOP_TO_BOTTOM = 1;
    public static final int RIGHT_TO_LEFT = 2;
    public static final int BOTTOM_TO_TOP = 3;
    int iFormat = 0;
    public static final int BALANCED = 0;
    public static final int TOP_ADJUST = 1;
    boolean zPreOrder = true;
    int iXRoot = 80;
    int iYRoot = 80;
    int iXNext = this.iXRoot;
    int iYNext = this.iYRoot;
    int iXDelta;
    int iYDelta;
    private static final String strClassName = "LayoutTree";
    private int iDirection = 0;
    private int iVerbose = 5;
    private boolean zAdjust = false;
    private int iDepthSpace = 10;
    private int iBreadthSpace = 10;

    public LayoutTree() {
        this._setSpaces();
    }

    private Rectangle _getChildrenBounds(Vertex vertex, String string) {
        int n;
        Rectangle rectangle = null;
        try {
            n = vertex.systemdict.getInteger(string);
        }
        catch (KeyMissingException keyMissingException) {
            return rectangle;
        }
        Enumeration enumeration = vertex.enumerateNeighbors();
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            try {
                if (vertex2.systemdict.getInteger(string) < n) {
                }
            }
            catch (KeyMissingException keyMissingException) {}
            continue;
            try {
                if (rectangle == null) {
                    rectangle = new Rectangle(vertex2.getLocation());
                    continue;
                }
                rectangle.add(vertex2.getLocation());
            }
            catch (NotDrawableException notDrawableException) {}
        }
        return rectangle;
    }

    private Point _layoutDepthFirst(Tree tree, Vertex vertex, String string, int n, boolean bl, int n2, Point point) {
        if (this.iVerbose >= 4) {
            System.out.println("[LayoutTree._layoutDepthFirst(Tree,Vertex,String,direction=" + n + ",pre-order=" + bl + ",format=" + n2 + "," + point + ")]");
        }
        int n3 = 0;
        Point point2 = point;
        vertex.setLocation(point2.x, point2.y);
        if (n == 0 || n == 2) {
            try {
                point2.y = point2.y + (this.iYDelta + (this.zAdjust ? vertex.getSize((Net)tree).height : 0));
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println("[LayoutTree.layout()] Could not get size for tree root. Layout aborted.");
                return point2;
            }
        }
        try {
            if (this.iVerbose >= 5) {
                System.out.println("\tTraverse tree depth first:");
            }
            Enumeration enumeration = tree.enumerateDepthFirstTraversal(bl, vertex, string);
            while (enumeration.hasMoreElements()) {
                Vertex vertex2 = (Vertex)enumeration.nextElement();
                if (vertex2 == vertex) continue;
                if (this.iVerbose >= 5) {
                    System.out.println("\t\tVisit vertex " + vertex2);
                }
                try {
                    n3 = vertex2.systemdict.getInteger(string);
                }
                catch (KeyMissingException keyMissingException) {
                    continue;
                }
                if (n == 0 || n == 2) {
                    vertex2.systemdict.def((Object)"x", point2.x + n3 * this.iXDelta);
                    System.out.println("[LayoutTree.layout()] Vertex degree = " + vertex2.degree());
                    if (vertex2.degree(tree) == 1 || bl) {
                        vertex2.systemdict.def((Object)"y", point2.y);
                        try {
                            point2.y = point2.y + (this.iYDelta + (this.zAdjust ? vertex2.getSize((Net)tree).height : 0));
                            continue;
                        }
                        catch (NotDrawableException notDrawableException) {
                            System.out.println("[LayoutTree.layout()] Could not get size for vertex " + vertex2 + ". Layout aborted.");
                            System.out.println("\tvertex.systemdict:");
                            System.out.println(vertex2.systemdict);
                            return point2;
                        }
                    }
                    Rectangle rectangle = null;
                    Enumeration enumeration2 = vertex2.enumerateNeighbors();
                    while (enumeration2.hasMoreElements()) {
                        Vertex vertex3 = (Vertex)enumeration2.nextElement();
                        try {
                            if (vertex3.systemdict.getInteger(string) < n3) {
                            }
                        }
                        catch (KeyMissingException keyMissingException) {}
                        continue;
                        System.out.println("[LayoutTree.layout()] Child bounds = " + vertex3.getBounds());
                        if (rectangle == null) {
                            rectangle = new Rectangle(vertex3.getLocation(tree));
                            continue;
                        }
                        rectangle.add(vertex3.getLocation(tree));
                    }
                    try {
                        switch (n2) {
                            case 0: {
                                vertex2.systemdict.def((Object)"y", rectangle.y + rectangle.height / 2);
                                break;
                            }
                            case 1: {
                                vertex2.systemdict.def((Object)"y", rectangle.y + vertex2.getSize().height);
                                break;
                            }
                            default: {
                                System.out.println("[LayoutTree] Unknow format " + n2);
                                break;
                            }
                        }
                    }
                    catch (NotDrawableException notDrawableException) {
                        System.out.println("[LayoutTree] Unknown size for " + vertex2);
                    }
                    continue;
                }
                vertex2.systemdict.def((Object)"x", point2.x);
                vertex2.systemdict.def((Object)"y", point2.y + n3 * this.iYDelta);
                if (vertex2.degree() != 1) continue;
                point2.x += this.iXDelta;
            }
        }
        catch (NotDrawableException notDrawableException) {
            System.out.println("[LayoutTree] Not drawable.");
        }
        if (this.iVerbose >= 4) {
            System.out.println("[LayoutTree._layoutDepthFirst()] ...end");
        }
        return point2;
    }

    private void _layoutTopToBottom(Tree tree, Vertex vertex, String string) {
        Vertex vertex2;
        int n = this.iYRoot;
        int n2 = 0;
        int n3 = 0;
        Enumeration enumeration = tree.enumerateBreadthFirstTraversal(vertex, string);
        while (enumeration.hasMoreElements()) {
            vertex2 = (Vertex)enumeration.nextElement();
            try {
                int n4 = vertex2.systemdict.getInteger(string);
                if (n4 > n2) {
                    n2 = n4;
                    n += n3 + this.iYDelta;
                    n3 = vertex2.getSize().height;
                } else {
                    n3 = Math.max(n3, vertex2.getSize().height);
                }
            }
            catch (KeyMissingException keyMissingException) {
                continue;
            }
            catch (NotDrawableException notDrawableException) {
                continue;
            }
            vertex2.setLocationY(n);
        }
        int n5 = this.iXRoot;
        Enumeration enumeration2 = tree.enumerateDepthFirstTraversal(false, vertex, string);
        while (enumeration2.hasMoreElements()) {
            vertex2 = (Vertex)enumeration2.nextElement();
            try {
                n2 = vertex2.systemdict.getInteger(string);
            }
            catch (KeyMissingException keyMissingException) {
                continue;
            }
            if (vertex2.degree() == 1 && vertex2 != vertex) {
                vertex2.setLocationX(n5);
                try {
                    n5 += vertex2.getSize().width + this.iXDelta;
                }
                catch (NotDrawableException notDrawableException) {
                    n5 += this.iXDelta;
                }
                continue;
            }
            Rectangle rectangle = this._getChildrenBounds(vertex2, string);
            if (rectangle != null) {
                vertex2.setLocationX(rectangle.x + (rectangle.width >> 1));
                continue;
            }
            vertex2.setLocationX(n5);
        }
    }

    private void _setSpaces() {
        switch (this.iDirection) {
            case 0: {
                this.iXDelta = this.iDepthSpace;
                this.iYDelta = this.iBreadthSpace;
                break;
            }
            case 1: {
                this.iYDelta = this.iDepthSpace;
                this.iXDelta = this.iBreadthSpace;
                break;
            }
            case 2: {
                this.iXDelta = -this.iDepthSpace;
                this.iYDelta = this.iBreadthSpace;
                break;
            }
            case 3: {
                this.iYDelta = -this.iDepthSpace;
                this.iXDelta = this.iBreadthSpace;
                break;
            }
            default: {
                System.out.println("[LayoutTree] Invalid direction (" + this.iDirection + ")");
            }
        }
    }

    public boolean getAdjust() {
        return this.zAdjust;
    }

    public int getBreadthSpace() {
        return this.iBreadthSpace;
    }

    public int getDepthSpace() {
        return this.iDepthSpace;
    }

    public int getDirection() {
        return this.iDirection;
    }

    public Point getRootLocation() {
        Point point = new Point(this.iXRoot, this.iYRoot);
        return point;
    }

    public int getVerbose() {
        return this.iVerbose;
    }

    private int getVertexHeight(Vertex vertex) throws NotDrawableException {
        return vertex.getBounds().height;
    }

    private int getVertexWidth(Vertex vertex) throws NotDrawableException {
        return vertex.getBounds().width;
    }

    public void layout(Net net) {
        block22: {
            boolean bl;
            block21: {
                if (this.iVerbose >= 2) {
                    System.out.println("[LayoutTree.layout(Net)]\n");
                }
                if (this.iVerbose >= 3) {
                    net.print(System.out, 2);
                }
                try {
                    if (net.isEmpty()) {
                        System.out.println("[LayoutTree.layout(Net)] An empty net has no layout.");
                    }
                    break block21;
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("[LayoutTree.layout(Net)] A null net can not be laid out.");
                }
                break block22;
            }
            if (this.iVerbose >= 4) {
                System.out.println("[LayoutTree.layout()] Net not empty.");
            }
            Tree tree = null;
            try {
                tree = (Tree)net;
                bl = false;
            }
            catch (ClassCastException classCastException) {
                try {
                    if (this.iVerbose >= 4) {
                        System.out.println("\tCloning tree:");
                    }
                    tree = new Tree(net);
                }
                catch (InvalidNetException invalidNetException) {
                    System.out.println("[LayoutTree.layout(Net)] Net is not a tree.");
                    return;
                }
                bl = true;
            }
            if (this.iVerbose >= 4) {
                System.out.println("[LayoutTree.layout()] Net cast to tree.");
            }
            if (this.iVerbose >= 4) {
                System.out.println("[LayoutTree.layout()] strDepthKeyName calculated:");
            }
            String string = tree.defUniqueSystemKey("depth");
            if (this.iVerbose >= 4) {
                System.out.println("[LayoutTree.layout()] strDepthKeyName = " + string);
            }
            boolean bl2 = false;
            if (this.iVerbose >= 4) {
                System.out.println("[LayoutTree.layout()] For each tree in forest:");
            }
            Point point = new Point(this.iXRoot, this.iYRoot);
            Enumeration enumeration = tree.enumerateRoots();
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                if (this.iDirection == 1 && !this.zPreOrder) {
                    this._layoutTopToBottom(tree, vertex, string);
                } else {
                    point = this._layoutDepthFirst(tree, vertex, string, this.iDirection, this.zPreOrder, this.iFormat, point);
                }
                bl2 = true;
            }
            if (!bl2) {
                System.out.println("[LayoutTree.layout()] Tree does not have a root. Use tree.setRoot(Vertex) method.");
            }
            tree.undefSystemKey(string);
            if (bl) {
                tree.delete();
            }
        }
        if (this.iVerbose >= 2) {
            System.out.println("[LayoutTree.layout()] ...end.");
        }
    }

    public int queryBreadthSpace() {
        return this.iBreadthSpace;
    }

    public int queryDepthSpace() {
        return this.iDepthSpace;
    }

    public void setAdjust(boolean bl) {
        this.zAdjust = bl;
    }

    public void setBottomUp() {
        this.setPreOrder(false);
    }

    public void setBreadthSpace(int n) {
        this.iBreadthSpace = n;
        this._setSpaces();
    }

    public void setDepthSpace(int n) {
        this.iDepthSpace = n;
        this._setSpaces();
    }

    public void setDirection(int n) {
        this.iDirection = n;
        this._setSpaces();
    }

    public void setPreOrder() {
        this.setPreOrder(true);
    }

    public void setPreOrder(boolean bl) {
        this.zPreOrder = bl;
    }

    public void setRootLocation(int n, int n2) {
        this.iXRoot = n;
        this.iYRoot = n2;
    }

    public Point setRootLocation(Point point) {
        Point point2 = new Point(this.iXRoot, this.iYRoot);
        this.iXRoot = point.x;
        this.iYRoot = point.y;
        return point2;
    }

    public void setVerbose(int n) {
        this.iVerbose = n;
    }
}

