/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.layout;

import com.ibm.graph.Edge;
import com.ibm.graph.GraphLayoutManager;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexMissingException;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public class LayoutNetAsDAG
implements GraphLayoutManager {
    public static final String strDefaultKeyNameRootVertex = "[ROOT]";
    public static final int ORIENTATION_TOP_BOTTOM = 0;
    public static final int ORIENTATION_LEFT_RIGHT = 1;
    public static final int ALIGNMENT_INTRA_TOP = 0;
    public static final int ALIGNMENT_INTRA_CENTER = 1;
    public static final int ALIGNMENT_INTRA_BOTTOM = 2;
    public static final int ALIGNMENT_INTER_LEFT = 0;
    public static final int ALIGNMENT_INTER_CENTER = 1;
    public static final int ALIGNMENT_INTER_RIGHT = 2;
    private static final String strClassName = "LayoutNetAsDAG";
    private String _strKeyNameRootVertex;
    private boolean _zKeyNameRootVertexIsInSystemdict;
    private int _iOrientation;
    private int _iIntraLevelSpacing = 10;
    private int _iInterLevelSpacing = 10;
    private Point _pointOrigin = new Point();

    public LayoutNetAsDAG() {
        this(true, strDefaultKeyNameRootVertex, 0);
    }

    public LayoutNetAsDAG(String string) {
        this(true, string, 0);
    }

    public LayoutNetAsDAG(String string, boolean bl) {
        this(bl, string, 0);
    }

    public LayoutNetAsDAG(boolean bl) {
        this(bl, strDefaultKeyNameRootVertex, 0);
    }

    private LayoutNetAsDAG(boolean bl, String string, int n) {
        this._zKeyNameRootVertexIsInSystemdict = bl;
        this._strKeyNameRootVertex = string;
        this._iOrientation = n;
    }

    private int _doLeveling(Net net, String string, String string2) {
        Vector vector = new Vector();
        Vector vector2 = (Vector)net.systemdict.get(string2);
        int n = 0;
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Dict dict;
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (this._zKeyNameRootVertexIsInSystemdict) {
                dict = vertex.systemdict;
            } else {
                try {
                    dict = (Dict)vertex.systemdict.get(net);
                    if (dict == null) {
                        System.out.println("[LayoutNetAsDAG] No net key in systemdict of " + vertex + ".");
                        dict = vertex.systemdict;
                    }
                }
                catch (ClassCastException classCastException) {
                    System.out.println("[LayoutNetAsDAG] The value of net key in systemdict of " + vertex + " is not of type Dict.");
                    dict = vertex.systemdict;
                }
            }
            Object v = dict.get(this._strKeyNameRootVertex);
            if (v == null) continue;
            try {
                if (!dict.getBoolean(this._strKeyNameRootVertex)) continue;
                vertex.systemdict.def((Object)string, n);
                vector.addElement(vertex);
            }
            catch (ClassCastException classCastException) {
                System.out.println("[LayoutNetAsDAG] The value of the root key for " + vertex + " is not a boolean.");
            }
            catch (KeyMissingException keyMissingException) {}
        }
        while (vector.size() > 0) {
            vector2.addElement(vector);
            vector = this._doNextLevel(vector, string, ++n);
        }
        return n;
    }

    private Vector _doNextLevel(Vector vector, String string, int n) {
        Vector<Vertex> vector2 = new Vector<Vertex>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            Enumeration enumeration2 = vertex.enumerateOutgoingEdges();
            while (enumeration2.hasMoreElements()) {
                Vertex vertex2;
                Edge edge = (Edge)enumeration2.nextElement();
                try {
                    vertex2 = edge.getOtherVertex(vertex);
                }
                catch (VertexMissingException vertexMissingException) {
                    vertex2 = null;
                }
                try {
                    if (vertex2.systemdict.getInteger(string) != -1) continue;
                    vertex2.systemdict.def((Object)string, n);
                    vector2.addElement(vertex2);
                }
                catch (KeyMissingException keyMissingException) {}
            }
        }
        return vector2;
    }

    private void _layoutNS(Net net, String string, int n) {
        Vector vector = (Vector)net.systemdict.get(string);
        Vector<Dimension> vector2 = new Vector<Dimension>(vector.size());
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector3 = (Vector)enumeration.nextElement();
            Dimension dimension = new Dimension();
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                Dimension dimension2;
                Vertex vertex = (Vertex)enumeration2.nextElement();
                try {
                    System.out.println("[LayoutNetAsDAG.layout(Net)] Vertex size:");
                    System.out.println(vertex.getSize());
                    dimension2 = vertex.getSize();
                }
                catch (NotDrawableException notDrawableException) {
                    System.out.println("[LayoutNetAsDAG] Vertex " + vertex + " is not drawable.");
                    continue;
                }
                dimension.width += dimension2.width;
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            dimension.width += this._iIntraLevelSpacing * (vector3.size() - 1);
            n2 = Math.max(n2, dimension.width);
            System.out.println("[LayoutNetAsDAG.layout(Net)] Max width = " + n2);
            vector2.addElement(dimension);
            System.out.println("[LayoutNetAsDAG.layout(Net)] Level min sizes:");
            System.out.println(vector2);
        }
    }

    private void _layoutWE(Net net, String string, int n) {
    }

    public String getKeyNameRootVertex() {
        return this._strKeyNameRootVertex;
    }

    public boolean getKeyNameRootVertexIsInSystemdict() {
        return this._zKeyNameRootVertexIsInSystemdict;
    }

    public int getOrientation() {
        return this._iOrientation;
    }

    public void layout(Net net) {
        String string = net.defUniqueSystemKey("%%level%%", -1);
        String string2 = net.systemdict.defUniqueKey("%%vlevels%% ");
        net.systemdict.def((Object)string2, new Vector());
        int n = this._doLeveling(net, string, string2);
        switch (this._iOrientation) {
            case 0: {
                this._layoutNS(net, string2, n);
                break;
            }
            case 1: {
                this._layoutWE(net, string2, n);
                break;
            }
            default: {
                System.out.println("[LayoutNetAsDAG.layout(Net)] Invalid orientation (" + this._iOrientation + ").");
            }
        }
    }

    public void setKeyNameRootVertex(String string) {
        this._strKeyNameRootVertex = string;
    }

    public void setKeyNameRootVertexIsInSystemdict(boolean bl) {
        this._zKeyNameRootVertexIsInSystemdict = bl;
    }

    public void setOrientation(int n) {
        this._iOrientation = n;
    }
}

