/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.layout;

import com.ibm.graph.Edge;
import com.ibm.graph.GraphLayoutManager;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexMissingException;
import com.ibm.research.util.KeyMissingException;
import java.util.Enumeration;

public class LayoutGraphHierarchical
implements GraphLayoutManager {
    public static final int LEFT_RIGHT = 0;
    public static final int TOP_BOTTOM = 2;
    int iXRoot = 80;
    int iYRoot = 80;
    int iXDelta = 60;
    int iYDelta = 10;
    int iXNext;
    int iYNext;

    private int getVertexHeight(Vertex vertex) throws NotDrawableException {
        return vertex.getBounds().height + this.iYDelta;
    }

    private int getVertexWidth(Vertex vertex) throws NotDrawableException {
        return vertex.getBounds().width + this.iXDelta;
    }

    public void layout(Net net) {
        if (net == null) {
            return;
        }
        int n = net.sizeVertices();
        if (n == 0) {
            return;
        }
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            ((Vertex)enumeration.nextElement()).systemdict.def((Object)"!!placed", false);
        }
        this.iXNext = this.iXRoot;
        this.iYNext = this.iYRoot;
        Vertex vertex = null;
        Enumeration enumeration2 = net.enumerateVertices();
        while (enumeration2.hasMoreElements()) {
            vertex = (Vertex)enumeration2.nextElement();
            try {
                if (!vertex.systemdict.getBoolean("root") || vertex.systemdict.getBoolean("!!placed")) continue;
                vertex.systemdict.def((Object)"x", this.iXNext);
                vertex.systemdict.def((Object)"y", this.iYNext);
                vertex.systemdict.def((Object)"!!placed", true);
                this.traverseEdges(vertex);
                this.iYNext += this.getVertexHeight(vertex);
            }
            catch (KeyMissingException keyMissingException) {
            }
            catch (NotDrawableException notDrawableException) {}
        }
        Enumeration enumeration3 = net.enumerateVertices();
        while (enumeration3.hasMoreElements()) {
            vertex = (Vertex)enumeration3.nextElement();
            try {
                if (vertex.systemdict.getBoolean("!!placed")) continue;
                vertex.systemdict.def((Object)"x", this.iXNext);
                vertex.systemdict.def((Object)"y", this.iYNext);
                vertex.systemdict.def((Object)"!!placed", true);
                this.traverseEdges(vertex);
                this.iYNext += this.getVertexHeight(vertex);
            }
            catch (KeyMissingException keyMissingException) {
            }
            catch (NotDrawableException notDrawableException) {}
        }
    }

    private void traverseEdges(Vertex vertex) throws NotDrawableException {
        boolean bl = false;
        this.iXNext += this.getVertexWidth(vertex);
        Enumeration enumeration = vertex.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = null;
            Edge edge = (Edge)enumeration.nextElement();
            try {
                vertex2 = edge.getOtherVertex(vertex);
            }
            catch (VertexMissingException vertexMissingException) {
                System.out.println("[LayoutGraphHierarchical.traverseEdges()] Bug!");
                break;
            }
            try {
                if (vertex2.systemdict.getBoolean("!!placed")) {
                    continue;
                }
            }
            catch (KeyMissingException keyMissingException) {
                System.out.println("[LayoutGraphHierarchical.traverseEdges()] Bug!");
                break;
            }
            if (bl) {
                this.iYNext += this.getVertexHeight(vertex2);
            }
            vertex2.systemdict.def((Object)"x", this.iXNext);
            vertex2.systemdict.def((Object)"y", this.iYNext);
            vertex2.systemdict.def((Object)"!!placed", true);
            bl = true;
            this.traverseEdges(vertex2);
        }
        this.iXNext -= this.getVertexWidth(vertex);
    }
}

