/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.layout;

import com.ibm.graph.Edge;
import com.ibm.graph.GraphLayoutManager;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexMissingException;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Enumeration;

public class LayoutGraphAsTree
implements GraphLayoutManager {
    private static String strClassName = "LayoutGraphAsTree";
    private int iVerbose = 0;
    private String strKeyNameRoot;
    private String strKeyNameLevel;
    private String strKeyNameCrossTree;
    private String strKeyNameDictCrossTree;
    String strKeyNameMaxSizeChildren;
    private int iX;
    private int iY;
    private float fXSpacing;
    private float fYSpacing;

    public LayoutGraphAsTree() {
        this._init();
    }

    private boolean _doLayoutVertex(Net net, Vertex vertex, int n) {
        Rectangle rectangle;
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._doLayoutVertex(Net," + vertex + "," + n + ")]");
        }
        boolean bl = false;
        vertex.setLocation(this.iX, this.iY);
        if (this.iVerbose >= 4) {
            System.out.println("\tat: " + this.iX + ", " + this.iY);
        }
        try {
            rectangle = vertex.getBounds(net);
        }
        catch (NotDrawableException notDrawableException) {
            System.out.println("[LayoutGraphAsTree] Vertex " + vertex + " in net " + net + " is not drawable.");
            return false;
        }
        int n2 = this.iX;
        try {
            Dimension dimension = (Dimension)vertex.systemdict.get(this.strKeyNameMaxSizeChildren);
            this.iX += (int)((float)(rectangle.width + dimension.width) * this.fXSpacing);
            Enumeration enumeration = vertex.enumerateEdges(net);
            while (enumeration.hasMoreElements()) {
                Edge edge = (Edge)enumeration.nextElement();
                if (this.iVerbose >= 4) {
                    System.out.println("\t" + edge);
                }
                Vertex vertex2 = edge.getOtherVertex(vertex);
                if (edge.systemdict.getBoolean(this.strKeyNameCrossTree)) {
                    Dict dict;
                    Dict dict2;
                    if (this.iVerbose >= 4) {
                        System.out.println("\t\tcross-tree");
                    }
                    if ((dict2 = (Dict)edge.systemdict.get(this.strKeyNameDictCrossTree)) == null) {
                        edge.systemdict.def((Object)this.strKeyNameDictCrossTree, new Dict());
                        dict2 = (Dict)edge.systemdict.get(this.strKeyNameDictCrossTree);
                    }
                    if ((dict = (Dict)dict2.get(vertex2)) == null) {
                        dict2.def((Object)vertex2, new Dict());
                        dict = (Dict)dict2.get(vertex2);
                    }
                    edge.setLocation(dict, this.iX, this.iY);
                    this.iY += (int)((float)rectangle.height * this.fYSpacing);
                    bl = true;
                    if (this.iVerbose < 4) continue;
                    System.out.println("\t\tthis.iY = " + this.iY);
                    continue;
                }
                if (vertex2.systemdict.getInteger(this.strKeyNameLevel) != n + 1) continue;
                if (this._doLayoutVertex(net, vertex2, n + 1)) {
                    bl = true;
                    continue;
                }
                this.iY += (int)((float)rectangle.height * this.fYSpacing);
                bl = true;
                if (this.iVerbose < 4) continue;
                System.out.println("\t\tthis.iY = " + this.iY);
            }
        }
        catch (VertexMissingException vertexMissingException) {
            System.out.println("[LayoutGraphAsTree._doLayoutVertex(" + net + "," + vertex + "," + n + ")] !BUG! Vertex missing exception.");
        }
        catch (KeyMissingException keyMissingException) {
            System.out.println("[LayoutGraphAsTree._doLayoutVertex(" + net + "," + vertex + "," + n + ")] !BUG! Key (" + this.strKeyNameCrossTree + ") missing exception.");
        }
        this.iX = n2;
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._doLayoutVertex(Net," + vertex + "," + n + ")] Return " + bl);
        }
        return bl;
    }

    private void _init() {
        this.strKeyNameRoot = "!!vRoot";
        this.strKeyNameLevel = "!!iLevel";
        this.strKeyNameCrossTree = "!!zCross";
        this.strKeyNameDictCrossTree = "!!dictCrossTree";
        this.strKeyNameMaxSizeChildren = "!!iMaxSizeChildren";
        this.iX = 0;
        this.iY = 0;
        this.fXSpacing = 0.7f;
        this.fYSpacing = 1.1f;
    }

    private void _setRoots(Net net) {
        block9: {
            try {
                Enumeration enumeration = net.enumerateConnectedComponents();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    Net net2 = (Net)enumeration.nextElement();
                    boolean bl = true;
                    Enumeration enumeration2 = net2.enumerateVerticesBySystemKeySetToValue((Object)this.strKeyNameRoot, true);
                    while (enumeration2.hasMoreElements()) {
                        object = (Vertex)enumeration2.nextElement();
                        ((GraphObject)object).systemdict.def((Object)this.strKeyNameRoot, bl);
                        bl = false;
                    }
                    if (bl) {
                        object = net2.enumerateVerticesBySystemKey(this.strKeyNameRoot);
                        if (object.hasMoreElements()) {
                            ((Vertex)object.nextElement()).systemdict.def((Object)this.strKeyNameRoot, true);
                        } else {
                            try {
                                net2.firstVertex().systemdict.def((Object)this.strKeyNameRoot, true);
                            }
                            catch (VertexMissingException vertexMissingException) {}
                        }
                    }
                    net2.delete();
                }
            }
            catch (NullPointerException nullPointerException) {
                if (this.iVerbose < 1) break block9;
                System.out.println("[" + strClassName + ".setRoots(" + net + ")] Warning: null net.");
            }
        }
    }

    protected void doLayoutEdges(Net net) {
    }

    protected int doLayoutLevels(Net net) {
        Vertex vertex;
        if (this.iVerbose >= 3) {
            System.out.println("[LayoutGraphAsTree.doLayoutLevels(Net)]");
        }
        int n = -1;
        net.defVertexSystemKey((Object)this.strKeyNameLevel, -1);
        net.undefEdgeSystemKey(this.strKeyNameCrossTree);
        Enumeration enumeration = net.enumerateVerticesBySystemKeySetToValue((Object)this.strKeyNameRoot, true);
        while (enumeration.hasMoreElements()) {
            vertex = (Vertex)enumeration.nextElement();
            vertex.systemdict.def((Object)this.strKeyNameLevel, 0);
            if (this.iVerbose < 4) continue;
            System.out.println("\t" + vertex + " at level 0");
        }
        try {
            n = 0;
            while (true) {
                boolean bl = false;
                Enumeration enumeration2 = net.enumerateVerticesBySystemKeySetToValue((Object)this.strKeyNameLevel, n);
                while (enumeration2.hasMoreElements()) {
                    Dimension dimension = new Dimension();
                    bl = true;
                    vertex = (Vertex)enumeration2.nextElement();
                    Enumeration enumeration3 = vertex.enumerateEdges(net);
                    while (enumeration3.hasMoreElements()) {
                        Dimension dimension2;
                        Edge edge = (Edge)enumeration3.nextElement();
                        Vertex vertex2 = edge.getOtherVertex(vertex);
                        int n2 = vertex2.systemdict.getInteger(this.strKeyNameLevel);
                        try {
                            dimension2 = vertex2.getSize(net);
                        }
                        catch (NotDrawableException notDrawableException) {
                            dimension2 = new Dimension(0, 0);
                        }
                        dimension.width = Math.max(dimension.width, dimension2.width);
                        dimension.height = Math.max(dimension.height, dimension2.height);
                        if (n2 <= -1) {
                            vertex2.systemdict.def((Object)this.strKeyNameLevel, n + 1);
                            edge.systemdict.def((Object)this.strKeyNameCrossTree, false);
                            continue;
                        }
                        if (n2 > n || edge.systemdict.containsKey(this.strKeyNameCrossTree)) continue;
                        edge.systemdict.def((Object)this.strKeyNameCrossTree, true);
                    }
                    vertex.systemdict.def((Object)this.strKeyNameMaxSizeChildren, dimension);
                }
                if (bl) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (VertexMissingException vertexMissingException) {
            System.out.println("[LayoutGraphAsTree.doLayoutLevels(" + net + ")] !BUG! Vertex missing exception.");
        }
        catch (KeyMissingException keyMissingException) {
            System.out.println("[LayoutGraphAsTree.doLayoutLevels(" + net + ")] !BUG! Key (" + this.strKeyNameLevel + ") missing exception.");
        }
        return n;
    }

    protected void doLayoutVertices(Net net) {
        Enumeration enumeration = net.enumerateVerticesBySystemKeySetToValue((Object)this.strKeyNameLevel, 0);
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (this._doLayoutVertex(net, vertex, 0)) continue;
            try {
                Dimension dimension = vertex.getSize();
                this.iY += (int)((float)dimension.height * this.fYSpacing);
            }
            catch (NotDrawableException notDrawableException) {}
        }
    }

    public String getKeyNameCrossTree() {
        return this.strKeyNameCrossTree;
    }

    public String getKeyNameDictCrossTree() {
        return this.strKeyNameDictCrossTree;
    }

    public String getKeyNameLevel() {
        return this.strKeyNameLevel;
    }

    public String getKeyNameRoot() {
        return this.strKeyNameRoot;
    }

    public int getVerbose() {
        return this.iVerbose;
    }

    public float getXSpaceMultiplier() {
        return this.fXSpacing;
    }

    public float getYSpaceMultiplier() {
        return this.fYSpacing;
    }

    public void layout(Net net) {
        if (this.iVerbose >= 1) {
            System.out.println("[" + strClassName + ".layout(" + net + ")] Begin...");
        }
        if (net == null) {
            return;
        }
        int n = net.sizeVertices();
        if (n == 0) {
            return;
        }
        this._setRoots(net);
        this.doLayoutLevels(net);
        this.doLayoutVertices(net);
        this.doLayoutEdges(net);
        if (this.iVerbose >= 1) {
            System.out.println("[" + strClassName + ".layout(" + net + ")] ...done.");
        }
    }

    public void layoutEdges(Net net) {
        this.doLayoutEdges(net);
    }

    public void layoutRelocateOnly(Net net) {
        this.layoutVerticesAndEdges(net);
    }

    public void layoutVerticesAndEdges(Net net) {
        if (net == null) {
            return;
        }
        int n = net.sizeVertices();
        if (n == 0) {
            return;
        }
        this.doLayoutVertices(net);
        this.doLayoutEdges(net);
    }

    public void setKeyNameCrossTree(String string) {
        this.strKeyNameCrossTree = string;
    }

    public void setKeyNameDictCrossTree(String string) {
        this.strKeyNameDictCrossTree = string;
    }

    public void setKeyNameLevel(String string) {
        this.strKeyNameLevel = string;
    }

    public void setKeyNameRoot(String string) {
        this.strKeyNameRoot = string;
    }

    public void setRoot(Net net, Vertex vertex) {
        if (this.iVerbose >= 1) {
            System.out.println("[" + strClassName + ".setRoot(" + net + "," + vertex + ")]");
        }
        if (net == null || vertex == null || net.isEmpty()) {
            return;
        }
        if (this.iVerbose >= 2) {
            System.out.println("\tbefore enumeration of components...");
        }
        Enumeration enumeration = net.enumerateConnectedComponents();
        while (enumeration.hasMoreElements()) {
            Net net2 = (Net)enumeration.nextElement();
            if (net2.contains(vertex)) {
                net2.undefVertexSystemKey(this.strKeyNameRoot);
                vertex.systemdict.def((Object)this.strKeyNameRoot, true);
            }
            net2.delete();
        }
    }

    public void setRoots(Net net) {
        this._setRoots(net);
    }

    public void setSpaceMultipliers(float f, float f2) {
        this.fXSpacing = f;
        this.fYSpacing = f2;
    }

    public void setVerbose(int n) {
        this.iVerbose = n;
    }

    public void setX0(int n) {
        this.iX = n;
    }

    public void setXSpaceMultiplier(float f) {
        this.fXSpacing = f;
    }

    public void setY0(int n) {
        this.iY = n;
    }

    public void setYSpaceMultiplier(float f) {
        this.fYSpacing = f;
    }
}

