/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.layout;

import com.ibm.graph.Edge;
import com.ibm.graph.EdgeException;
import com.ibm.graph.EdgeMissingException;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexMissingException;
import com.ibm.research.util.Coords;
import com.ibm.research.util.KeyMissingException;
import java.util.Enumeration;

public class LayoutGlowCostFunction {
    public static final int optimalEdgeLength = 50;
    public static final int infinity = 0xCCCCCCC;
    static final int nodeNodeRepulsionWeight = 100000;
    static final int nodeEdgeRepulsionWeight = 100000;
    static final int attractionWeight = 10;
    static final int intersectionWeight = 1000;

    private int _cost(Net net, Vertex vertex, int n, int n2, Edge edge) throws VertexMissingException {
        int n3;
        try {
            Vertex vertex2 = edge.getOtherVertex(vertex);
            int n4 = vertex2.systemdict.getInteger("x");
            int n5 = vertex2.systemdict.getInteger("y");
            n3 = this.edgeAttraction(n, n2, n4, n5);
            Enumeration enumeration = net.enumerateVertices();
            while (enumeration.hasMoreElements()) {
                Vertex vertex3 = (Vertex)enumeration.nextElement();
                if (!vertex3.systemdict.getBoolean("!!placed") || vertex3 == vertex || vertex3 == vertex2) continue;
                n3 += this.nodeSegmentRepulsion(vertex3.systemdict.getInteger("x"), vertex3.systemdict.getInteger("y"), n, n2, n4, n5);
            }
        }
        catch (KeyMissingException keyMissingException) {
            throw new Error("NotPlaced");
        }
        return n3;
    }

    public int cost(Net net, Edge edge) throws EdgeMissingException {
        return this.cost(net, edge, 0xCCCCCCC);
    }

    public int cost(Net net, Edge edge, int n) {
        Object object;
        Vertex vertex = edge.getFromVertex();
        Vertex vertex2 = edge.getToVertex();
        int n2 = this.edgeAttraction(edge);
        if (n2 >= n) {
            return n;
        }
        Enumeration enumeration = net.enumerateVertices();
        while (n2 < n && enumeration.hasMoreElements()) {
            object = (Vertex)enumeration.nextElement();
            try {
                if (!((GraphObject)object).systemdict.getBoolean("!!placed")) {
                }
            }
            catch (KeyMissingException keyMissingException) {}
            continue;
            if (object == vertex || object == vertex2) continue;
            try {
                n2 += this.nodeEdgeRepulsion(((GraphObject)object).systemdict.getInteger("x"), ((GraphObject)object).systemdict.getInteger("y"), edge);
            }
            catch (KeyMissingException keyMissingException) {
                throw new Error("NotPlaced");
            }
        }
        if (n2 >= n) {
            return n;
        }
        object = net.enumerateEdges();
        while (n2 < n && object.hasMoreElements()) {
            Edge edge2 = (Edge)object.nextElement();
            try {
                if (!edge2.systemdict.getBoolean("!!placed")) {
                }
            }
            catch (KeyMissingException keyMissingException) {}
            continue;
            if (!this.intersect(edge, edge2)) continue;
            n2 += 1000;
        }
        return Math.min(n2, n);
    }

    public int cost(Net net, Vertex vertex, int n, int n2) throws VertexMissingException {
        return this.cost(net, vertex, n, n2, 0xCCCCCCC);
    }

    public int cost(Net net, Vertex vertex, int n, int n2, int n3) throws VertexMissingException {
        int n4;
        int n5 = 0;
        Enumeration enumeration = net.enumerateVertices();
        while (n5 < n3 && enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            try {
                if (!vertex2.systemdict.getBoolean("!!placed") || vertex2 == vertex) continue;
                n5 += this.nodeNodeRepulsion(n, n2, vertex2.systemdict.getInteger("x"), vertex2.systemdict.getInteger("y"));
            }
            catch (KeyMissingException keyMissingException) {}
        }
        if (n5 >= n3) {
            n4 = n3;
        } else {
            Edge edge;
            Enumeration enumeration2 = net.enumerateEdges();
            while (n5 < n3 && enumeration2.hasMoreElements()) {
                edge = (Edge)enumeration2.nextElement();
                if (edge.isLoop()) continue;
                try {
                    if (!edge.systemdict.getBoolean("!!placed")) continue;
                    n5 += this.nodeEdgeRepulsion(n, n2, edge);
                }
                catch (KeyMissingException keyMissingException) {}
            }
            if (n5 >= n3) {
                n4 = n3;
            } else {
                Enumeration enumeration3 = vertex.enumerateEdges();
                while (n5 < n3 && enumeration3.hasMoreElements()) {
                    edge = (Edge)enumeration3.nextElement();
                    try {
                        if (!edge.getOtherVertex((Vertex)vertex).systemdict.getBoolean("!!placed")) continue;
                        n5 += this.cost(net, vertex, n, n2, edge);
                    }
                    catch (KeyMissingException keyMissingException) {
                    }
                    catch (EdgeMissingException edgeMissingException) {
                    }
                    catch (EdgeException edgeException) {}
                }
                n4 = Math.min(n5, n3);
            }
        }
        return n4;
    }

    public int cost(Net net, Vertex vertex, int n, int n2, Edge edge) throws VertexMissingException, EdgeMissingException, EdgeException {
        return this.cost(net, vertex, n, n2, edge, 0xCCCCCCC);
    }

    public int cost(Net net, Vertex vertex, int n, int n2, Edge edge, int n3) throws VertexMissingException {
        return Math.min(this._cost(net, vertex, n, n2, edge), n3);
    }

    public int cost(Net net, Vertex vertex, Coords coords) throws VertexMissingException {
        int n = this.cost(net, vertex, coords, 0xCCCCCCC);
        return n;
    }

    public int cost(Net net, Vertex vertex, Coords coords, int n) throws VertexMissingException {
        return this.cost(net, vertex, coords.x(), coords.y(), n);
    }

    private int distance(int n, int n2, int n3, int n4) {
        return this.length(n - n3, n2 - n4);
    }

    private int distance(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n - n3;
        int n8 = n2 - n4;
        int n9 = n5 - n3;
        int n10 = n6 - n4;
        int n11 = n7 * n9 + n8 * n10;
        int n12 = this.length(n9, n10);
        if (n12 == 0) {
            return 0;
        }
        int n13 = n11 * n9 / n12;
        int n14 = n11 * n10 / n12;
        if (n11 < 0) {
            return this.length(n7, n8);
        }
        if (Math.abs(n13) > Math.abs(n9) || Math.abs(n14) > Math.abs(n10)) {
            return this.distance(n, n2, n5, n6);
        }
        return this.distance(n7, n8, n13, n14);
    }

    private int edgeAttraction(int n, int n2, int n3, int n4) {
        return 10 * this.distance(n, n2, n3, n4);
    }

    private int edgeAttraction(Edge edge) {
        int n;
        int n2;
        int n3;
        int n4;
        Vertex vertex = edge.getFromVertex();
        Vertex vertex2 = edge.getToVertex();
        try {
            n4 = vertex.systemdict.getInteger("x");
            n3 = vertex.systemdict.getInteger("y");
            n2 = vertex2.systemdict.getInteger("x");
            n = vertex2.systemdict.getInteger("y");
        }
        catch (KeyMissingException keyMissingException) {
            throw new Error("NotPlaced");
        }
        return this.edgeAttraction(n4, n3, n2, n);
    }

    private boolean intersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = (n3 - n) * (n6 - n2) - (n5 - n) * (n4 - n2);
        int n10 = (n3 - n) * (n8 - n2) - (n7 - n) * (n4 - n2);
        int n11 = (n7 - n5) * (n2 - n6) - (n - n5) * (n8 - n6);
        int n12 = (n7 - n5) * (n4 - n6) - (n3 - n5) * (n8 - n6);
        return n9 * n10 < 0 && n11 * n12 <= 0 || n9 * n10 <= 0 && n11 * n12 < 0;
    }

    private boolean intersect(Edge edge, Edge edge2) {
        Vertex vertex = edge.getFromVertex();
        Vertex vertex2 = edge.getToVertex();
        Vertex vertex3 = edge2.getFromVertex();
        Vertex vertex4 = edge2.getToVertex();
        try {
            int n = vertex.systemdict.getInteger("x");
            int n2 = vertex.systemdict.getInteger("y");
            int n3 = vertex2.systemdict.getInteger("x");
            int n4 = vertex2.systemdict.getInteger("y");
            int n5 = vertex3.systemdict.getInteger("x");
            int n6 = vertex3.systemdict.getInteger("y");
            int n7 = vertex4.systemdict.getInteger("x");
            int n8 = vertex4.systemdict.getInteger("y");
            return this.intersect(n, n2, n3, n4, n5, n6, n7, n8);
        }
        catch (KeyMissingException keyMissingException) {
            throw new Error("NotPlaced");
        }
    }

    private int length(int n, int n2) {
        return n * n + n2 * n2;
    }

    private int nodeEdgeRepulsion(int n, int n2, Edge edge) {
        Vertex vertex = edge.getFromVertex();
        Vertex vertex2 = edge.getToVertex();
        try {
            return this.nodeSegmentRepulsion(n, n2, vertex.systemdict.getInteger("x"), vertex.systemdict.getInteger("y"), vertex2.systemdict.getInteger("x"), vertex2.systemdict.getInteger("y"));
        }
        catch (KeyMissingException keyMissingException) {
            throw new Error("NotPlaced");
        }
    }

    private int nodeNodeRepulsion(int n, int n2, int n3, int n4) {
        int n5 = this.distance(n, n2, n3, n4);
        if (n5 == 0) {
            return 0xCCCCCCC;
        }
        return 100000 / n5;
    }

    private int nodeSegmentRepulsion(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.distance(n, n2, n3, n4, n5, n6);
        if (n7 == 0) {
            return 0xCCCCCCC;
        }
        return 100000 / n7;
    }
}

