/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.layout;

import com.ibm.graph.Edge;
import com.ibm.graph.Graph;
import com.ibm.graph.GraphDraw;
import com.ibm.graph.GraphLayoutManager;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexMissingException;
import com.ibm.graph.draw.Draw3VertexRectangle;
import com.ibm.graph.draw.DrawNet;
import com.ibm.graph.layout.xy;
import com.ibm.research.util.KeyMissingException;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class LayoutGlow97
implements GraphLayoutManager {
    public static final int LEFT_RIGHT = 0;
    public static final int TOP_BOTTOM = 1;
    public static final int CC_GLOW97 = 10;
    private static final String strClassName = "LayoutGlow97";
    private double dRepulsionConstant = 1.0E7;
    private int _iGutterBetweenConnectedComponents = 100;
    private double optEdgeLength = 100.0;
    private double epsilon = 1.0E-6;
    private int _iLayoutForConnectedComponents = 0;
    private int _iCountImproveVertexLocation = 20;
    private int _iCountFindBestEnergyVertexLocation = 20;
    private boolean _zIncremental;
    private String strKeyPlaced = "!!placed";

    private Enumeration _enumeratePlacedNeighborNodes(Net net, Vertex vertex) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = vertex.enumerateNeighbors(net);
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            if (!this._isPlaced(vertex2)) continue;
            vector.addElement(vertex2);
        }
        return vector.elements();
    }

    private Enumeration _enumeratePlacedNodes(Net net) {
        return net.enumerateVerticesBySystemKeySetToValue((Object)this.strKeyPlaced, true);
    }

    private boolean _isPlaced(Vertex vertex) {
        try {
            return vertex.systemdict.getBoolean(this.strKeyPlaced);
        }
        catch (KeyMissingException keyMissingException) {
            return false;
        }
    }

    private void _layout(Net net) {
        if (net != null) {
            if (!net.isEmpty()) {
                switch (this._iLayoutForConnectedComponents) {
                    case 10: {
                        this._layoutCC_GLOW97(net);
                        break;
                    }
                    default: {
                        this._layoutDefault(net);
                        break;
                    }
                }
            } else {
                System.out.println("!![LayoutGlow97.layout(Net)] Net is empty.");
            }
        } else {
            System.out.println("!?[LayoutGlow97.layout(Net)] Net is null.");
        }
    }

    private void _layoutCC_GLOW97(Net net) {
        Net net2;
        int n = 0;
        Enumeration enumeration = net.enumerateConnectedComponents();
        n = net.getEnumerationSize();
        Vector<Net> vector = new Vector<Net>(n);
        while (enumeration.hasMoreElements()) {
            net2 = (Net)enumeration.nextElement();
            vector.addElement(net2);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            net2 = (Net)enumeration.nextElement();
            this.layoutConnectedNet(net2, 0, 0);
        }
        if (n > 1) {
            net2 = new Graph();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Net net3 = (Net)enumeration.nextElement();
                Vertex vertex = new Vertex();
                try {
                    vertex.setDrawable(new Draw3VertexRectangle(net3.getSize()));
                }
                catch (NotDrawableException notDrawableException) {
                    notDrawableException.printStackTrace();
                }
                net2.add(vertex);
            }
            ((Graph)net2).makeClique();
            double d = this.optEdgeLength;
            this.optEdgeLength = 200.0;
            this.layoutConnectedNet(net2, 0, 0);
            this.optEdgeLength = d;
            int n2 = 0;
            while (n2 < n) {
                Net net4 = (Net)vector.elementAt(n2);
                try {
                    Vertex vertex = net2.indexVertex(n2);
                    Point point = vertex.getLocation();
                    DrawNet.translate(net4, point.x, point.y);
                }
                catch (VertexMissingException vertexMissingException) {
                    vertexMissingException.printStackTrace();
                }
                catch (NotDrawableException notDrawableException) {
                    notDrawableException.printStackTrace();
                }
                ++n2;
            }
            net2.clear();
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            net2 = (Net)enumeration.nextElement();
            net2.delete();
        }
    }

    private void _layoutDefault(Net net) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        Enumeration enumeration = net.enumerateConnectedComponents();
        while (enumeration.hasMoreElements()) {
            Net net2 = (Net)enumeration.nextElement();
            this.layoutConnectedNet(net2, 0, 0);
            try {
                Rectangle rectangle = net2.getBounds();
                if (!bl) {
                    switch (this._iLayoutForConnectedComponents) {
                        case 0: {
                            DrawNet.translate(net2, n - rectangle.x, n2 - rectangle.y);
                            n += rectangle.width + this._iGutterBetweenConnectedComponents;
                            break;
                        }
                        case 1: {
                            DrawNet.translate(net2, n2 - rectangle.y, 0);
                            n2 += rectangle.height + this._iGutterBetweenConnectedComponents;
                            break;
                        }
                        default: {
                            System.out.println("[LayoutGlow97.layout(Net)] Invalid layout for connected components(" + this._iLayoutForConnectedComponents + ").");
                            break;
                        }
                    }
                } else {
                    switch (this._iLayoutForConnectedComponents) {
                        case 0: {
                            n = rectangle.x + rectangle.width + this._iGutterBetweenConnectedComponents;
                            n2 = rectangle.y;
                            break;
                        }
                        case 1: {
                            n2 = rectangle.y + rectangle.height + this._iGutterBetweenConnectedComponents;
                            break;
                        }
                        default: {
                            System.out.println("[LayoutGlow97.layout(Net)] Invalid layout for connected components(" + this._iLayoutForConnectedComponents + ").");
                        }
                    }
                    bl = false;
                }
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println("[LayoutGlow97.layout(Net)] " + notDrawableException);
            }
            net2.delete();
        }
    }

    private void _placeNode(Net net, Vertex vertex, int n, int n2) {
        vertex.setLocation(n, n2);
        vertex.systemdict.def((Object)this.strKeyPlaced, true);
    }

    private void _setUseLocationCached(Net net, boolean bl) {
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (bl) {
                try {
                    vertex.loadLocationCached();
                }
                catch (NotDrawableException notDrawableException) {}
            } else {
                vertex.storeLocationCached();
            }
            vertex.setUseLocationCached(bl);
        }
    }

    public void cleanUp(Net net) {
        this.improveAllNodes(net);
    }

    public double energy(Net net, Vertex vertex, double d, double d2) {
        Object object;
        double d3 = 0.0;
        Enumeration enumeration = this._enumeratePlacedNodes(net);
        while (enumeration.hasMoreElements()) {
            object = (Vertex)enumeration.nextElement();
            if (vertex == object) continue;
            try {
                double d4 = d - (double)((GraphDraw)object).getLocation().x;
                double d5 = d2 - (double)((GraphDraw)object).getLocation().y;
                double d6 = d4 * d4 + d5 * d5;
                if (d6 == 0.0) {
                    d6 = this.epsilon;
                }
                d3 += this.dRepulsionConstant / d6;
            }
            catch (NotDrawableException notDrawableException) {
                throw new Error("NotPlaced");
            }
        }
        object = this._enumeratePlacedNeighborNodes(net, vertex);
        while (object.hasMoreElements()) {
            Vertex vertex2 = (Vertex)object.nextElement();
            try {
                double d7 = d - (double)vertex2.getLocation().x;
                double d8 = d2 - (double)vertex2.getLocation().y;
                double d9 = d7 * d7 + d8 * d8;
                d3 -= this.dRepulsionConstant / d9;
                double d10 = Math.sqrt(d7 * d7 + d8 * d8);
                d3 += (this.optEdgeLength - d10) * (this.optEdgeLength - d10);
            }
            catch (NotDrawableException notDrawableException) {
                throw new Error("NotPlaced");
            }
        }
        return d3;
    }

    public xy forceVector(Net net, Vertex vertex) throws NotDrawableException {
        Object object;
        xy xy2 = new xy(0.0, 0.0);
        Enumeration enumeration = this._enumeratePlacedNodes(net);
        while (enumeration.hasMoreElements()) {
            object = (Vertex)enumeration.nextElement();
            if (vertex == object) continue;
            double d = vertex.getLocation().x - ((GraphDraw)object).getLocation().x;
            double d2 = vertex.getLocation().y - ((GraphDraw)object).getLocation().y;
            double d3 = d * d + d2 * d2;
            if (d3 == 0.0) {
                d3 = this.epsilon;
            }
            xy2.x += this.dRepulsionConstant * d / d3;
            xy2.y += this.dRepulsionConstant * d2 / d3;
        }
        object = this._enumeratePlacedNeighborNodes(net, vertex);
        while (object.hasMoreElements()) {
            Vertex vertex2 = (Vertex)object.nextElement();
            double d = vertex.getLocation().x - vertex2.getLocation().x;
            double d4 = vertex.getLocation().y - vertex2.getLocation().y;
            double d5 = d * d + d4 * d4;
            if (d5 == 0.0) {
                d5 = this.epsilon;
            }
            xy2.x -= this.dRepulsionConstant * d / d5;
            xy2.y -= this.dRepulsionConstant * d4 / d5;
            double d6 = Math.sqrt(d5);
            xy2.x += d / d6 * (this.optEdgeLength - d6);
            xy2.y += d4 / d6 * (this.optEdgeLength - d6);
        }
        return xy2;
    }

    public int getGutterBetweenConnectedComponents() {
        return this._iGutterBetweenConnectedComponents;
    }

    public int getIterationsFindBestEnergyVertexLocation() {
        return this._iCountFindBestEnergyVertexLocation;
    }

    public int getIterationsImproveVertexLocation() {
        return this._iCountImproveVertexLocation;
    }

    public int getLayoutForConnectedComponents() {
        return this._iLayoutForConnectedComponents;
    }

    public double getOptimalEdgeLength() {
        return this.optEdgeLength;
    }

    public double getRepulsionConstant() {
        return this.dRepulsionConstant;
    }

    public void improveAllNodes(Net net) {
        try {
            Enumeration enumeration = this._enumeratePlacedNodes(net);
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                this.improveNode(net, vertex);
            }
        }
        catch (NotDrawableException notDrawableException) {
            throw new Error("NotPlaced");
        }
    }

    public void improveNode(Net net, Vertex vertex) throws NotDrawableException {
        xy xy2 = this.forceVector(net, vertex);
        this.quadApprox(net, vertex, xy2);
        this.quadApprox(net, vertex, xy2.perpendicular());
        this.quadApprox(net, vertex, xy.random());
    }

    public void improveOtherNodes(Net net, Vertex vertex) {
        try {
            Enumeration enumeration = this._enumeratePlacedNodes(net);
            while (enumeration.hasMoreElements()) {
                Vertex vertex2 = (Vertex)enumeration.nextElement();
                if (vertex == vertex2) continue;
                this.improveNode(net, vertex2);
            }
        }
        catch (NotDrawableException notDrawableException) {
            throw new Error("NotPlaced");
        }
    }

    public void layout(Net net) {
        if (net == null) {
            return;
        }
        this._zIncremental = false;
        this._layout(net);
    }

    private void layoutConnectedNet(Net net, int n, int n2) {
        this._setUseLocationCached(net, true);
        if (this._zIncremental) {
            Enumeration enumeration = net.enumerateVertices();
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                if (vertex.systemdict.get(this.strKeyPlaced) == null) {
                    this.placeVertex(net, vertex, n, n2);
                    continue;
                }
                try {
                    if (vertex.systemdict.getBoolean(this.strKeyPlaced)) continue;
                    this.placeVertex(net, vertex, n, n2);
                }
                catch (KeyMissingException keyMissingException) {}
            }
        } else {
            Vertex vertex;
            Enumeration enumeration = net.enumerateVertices();
            while (enumeration.hasMoreElements()) {
                vertex = (Vertex)enumeration.nextElement();
                vertex.systemdict.def((Object)this.strKeyPlaced, false);
            }
            Enumeration enumeration2 = net.enumerateEdges();
            while (enumeration2.hasMoreElements()) {
                Edge edge = (Edge)enumeration2.nextElement();
                edge.systemdict.def((Object)this.strKeyPlaced, false);
            }
            Enumeration enumeration3 = net.enumerateVertices();
            while (enumeration3.hasMoreElements()) {
                vertex = (Vertex)enumeration3.nextElement();
                this.placeVertex(net, vertex, n, n2);
            }
        }
        this._setUseLocationCached(net, false);
    }

    public void layoutIncremental(Net net) {
        if (net == null) {
            return;
        }
        this._zIncremental = true;
        this._layout(net);
    }

    public void placeVertex(Net net, Vertex vertex, int n, int n2) {
        Vertex vertex2 = vertex;
        try {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = Double.MAX_VALUE;
            int n3 = 1;
            while (n3 <= this._iCountFindBestEnergyVertexLocation) {
                double d4;
                Rectangle rectangle = net.getBounds();
                double d5 = (double)(rectangle.x - 200) + (double)(rectangle.width + 400) * Math.random();
                double d6 = this.energy(net, vertex2, d5, d4 = (double)(rectangle.y - 200) + (double)(rectangle.height + 400) * Math.random());
                if (d6 < d3) {
                    d = d5;
                    d2 = d4;
                    d3 = d6;
                }
                ++n3;
            }
            this._placeNode(net, vertex, (int)d, (int)d2);
            try {
                int n4 = 1;
                while (n4 <= this._iCountImproveVertexLocation) {
                    this.improveNode(net, vertex2);
                    ++n4;
                }
            }
            catch (NotDrawableException notDrawableException) {
                throw new Error("NotPlaced");
            }
        }
        catch (NotDrawableException notDrawableException) {
            this._placeNode(net, vertex, n, n2);
        }
    }

    public void placeVertexAt(Net net, Vertex vertex, int n, int n2) {
        Vertex vertex2 = vertex;
        if (this._isPlaced(vertex)) {
            return;
        }
        this._placeNode(net, vertex, n, n2);
        this.improveOtherNodes(net, vertex2);
    }

    private void quadApprox(Net net, Vertex vertex, xy xy2) throws NotDrawableException {
        double d;
        double d2;
        xy2 = xy2.normalize();
        double[] dArray = new double[4];
        int n = 0;
        while (n <= 3) {
            d2 = (double)vertex.getLocation().x + (double)n * xy2.x;
            d = (double)vertex.getLocation().y + (double)n * xy2.y;
            dArray[n] = this.energy(net, vertex, d2, d);
            ++n;
        }
        d2 = (dArray[1] + dArray[3]) / 2.0 - dArray[2];
        d = dArray[2] - dArray[1] - 5.0 * d2;
        double d3 = -d / (2.0 * d2);
        double d4 = (double)vertex.getLocation().x + d3 * xy2.x;
        double d5 = (double)vertex.getLocation().y + d3 * xy2.y;
        double d6 = this.energy(net, vertex, d4, d5);
        if (d6 < dArray[0]) {
            this._placeNode(net, vertex, (int)d4, (int)d5);
        }
    }

    public void setGutterBetweenConnectedComponents(int n) {
        this._iGutterBetweenConnectedComponents = n;
    }

    public void setIterationsFindBestEnergyVertexLocation(int n) {
        this._iCountFindBestEnergyVertexLocation = n;
    }

    public void setIterationsImproveVertexLocation(int n) {
        this._iCountImproveVertexLocation = n;
    }

    public void setLayoutForConnectedComponents(int n) {
        this._iLayoutForConnectedComponents = n;
    }

    public void setOptimalEdgeLength(double d) {
        this.optEdgeLength = d;
    }

    public void setRepulsionConstant(double d) {
        this.dRepulsionConstant = d;
    }

    private int square(int n) {
        return n * n;
    }
}

