/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.layout;

import com.ibm.graph.Edge;
import com.ibm.graph.GraphDraw;
import com.ibm.graph.GraphLayoutManager;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexMissingException;
import com.ibm.graph.layout.LayoutGlowCostFunction;
import com.ibm.research.util.Coords;
import com.ibm.research.util.KeyMissingException;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;

public class LayoutGlow
implements GraphLayoutManager {
    private LayoutGlowCostFunction costf;
    private int infinity;
    private int iXCenter = 0;
    private int iYCenter = 0;
    private int iDebug = 0;
    private String strClassName = "LayoutGlow";
    private int iVerbose = 0;

    public LayoutGlow(LayoutGlowCostFunction layoutGlowCostFunction) {
        this(layoutGlowCostFunction, 0, 0);
    }

    public LayoutGlow(LayoutGlowCostFunction layoutGlowCostFunction, int n, int n2) {
        this.costf = layoutGlowCostFunction;
        this.infinity = 0xCCCCCCC;
        this.iXCenter = n;
        this.iYCenter = n2;
    }

    private void _out(String string, String string2, String string3) {
        System.out.println("[" + this.strClassName + "." + string + "(" + string2 + ")]" + string3);
    }

    private String _placeNodeMethod(Net net, Vertex vertex, Coords coords) {
        return "[" + this.strClassName + ".placeNode(" + "Net" + "," + vertex + "," + coords + ")]";
    }

    private Coords biggestSlot(Net net, Vertex vertex) {
        double d;
        Coords coords;
        Coords coords2;
        Vertex vertex2;
        if (this.iDebug > 0) {
            System.out.println("[Layout.biggestSlot(*," + vertex + ")]");
        }
        Enumeration enumeration = this.sortedPlacedNeighborNodes(net, vertex);
        Vertex vertex3 = vertex2 = (Vertex)enumeration.nextElement();
        double d2 = 1.0;
        Coords coords3 = this.coords(vertex);
        Coords coords4 = this.coords(vertex);
        int n = coords4.x();
        int n2 = coords4.y();
        while (enumeration.hasMoreElements()) {
            Vertex vertex4;
            coords2 = this.coords(vertex3).minus(coords4);
            d = (double)coords2.dot(coords = this.coords(vertex4 = (Vertex)enumeration.nextElement()).minus(coords4)) / (coords2.magnitude() * coords.magnitude());
            if (d < d2) {
                d2 = d;
                coords3 = Coords.bisection(coords4, this.coords(vertex3), this.coords(vertex4));
            }
            vertex3 = vertex4;
        }
        coords2 = this.coords(vertex3).minus(coords4);
        d = (double)coords2.dot(coords = this.coords(vertex2).minus(coords4)) / (coords2.magnitude() * coords.magnitude());
        if (d < d2) {
            Coords coords5 = Coords.bisection(coords4, this.coords(vertex3), this.coords(vertex2));
            if (this.iDebug > 1) {
                System.out.println("[Layout.biggestSlot()] " + coords5);
            }
            return coords5;
        }
        if (this.iDebug > 0) {
            System.out.println("[Layout.biggestSlot()] " + coords3);
        }
        return coords3;
    }

    private Coords coords(Vertex vertex) {
        try {
            return new Coords(vertex.systemdict.getInteger("x"), vertex.systemdict.getInteger("y"));
        }
        catch (KeyMissingException keyMissingException) {
            System.out.println("[" + this.strClassName + ".coords()] Key x or y missing.");
            return new Coords(0, 0);
        }
    }

    private Coords findSlot(Net net, Vertex vertex, Vertex vertex2) {
        int n;
        int n2;
        block14: {
            if (this.iDebug > 0) {
                System.out.println("[" + this.strClassName + ".findSlot(" + "*" + "," + vertex + "," + vertex2 + ")]");
            }
            n2 = 0;
            n = 0;
            try {
                try {
                    int n3 = vertex2.systemdict.getInteger("x");
                    int n4 = vertex2.systemdict.getInteger("y");
                    int n5 = 0;
                    int n6 = 0;
                    Enumeration enumeration = net.enumerateEdges(vertex, vertex2);
                    while (enumeration.hasMoreElements()) {
                        Edge edge = (Edge)enumeration.nextElement();
                        Dimension dimension = null;
                        try {
                            dimension = edge.getLabelSize(net);
                        }
                        catch (NotDrawableException notDrawableException) {}
                        n5 = Math.max(n5, dimension != null ? dimension.width : 0);
                        n6 = Math.max(n6, dimension != null ? dimension.height : 0);
                    }
                    int n7 = 50 + n5;
                    int n8 = 50 + n6;
                    if (this.iDebug > 1) {
                        System.out.println("\tx = " + n3 + "\ty = " + n4 + "\tw = " + n7 + "\th = " + n8);
                    }
                    if (this.costf.cost(net, vertex, n3 + n7, n4) < this.infinity) {
                        n2 = n3 + n7;
                        n = n4;
                        break block14;
                    }
                    if (this.costf.cost(net, vertex, n3 - n7, n4) < this.infinity) {
                        n2 = n3 - n7;
                        n = n4;
                        break block14;
                    }
                    if (this.costf.cost(net, vertex, n3, n4 + n8) < this.infinity) {
                        n2 = n3;
                        n = n4 + n8;
                        break block14;
                    }
                    if (this.costf.cost(net, vertex, n3, n4 - n8) < this.infinity) {
                        n2 = n3;
                        n = n4 - n8;
                        break block14;
                    }
                    return this.biggestSlot(net, vertex2);
                }
                catch (KeyMissingException keyMissingException) {
                    System.out.println("[" + this.strClassName + ".findSlot()] Key missing exception.");
                }
            }
            catch (VertexMissingException vertexMissingException) {
                System.out.println("[" + this.strClassName + ".findSlot()] Vertex missing exception.");
            }
        }
        if (this.iDebug > 0) {
            System.out.println("[" + this.strClassName + ".findSlot()] (" + n2 + "," + n + ")");
        }
        return new Coords(n2, n);
    }

    private boolean isPlaced(Vertex vertex) {
        try {
            return vertex.systemdict.getBoolean("!!placed");
        }
        catch (KeyMissingException keyMissingException) {
            return false;
        }
    }

    public void layout(Net net) {
        Vertex vertex;
        if (this.iVerbose > 0) {
            System.out.println("[LayoutGlow.layout(" + net + ")]{");
        }
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            vertex = (Vertex)enumeration.nextElement();
            vertex.systemdict.def((Object)"!!placed", false);
        }
        Enumeration enumeration2 = net.enumerateEdges();
        while (enumeration2.hasMoreElements()) {
            Edge edge = (Edge)enumeration2.nextElement();
            edge.systemdict.def((Object)"!!placed", false);
        }
        boolean bl = true;
        Enumeration enumeration3 = net.enumerateVertices();
        while (enumeration3.hasMoreElements()) {
            vertex = (Vertex)enumeration3.nextElement();
            this.placeNode(net, vertex, bl);
            bl = false;
        }
        if (this.iVerbose > 0) {
            System.out.println("[LayoutGlow.layout(" + net + ")]}");
        }
    }

    private Coords newComponentCoords(Net net) {
        if (this.iDebug > 0) {
            System.out.println("[" + this.strClassName + ".newComponentCoords()]");
        }
        try {
            int n = net.getBounds().x;
            int n2 = net.getBounds().x + net.getBounds().width;
            int n3 = net.getBounds().width;
            int n4 = net.getBounds().y;
            int n5 = net.getBounds().y + net.getBounds().height;
            if (this.iDebug > 1) {
                System.out.println("\tminX = " + n + "\tmaxX = " + n2 + "\twidth = " + n3);
            }
            if (n2 > -n) {
                return new Coords(n2 + n3 / 3, (n4 + n5) / 2);
            }
            return new Coords(n2 + n3 / 3, (n4 + n5) / 2);
        }
        catch (NotDrawableException notDrawableException) {
            return new Coords(this.iXCenter, this.iYCenter);
        }
    }

    private boolean noPlacedVertices(Net net) {
        boolean bl = false;
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            try {
                if (!vertex.systemdict.getBoolean("!!placed")) continue;
                bl = true;
                break;
            }
            catch (KeyMissingException keyMissingException) {}
        }
        return bl;
    }

    private void placeNode(Net net, Vertex vertex, Coords coords) {
        if (this.iVerbose > 0) {
            System.out.println(String.valueOf(this._placeNodeMethod(net, vertex, coords)) + "{");
        }
        if (!this.isPlaced(vertex)) {
            if (this.iVerbose > 0) {
                System.out.println("\tbefore try block");
            }
            try {
                int n;
                int n2;
                Object object;
                int n3 = coords.x();
                int n4 = coords.y();
                int n5 = vertex.getSize((Net)net).width;
                int n6 = vertex.getSize((Net)net).height;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 50;
                if (this.iVerbose > 0) {
                    System.out.println("\tbefore enumeration 1");
                }
                Enumeration enumeration = this.placedNodes(net);
                while (enumeration.hasMoreElements()) {
                    object = (Vertex)enumeration.nextElement();
                    try {
                        int n12 = ((GraphObject)object).systemdict.getInteger("x");
                        n2 = ((GraphObject)object).systemdict.getInteger("y");
                        n = ((GraphDraw)object).getSize().width;
                        int n13 = ((GraphDraw)object).getSize().height;
                        int n14 = 0;
                        int n15 = 0;
                        int n16 = 0;
                        int n17 = 0;
                        if (n12 == n3 && n2 == n4) {
                            n12 = Math.random() < 0.5 ? --n12 : ++n12;
                            n2 = Math.random() < 0.5 ? --n2 : ++n2;
                        }
                        if (n12 < n3) {
                            n14 = Math.max(0, n12 + n / 2 - n7 - (n3 - n5 / 2 - n11));
                        } else if (n12 > n3) {
                            n15 = Math.max(0, n3 + n5 / 2 + n11 - (n12 - n / 2 + n8));
                        } else {
                            n14 = this.infinity;
                            n15 = this.infinity;
                        }
                        if (n2 < n4) {
                            n17 = Math.max(0, n2 + n13 / 2 - n10 - (n4 - n6 / 2 - n11));
                        } else if (n2 > n4) {
                            n16 = Math.max(0, n4 + n6 / 2 + n11 - (n2 - n13 / 2 + n9));
                        } else {
                            n17 = this.infinity;
                            n16 = this.infinity;
                        }
                        if (Math.min(Math.max(n14, n15), Math.max(n16, n17)) == 0) continue;
                        if (Math.max(n14, n15) < Math.max(n16, n17)) {
                            n7 += n14;
                            n8 += n15;
                            continue;
                        }
                        n9 += n16;
                        n10 += n17;
                    }
                    catch (KeyMissingException keyMissingException) {
                        if (this.iDebug <= 0) continue;
                        System.out.println(String.valueOf(this._placeNodeMethod(net, vertex, coords)) + " Key x or y missing from vertex" + object);
                    }
                }
                if (this.iVerbose > 0) {
                    System.out.println("\tbefore enumeration 2");
                }
                object = this.placedNodes(net);
                while (object.hasMoreElements()) {
                    Vertex vertex2 = (Vertex)object.nextElement();
                    n2 = vertex2.systemdict.getInteger("x");
                    n = vertex2.systemdict.getInteger("y");
                    if (n2 < n3) {
                        this.placeNode(vertex2, n2 - n7, n);
                    }
                    if (n2 > n3) {
                        this.placeNode(vertex2, n2 + n8, n);
                    }
                    if (n < n4) {
                        this.placeNode(vertex2, n2, n - n10);
                    }
                    if (n <= n4) continue;
                    this.placeNode(vertex2, n2, n + n9);
                }
                this.placeNode(vertex, coords);
            }
            catch (KeyMissingException keyMissingException) {
                System.out.println(String.valueOf(this._placeNodeMethod(net, vertex, coords)) + " Key missing exception.");
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println(String.valueOf(this._placeNodeMethod(net, vertex, coords)) + " Not drawable exception:" + notDrawableException.getMessage());
            }
        }
        if (this.iVerbose > 0) {
            System.out.println(String.valueOf(this._placeNodeMethod(net, vertex, coords)) + "}");
        }
    }

    private void placeNode(Net net, Vertex vertex, boolean bl) {
        block24: {
            if (this.iVerbose > 0) {
                System.out.println("[" + this.strClassName + ".placeNode(" + net.getName() + "," + vertex + "," + bl + ")]{");
            }
            if (this.isPlaced(vertex)) {
                return;
            }
            if (this.iDebug > 1) {
                System.out.println(vertex.systemdict);
            }
            try {
                Object object;
                if (bl) {
                    this.placeNode(vertex, this.iXCenter, this.iYCenter);
                    break block24;
                }
                int n = this.placedDegree(net, vertex);
                Enumeration enumeration = this.placedNeighborNodes(net, vertex);
                if (n == 0) {
                    this.placeNode(vertex, this.newComponentCoords(net));
                    break block24;
                }
                if (n == 1) {
                    this.placeNode(net, vertex, this.findSlot(net, vertex, (Vertex)enumeration.nextElement()));
                    break block24;
                }
                if (n == 2) {
                    Coords coords;
                    Coords coords2 = this.coords((Vertex)enumeration.nextElement());
                    Coords coords3 = Coords.midpoint(coords2, coords = this.coords((Vertex)enumeration.nextElement()));
                    if (this.costf.cost(net, vertex, coords3) < this.infinity) {
                        this.placeNode(net, vertex, coords3);
                        break block24;
                    }
                    Coords coords4 = coords2.minus(coords).rotate90().normalize(50.0);
                    int n2 = 1;
                    while (true) {
                        if (this.costf.cost(net, vertex, coords3.plus(coords4.scale(n2))) < this.infinity) {
                            this.placeNode(net, vertex, coords3.plus(coords4.scale(n2)));
                            break block24;
                        }
                        if (this.costf.cost(net, vertex, coords3.minus(coords4.scale(n2))) < this.infinity) {
                            this.placeNode(net, vertex, coords3.plus(coords4.scale(n2)));
                            break block24;
                        }
                        ++n2;
                    }
                }
                int n3 = 0;
                int n4 = 0;
                while (enumeration.hasMoreElements()) {
                    object = (Vertex)enumeration.nextElement();
                    if (this.iDebug > 1) {
                        System.out.println("..." + object);
                    }
                    try {
                        n3 += ((GraphObject)object).systemdict.getInteger("x");
                        n4 += ((GraphObject)object).systemdict.getInteger("y");
                    }
                    catch (KeyMissingException keyMissingException) {
                        System.out.println("[" + this.strClassName + ".placeNode()] Key x or y missing from vertex " + object);
                    }
                }
                object = new Coords(n3 / n, n4 / n);
                if (this.costf.cost(net, vertex, (Coords)object) < this.infinity) {
                    this.placeNode(net, vertex, (Coords)object);
                    break block24;
                }
                int n5 = 1;
                while (true) {
                    Coords coords = new Coords(50 * n5, 0);
                    Coords coords5 = new Coords(0, 50 * n5);
                    if (this.costf.cost(net, vertex, ((Coords)object).plus(coords5)) < this.infinity) {
                        this.placeNode(net, vertex, ((Coords)object).plus(coords5));
                        break;
                    }
                    if (this.costf.cost(net, vertex, ((Coords)object).minus(coords5)) < this.infinity) {
                        this.placeNode(net, vertex, ((Coords)object).minus(coords5));
                        break;
                    }
                    if (this.costf.cost(net, vertex, ((Coords)object).plus(coords)) < this.infinity) {
                        this.placeNode(net, vertex, ((Coords)object).plus(coords));
                        break;
                    }
                    if (this.costf.cost(net, vertex, ((Coords)object).minus(coords)) < this.infinity) {
                        this.placeNode(net, vertex, ((Coords)object).minus(coords));
                        break;
                    }
                    ++n5;
                }
            }
            catch (VertexMissingException vertexMissingException) {
                System.out.println("[" + this.strClassName + ".placeNode()] Vertex missing exception.");
            }
        }
        if (this.iVerbose > 0) {
            System.out.println("[" + this.strClassName + ".placeNode(" + "*" + "," + vertex + "," + bl + ")] ...done.");
        }
    }

    private void placeNode(Vertex vertex, int n, int n2) {
        if (this.iDebug > 0) {
            System.out.println("[" + this.strClassName + ".placeNode(" + vertex + "," + n + "," + n2 + ")]");
        }
        vertex.systemdict.def((Object)"x", n);
        vertex.systemdict.def((Object)"y", n2);
        vertex.systemdict.def((Object)"!!placed", true);
        Enumeration enumeration = vertex.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            try {
                if (!edge.getOtherVertex((Vertex)vertex).systemdict.getBoolean("!!placed") || !edge.systemdict.containsKey("!!placed")) continue;
                edge.systemdict.def((Object)"!!placed", true);
            }
            catch (VertexMissingException vertexMissingException) {
            }
            catch (KeyMissingException keyMissingException) {}
        }
    }

    private void placeNode(Vertex vertex, Coords coords) {
        this.placeNode(vertex, coords.x(), coords.y());
    }

    private int placedDegree(Net net, Vertex vertex) {
        if (this.iDebug > 0) {
            System.out.println("[" + this.strClassName + ".placedDegree(" + "*" + "," + vertex + ")]");
        }
        int n = 0;
        Enumeration enumeration = vertex.enumerateNeighbors(net);
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            try {
                if (!vertex2.systemdict.getBoolean("!!placed")) continue;
                ++n;
            }
            catch (KeyMissingException keyMissingException) {}
        }
        if (this.iDebug > 0) {
            System.out.println("[" + this.strClassName + ".placedDegree(" + "*" + "," + vertex + ")] degree = " + n);
        }
        return n;
    }

    private Enumeration placedNeighborNodes(Net net, Vertex vertex) {
        if (this.iDebug > 0) {
            System.out.println("[" + this.strClassName + ".placedNeighborNodes(" + "*" + "," + vertex + ")]");
        }
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = vertex.enumerateNeighbors(net);
        while (enumeration.hasMoreElements()) {
            Vertex vertex2 = (Vertex)enumeration.nextElement();
            try {
                if (!vertex2.systemdict.getBoolean("!!placed")) continue;
                vector.addElement(vertex2);
            }
            catch (KeyMissingException keyMissingException) {}
        }
        if (this.iDebug > 0) {
            System.out.println("[" + this.strClassName + ".placedNeighborNodes(" + "*" + "," + vertex + ")] ...done.");
        }
        return vector.elements();
    }

    private Enumeration placedNodes(Net net) {
        if (this.iDebug > 0) {
            System.out.println("[" + this.strClassName + ".placedNodes(" + "*" + ")]");
        }
        Vector<Vertex> vector = new Vector<Vertex>();
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            try {
                if (!vertex.systemdict.getBoolean("!!placed")) continue;
                vector.addElement(vertex);
            }
            catch (KeyMissingException keyMissingException) {}
        }
        return vector.elements();
    }

    public void setCenter(int n, int n2) {
        this.iXCenter = n;
        this.iYCenter = n2;
    }

    /*
     * Unable to fully structure code
     */
    private Enumeration sortedPlacedNeighborNodes(Net var1_1, Vertex var2_2) {
        if (this.iDebug > 0) {
            System.out.println("[" + this.strClassName + ".sortedPlacedNeighborNodes(" + "*" + "," + var2_2 + ")]");
        }
        var3_3 = new Vector<E>();
        try {
            if (!this.isPlaced(var2_2)) {
                return var3_3.elements();
            }
            var4_4 = new Vector<Object>();
            var5_5 = new Vector<Object>();
            var7_6 = this.placedNeighborNodes(var1_1, var2_2);
            while (var7_6.hasMoreElements()) {
                var8_8 = (Vertex)var7_6.nextElement();
                var9_9 = var8_8.systemdict.getInteger("x");
                var10_11 = var8_8.systemdict.getInteger("y");
                var11_12 = var2_2.systemdict.getInteger("x");
                var12_13 = var2_2.systemdict.getInteger("y");
                if (var9_9 == var11_12) {
                    if (var10_11 > var12_13) {
                        var4_4.addElement(var8_8);
                        continue;
                    }
                    var5_5.addElement(var8_8);
                    continue;
                }
                var13_14 = (double)(var10_11 - var12_13) / (double)(var9_9 - var11_12);
                var6_7 = 0;
                if (var9_9 <= var11_12) ** GOTO lbl31
                while (var6_7 < var4_4.size() && ((Vertex)var4_4.elementAt((int)var6_7)).systemdict.getInteger("x") != var11_12 && (double)((((Vertex)var4_4.elementAt((int)var6_7)).systemdict.getInteger("y") - var12_13) / (((Vertex)var4_4.elementAt((int)var6_7)).systemdict.getInteger("x") - var11_12)) < var13_14) {
                    ++var6_7;
                }
                var4_4.insertElementAt(var8_8, var6_7);
                continue;
lbl-1000:
                // 1 sources

                {
                    ++var6_7;
lbl31:
                    // 2 sources

                    ** while (var6_7 < var5_5.size() && ((Vertex)var5_5.elementAt((int)var6_7)).systemdict.getInteger((Object)"x") != var11_12 && (double)((((Vertex)var5_5.elementAt((int)var6_7)).systemdict.getInteger((Object)"y") - var12_13) / (((Vertex)var5_5.elementAt((int)var6_7)).systemdict.getInteger((Object)"x") - var11_12)) < var13_14)
                }
lbl32:
                // 1 sources

                var5_5.insertElementAt(var8_8, var6_7);
            }
            var8_8 = var4_4.elements();
            while (var8_8.hasMoreElements()) {
                var3_3.addElement(var8_8.nextElement());
            }
            var9_10 = var5_5.elements();
            while (var9_10.hasMoreElements()) {
                var3_3.addElement(var9_10.nextElement());
            }
        }
        catch (KeyMissingException v0) {
            System.out.println("[" + this.strClassName + ".sortedPlacedNeighborNodes()] Key missing exception.");
        }
        return var3_3.elements();
    }
}

