/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.layout;

import com.ibm.graph.Edge;
import com.ibm.graph.GraphLayoutManager;
import com.ibm.graph.Net;
import com.ibm.graph.Vertex;
import com.ibm.graph.debug.Debug;
import com.ibm.research.util.Dict;
import java.awt.Point;
import java.util.Enumeration;

public class LayoutEdgeList
implements GraphLayoutManager {
    static final int EDGE = 0;
    static final int VERTEX_FROM = 1;
    static final int VERTEX_TO = 2;
    static final int SYSTEMDICT = 0;
    static final int NETDICT = 1;
    boolean zVerbose = true;
    int[] iaOrder;
    int[] iaOffsets;
    int iVertexLocationDictionary;
    int iXTop;
    int iYTop;
    int iDY;
    private boolean zDebug;

    public LayoutEdgeList() {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 2;
        this.iaOrder = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 100;
        nArray2[2] = 200;
        this.iaOffsets = nArray2;
        this.iVertexLocationDictionary = 0;
        this.iXTop = 80;
        this.iYTop = 80;
        this.iDY = 40;
        this.zDebug = false;
    }

    public LayoutEdgeList(int n) {
        this();
        this.setVertexLocationDictionary(n);
    }

    private void _setLocation(Net net, Edge edge, String string, int n, String string2, int n2) {
        Dict dict;
        if (this.zDebug) {
            System.out.println("[LayoutEdgeList._setLocation(" + net.getName() + "," + edge + "," + string + "," + n + "," + string2 + "," + n2 + ")]");
        }
        switch (this.iVertexLocationDictionary) {
            case 0: {
                dict = edge.systemdict;
                break;
            }
            case 1: {
                if (!edge.systemdict.containsKey(net)) {
                    edge.systemdict.def((Object)net, new Dict());
                }
                dict = (Dict)edge.systemdict.get(net);
                break;
            }
            default: {
                return;
            }
        }
        dict.def((Object)string, n);
        dict.def((Object)string2, n2);
        if (this.zDebug) {
            System.out.println("[LayoutEdgeList._setLocation(" + net.getName() + "," + edge + "," + string + "," + n + "," + string2 + "," + n2 + ")] ...done.");
        }
    }

    public int getDY() {
        return this.iDY;
    }

    public boolean getDebugFlag() {
        return this.zDebug;
    }

    public int[] getOffsets() {
        return this.iaOffsets;
    }

    public int[] getOrder() {
        return this.iaOrder;
    }

    public Point getTopPoint() {
        Point point = new Point(this.iXTop, this.iYTop);
        return point;
    }

    public boolean getVerbose() {
        return this.zVerbose;
    }

    public int getVertexLocationDictionary() {
        return this.iVertexLocationDictionary;
    }

    public void layout(Net net) {
        if (this.zDebug) {
            System.out.println("[LayoutEdgeList.layout(" + net.getName() + ")]");
        }
        int n = this.iXTop;
        int n2 = this.iYTop;
        Enumeration enumeration = net.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            Vertex vertex = edge.getFromVertex();
            Vertex vertex2 = edge.getToVertex();
            int n3 = 0;
            while (n3 < this.iaOrder.length) {
                n += this.iaOffsets.length > n3 ? this.iaOffsets[n3] : 0;
                switch (this.iaOrder[n3]) {
                    case 1: {
                        this._setLocation(net, edge, "fromX", n, "fromY", n2);
                        break;
                    }
                    case 2: {
                        this._setLocation(net, edge, "toX", n, "toY", n2);
                        break;
                    }
                    case 0: {
                        this._setLocation(net, edge, "x", n, "y", n2);
                        break;
                    }
                    default: {
                        System.out.println("[LayoutEdgeList.layout(" + net.getName() + ")] Invalid order.");
                        break;
                    }
                }
                ++n3;
            }
            n = this.iXTop;
            n2 += this.iDY;
            if (!this.zDebug) continue;
            System.out.println("\t" + edge.systemdict);
        }
        if (this.zDebug) {
            Debug.printEdgesSystemdict(net);
        }
        if (this.zDebug) {
            System.out.println("[LayoutEdgeList.layout(" + net.getName() + ")] ...done.");
        }
    }

    public void setDY(int n) {
        this.iDY = n;
    }

    public void setDebugFlag(boolean bl) {
        this.zDebug = bl;
    }

    public void setOffsets(int[] nArray) {
        this.iaOffsets = nArray;
    }

    public void setOrder(int[] nArray) {
        this.iaOrder = nArray;
    }

    public void setTopPoint(int n, int n2) {
        this.iXTop = n;
        this.iYTop = n2;
    }

    public void setTopPoint(Point point) {
        this.iXTop = point.x;
        this.iYTop = point.y;
    }

    public void setVerbose(boolean bl) {
        this.zVerbose = bl;
    }

    public void setVertexLocationDictionary(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.iVertexLocationDictionary = n;
                break;
            }
            default: {
                if (!this.zVerbose) break;
                System.out.println("[LayoutEdgeList.setVertexLocationDictionary(" + n + ")] Invalid parameter.");
            }
        }
    }
}

