/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.layout;

import com.ibm.graph.DirectedAcyclicGraph;
import com.ibm.graph.GraphLayoutManager;
import com.ibm.graph.Net;
import com.ibm.graph.layout.IDirectedAcyclicGraphByLevelLayoutManager;
import com.ibm.research.util.Throw;
import java.awt.Rectangle;
import java.util.Vector;

public class LayoutDirectedAcyclicGraphByLevel
implements GraphLayoutManager {
    private IDirectedAcyclicGraphByLevelLayoutManager _dagllm = null;
    private static final String _$strClassName = "LayoutDirectedAcyclicGraphByLevel";

    public LayoutDirectedAcyclicGraphByLevel() {
    }

    public LayoutDirectedAcyclicGraphByLevel(IDirectedAcyclicGraphByLevelLayoutManager iDirectedAcyclicGraphByLevelLayoutManager) {
        this._dagllm = iDirectedAcyclicGraphByLevelLayoutManager;
    }

    private String _layoutMethod(Net net) {
        return "layout(Net)";
    }

    public IDirectedAcyclicGraphByLevelLayoutManager getDirectedAcyclicGraphByLevelLayoutManager() {
        return this._dagllm;
    }

    public void layout(Net net) {
        DirectedAcyclicGraph directedAcyclicGraph = null;
        try {
            directedAcyclicGraph = (DirectedAcyclicGraph)net;
        }
        catch (ClassCastException classCastException) {
            if (!(net instanceof DirectedAcyclicGraph)) {
                Throw.throwIllegalArgumentException(_$strClassName, this._layoutMethod(net), "Net is not an instanceof DirectedAcyclicGraph");
            }
            System.err.println("?![LayoutDirectedAcyclicGraphByLevel." + this._layoutMethod(net) + "] ClassCastException should not have happened. BUG!?");
            return;
        }
        if (this._dagllm != null) {
            Rectangle rectangle = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            int[] nArray = this._dagllm.getLevelOrdering(directedAcyclicGraph);
            int n = 0;
            while (n < nArray.length) {
                Vector vector = this._dagllm.sortLevel(directedAcyclicGraph, nArray[n]);
                if (vector != null && !vector.isEmpty()) {
                    Rectangle rectangle2 = this._dagllm.doLevelLayout(directedAcyclicGraph, vector, rectangle);
                    switch (this._dagllm.getOrientation()) {
                        default: {
                            System.err.println("??[LayoutDirectedAcyclicGraphByLevel." + this._layoutMethod(net) + "] Orientation given by the directed-acyclic-graph layered-layout-manager plug-in not recognized.");
                            System.err.println("\tAssuming LEFT_TO_RIGHT.");
                        }
                        case 1: {
                            rectangle.width -= rectangle2.width;
                            rectangle.x += rectangle2.width;
                            break;
                        }
                        case 0: {
                            rectangle.height -= rectangle2.height;
                            rectangle.y += rectangle2.height;
                            break;
                        }
                    }
                }
                ++n;
            }
        } else {
            System.out.println("?![LayoutDirectedAcyclicGraphByLevel." + this._layoutMethod(net) + "] Directed-acyclic-graph layered-layout-manager plug-in is null.  It must be set by setDirectedAcyclicGraphByLevelLayoutManager(IDirectedAcyclicGraphByLevelLayoutManager).");
        }
    }

    public void setDirectedAcyclicGraphByLevelLayoutManager(IDirectedAcyclicGraphByLevelLayoutManager iDirectedAcyclicGraphByLevelLayoutManager) {
        this._dagllm = iDirectedAcyclicGraphByLevelLayoutManager;
    }
}

