/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.layout;

import com.ibm.graph.DirectedAcyclicGraph;
import com.ibm.graph.Drawable;
import com.ibm.graph.Edge;
import com.ibm.graph.GraphDraw;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexMissingException;
import com.ibm.graph.draw.Draw2EdgeEastToWestLineKeyColor;
import com.ibm.graph.draw.Draw2EdgeFromToRelativePolylines;
import com.ibm.graph.layout.LayoutGraphAsTree;
import com.ibm.research.geometry.Relative;
import com.ibm.research.util.KeyMissingException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;

public class LayoutDirectedAcyclicGraphAsTree
extends LayoutGraphAsTree {
    private static final String _$strClassName = "LayoutDirectedAcyclicGraphAsTree";
    private int _iVerbose = 0;
    private int iX;
    private int iY;
    private int _iXGutter = 90;
    private int _iYGutter = 10;

    public LayoutDirectedAcyclicGraphAsTree() {
        this._init();
    }

    private boolean _doLayoutVertex(Net net, Vertex vertex, int n, String string) {
        if (this._iVerbose >= 3) {
            System.out.println(this._doLayoutVertexMethod(net, vertex, n, string).append("{"));
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl2 = vertex.systemdict.getBoolean(string);
        }
        catch (KeyMissingException keyMissingException) {
            System.out.println(this._doLayoutVertexMethod(net, vertex, n, string).append("Missing \"" + string + "\" key.  BUG!"));
        }
        if (!bl2) {
            Rectangle rectangle;
            vertex.setLocation(this.iX, this.iY);
            vertex.systemdict.def((Object)string, true);
            if (this._iVerbose >= 4) {
                System.out.println("\tat: " + this.iX + ", " + this.iY);
            }
            try {
                rectangle = vertex.getBounds(net);
                if (this._iVerbose >= 4) {
                    System.out.println("\trectSize = " + rectangle);
                }
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println("[LayoutGraphAsTree] Vertex " + vertex + " in net " + net + " is not drawable.");
                return false;
            }
            int n2 = this.iX;
            try {
                Dimension dimension = (Dimension)vertex.systemdict.get(this.strKeyNameMaxSizeChildren);
                this.iX += dimension.width + this._iXGutter;
                Enumeration enumeration = vertex.enumerateEdges(net);
                while (enumeration.hasMoreElements()) {
                    Edge edge = (Edge)enumeration.nextElement();
                    if (this._iVerbose >= 4) {
                        System.out.println("\t" + edge);
                    }
                    Vertex vertex2 = edge.getOtherVertex(vertex);
                    if (this._iVerbose >= 4) {
                        System.out.println("\t\ttree-edge");
                    }
                    if (vertex2.systemdict.getInteger(super.getKeyNameLevel()) != n + 1 || !this._doLayoutVertex(net, vertex2, n + 1, string)) continue;
                    bl = true;
                }
                if (!bl) {
                    this.iY += rectangle.height + this._iYGutter;
                    bl = true;
                    if (this._iVerbose >= 4) {
                        System.out.println("\t\tthis.iY = " + this.iY);
                    }
                }
            }
            catch (VertexMissingException vertexMissingException) {
                System.out.println("[LayoutGraphAsTree._doLayoutVertex(" + net + "," + vertex + "," + n + ")] !BUG! Vertex missing exception.");
            }
            catch (KeyMissingException keyMissingException) {}
            this.iX = n2;
        }
        if (this._iVerbose >= 3) {
            System.out.println(this._doLayoutVertexMethod(net, vertex, n, string).append("} ").append(bl));
        }
        return bl;
    }

    private StringBuffer _doLayoutVertexMethod(Net net, Vertex vertex, int n, String string) {
        return new StringBuffer("[LayoutDirectedAcyclicGraphAsTree._doLayoutVertex(Net," + vertex + "," + n + "," + string + ")]");
    }

    private void _init() {
        this.iX = 0;
        this.iY = 0;
    }

    protected void doLayoutEdges(Net net) {
        if (this._iVerbose >= 2) {
            System.out.println("[LayoutDirectedAcyclicGraphAsTree.doLayoutEdges(Net)]{");
        }
        DirectedAcyclicGraph directedAcyclicGraph = (DirectedAcyclicGraph)net;
        Enumeration enumeration = directedAcyclicGraph.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            Cloneable cloneable;
            Cloneable cloneable2;
            Object object;
            Edge edge = (Edge)enumeration.nextElement();
            if (this._iVerbose >= 3) {
                System.out.println("\tedge = " + edge);
            }
            Drawable drawable = edge.getDrawable();
            String string = drawable.getClass().getName();
            if (this._iVerbose >= 3) {
                System.out.println("\tedge-drawable = " + string);
            }
            if (string.equals("com.ibm.graph.draw.Draw2EdgeFromToRelativePolylines")) {
                Relative[] relativeArray;
                try {
                    object = edge.getFromVertex();
                    cloneable2 = ((GraphDraw)object).getBounds();
                    cloneable = ((GraphDraw)object).getLocation();
                    relativeArray = new Relative[]{new Relative(((Rectangle)cloneable2).x + ((Rectangle)cloneable2).width - ((Point)cloneable).x, ((Rectangle)cloneable2).y + (((Rectangle)cloneable2).height >> 1) - ((Point)cloneable).y)};
                    ((Draw2EdgeFromToRelativePolylines)drawable).setFromRelativePolyline(relativeArray);
                }
                catch (NotDrawableException notDrawableException) {}
                try {
                    object = edge.getToVertex();
                    cloneable2 = ((GraphDraw)object).getBounds();
                    cloneable = ((GraphDraw)object).getLocation();
                    relativeArray = new Relative[]{new Relative(((Rectangle)cloneable2).x - ((Point)cloneable).x, ((Rectangle)cloneable2).y + (((Rectangle)cloneable2).height >> 1) - ((Point)cloneable).y)};
                    ((Draw2EdgeFromToRelativePolylines)drawable).setToRelativePolyline(relativeArray);
                }
                catch (NotDrawableException notDrawableException) {}
                continue;
            }
            if (!string.equals("com.ibm.graph.draw.Draw2EdgeEastToWestLineKeyColor")) continue;
            object = directedAcyclicGraph.getKeyNameLevel();
            cloneable2 = edge.getFromVertex();
            cloneable = edge.getToVertex();
            try {
                n2 = ((GraphObject)cloneable2).systemdict.getInteger(object);
                n = ((GraphObject)cloneable).systemdict.getInteger(object);
            }
            catch (KeyMissingException keyMissingException) {
                continue;
            }
            if (n - n2 > 1) {
                edge.systemdict.defIndirect(directedAcyclicGraph, ((Draw2EdgeEastToWestLineKeyColor)drawable).getKeyNameEdgeColor(), Color.white);
                continue;
            }
            try {
                Point point = ((GraphDraw)cloneable2).getLocation(directedAcyclicGraph);
                Point point2 = ((GraphDraw)cloneable).getLocation(directedAcyclicGraph);
                if (point.y <= point2.y) continue;
                edge.systemdict.defIndirect(directedAcyclicGraph, ((Draw2EdgeEastToWestLineKeyColor)drawable).getKeyNameEdgeColor(), Color.gray);
            }
            catch (NotDrawableException notDrawableException) {}
        }
        if (this._iVerbose >= 2) {
            System.out.println("[LayoutDirectedAcyclicGraphAsTree.doLayoutEdges(Net)]}");
        }
    }

    protected int doLayoutLevels(Net net) {
        Vertex vertex;
        Object object;
        if (this._iVerbose >= 1) {
            System.out.println("[LayoutDirectedAcyclicGraphAsTree.doLayoutLevels(DirectedAcyclicGraph)]{");
        }
        DirectedAcyclicGraph directedAcyclicGraph = (DirectedAcyclicGraph)net;
        if (this._iVerbose >= 1) {
            System.out.println(directedAcyclicGraph);
        }
        try {
            directedAcyclicGraph.setKeyNameLevel(super.getKeyNameLevel());
        }
        catch (NullPointerException nullPointerException) {
            return -2;
        }
        int n = directedAcyclicGraph.doLeveling();
        if (this._iVerbose >= 2) {
            System.out.print("\tlevel of deepest leaf =" + n);
        }
        directedAcyclicGraph.defEdgeSystemKey((Object)super.getKeyNameCrossTree(), false);
        int n2 = 0;
        while (n2 <= n) {
            if (this._iVerbose >= 2) {
                System.out.println("\tlevel = " + n2);
            }
            object = new Dimension();
            Enumeration enumeration = directedAcyclicGraph.enumerateVerticesBySystemKeySetToValue((Object)super.getKeyNameLevel(), n2);
            while (enumeration.hasMoreElements()) {
                vertex = (Vertex)enumeration.nextElement();
                try {
                    Dimension dimension = vertex.getSize();
                    ((Dimension)object).width = Math.max(((Dimension)object).width, dimension.width);
                    ((Dimension)object).height = Math.max(((Dimension)object).height, dimension.height);
                }
                catch (NotDrawableException notDrawableException) {}
            }
            Enumeration enumeration2 = directedAcyclicGraph.enumerateVerticesBySystemKeySetToValue((Object)super.getKeyNameLevel(), n2);
            while (enumeration2.hasMoreElements()) {
                vertex = (Vertex)enumeration2.nextElement();
                vertex.systemdict.def((Object)this.strKeyNameMaxSizeChildren, object);
            }
            ++n2;
        }
        if (this._iVerbose >= 4) {
            object = directedAcyclicGraph.enumerateVertices();
            while (object.hasMoreElements()) {
                vertex = (Vertex)object.nextElement();
                System.out.println("\tvertex = " + vertex.getName());
                System.out.println("\tmaxsizechildren = " + vertex.systemdict.get(this.strKeyNameMaxSizeChildren));
            }
        }
        if (this._iVerbose >= 1) {
            System.out.println("[LayoutDirectedAcyclicGraphAsTree.doLayoutLevels(DirectedAcyclicGraph)]} " + n);
        }
        return n;
    }

    protected void doLayoutVertices(Net net) {
        String string = net.defVertexUniqueSystemKey("%zLoc%");
        net.defVertexSystemKey((Object)string, false);
        Enumeration enumeration = net.enumerateVerticesBySystemKeySetToValue((Object)super.getKeyNameLevel(), 0);
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (this._doLayoutVertex(net, vertex, 0, string)) continue;
            try {
                Dimension dimension = vertex.getSize();
                this.iY += dimension.height + this._iYGutter;
            }
            catch (NotDrawableException notDrawableException) {}
        }
        net.undefVertexSystemKey(string);
    }

    public void setVerboseStack(Stack stack) {
        Object e;
        if (stack == null || stack.empty()) {
            return;
        }
        try {
            e = stack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return;
        }
        try {
            this._iVerbose = (Integer)e;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[LayoutDirectedAcyclicGraphAsTree.setVerboseStack(Stack)] Object (" + e + ") popped from the stack is not an Integer object.");
            return;
        }
    }

    public void setX0(int n) {
        this.iX = n;
    }

    public void setY0(int n) {
        this.iY = n;
    }
}

