/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.layout;

import com.ibm.graph.Edge;
import com.ibm.graph.GraphLayoutManager;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.VertexMissingException;
import com.ibm.research.util.KeyMissingException;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;

public class LayoutDAG
implements GraphLayoutManager {
    private static String strClassName = "LayoutDAG";
    private int iVerbose = 0;
    private String strKeyNameRoot;
    private String strKeyNameLevel;
    private String strKeyNameTraversed;
    private int iX;
    private int iY;
    private float fXSpacing;
    private float fYSpacing;
    private int iMaximumLevel;
    private int iHeightMax;

    public LayoutDAG() {
        this._init();
    }

    private void _doLayoutLevels(Net net) {
        Vertex vertex;
        this.iMaximumLevel = 0;
        if (this.iVerbose >= 3) {
            System.out.println("[LayoutDAG._doLayoutLevels(Net)]");
        }
        net.defVertexSystemKey((Object)this.strKeyNameLevel, -1);
        net.defEdgeSystemKey((Object)this.strKeyNameTraversed, false);
        Enumeration enumeration = net.enumerateVerticesBySystemKeySetToValue((Object)this.strKeyNameRoot, true);
        while (enumeration.hasMoreElements()) {
            vertex = (Vertex)enumeration.nextElement();
            vertex.systemdict.def((Object)this.strKeyNameLevel, 0);
            if (this.iVerbose < 4) continue;
            System.out.println("\t" + vertex + " at level 0");
        }
        try {
            int n = 0;
            while (true) {
                System.out.println("\tLevel: " + n);
                boolean bl = false;
                Enumeration enumeration2 = net.enumerateVerticesBySystemKeySetToValue((Object)this.strKeyNameLevel, n);
                while (enumeration2.hasMoreElements()) {
                    bl = true;
                    vertex = (Vertex)enumeration2.nextElement();
                    System.out.println("\t\t" + vertex);
                    Enumeration enumeration3 = vertex.enumerateOutgoingEdges(net);
                    while (enumeration3.hasMoreElements()) {
                        Edge edge = (Edge)enumeration3.nextElement();
                        try {
                            if (edge.systemdict.getBoolean(this.strKeyNameTraversed)) {
                                continue;
                            }
                        }
                        catch (KeyMissingException keyMissingException) {
                            System.out.println("[" + strClassName + "._doLayoutLevels(Net)] Missing key \"" + this.strKeyNameTraversed + "\" in edge (" + edge + "). !BUG!");
                        }
                        edge.systemdict.def((Object)this.strKeyNameTraversed, true);
                        Vertex vertex2 = edge.getOtherVertex(vertex);
                        vertex2.systemdict.def((Object)this.strKeyNameLevel, n + 1);
                        this.iMaximumLevel = Math.max(this.iMaximumLevel, n + 1);
                        System.out.println("\t\t\tneighbor: " + vertex2 + " set to level " + (n + 1));
                    }
                }
                if (bl) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (VertexMissingException vertexMissingException) {
            System.out.println("[LayoutDAG._doLayoutLevels(" + net + ")] !BUG! Vertex missing exception.");
        }
        net.undefEdgeSystemKey(this.strKeyNameTraversed);
    }

    private void _doLayoutLocations(Net net, Vector vector) {
        int n = 0;
        int n2 = 0;
        while (n2 <= this.iMaximumLevel) {
            Dimension dimension = (Dimension)vector.elementAt(n2);
            n += (dimension.width + 1) / 2;
            int n3 = (this.iHeightMax - dimension.height) / 2;
            Enumeration enumeration = net.enumerateVerticesBySystemKeySetToValue((Object)this.strKeyNameLevel, n2);
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                try {
                    Dimension dimension2 = vertex.getSize();
                    vertex.setLocation(n, n3 + dimension2.height / 2);
                    n3 = (int)((float)n3 + (float)dimension2.height * this.fYSpacing);
                }
                catch (NotDrawableException notDrawableException) {}
            }
            n += (int)((float)dimension.width * this.fXSpacing);
            ++n2;
        }
    }

    private Vector _getLevelBBoxes(Net net) {
        Vector<Dimension> vector = new Vector<Dimension>(this.iMaximumLevel + 1);
        this.iHeightMax = 0;
        int n = 0;
        while (n <= this.iMaximumLevel) {
            Dimension dimension = new Dimension(0, 0);
            Enumeration enumeration = net.enumerateVerticesBySystemKeySetToValue((Object)this.strKeyNameLevel, n);
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                try {
                    Dimension dimension2 = vertex.getSize();
                    dimension.height = (int)((float)dimension.height + (float)dimension2.height * this.fXSpacing);
                    dimension.width = Math.max(dimension.width, dimension2.width);
                }
                catch (NotDrawableException notDrawableException) {}
            }
            this.iHeightMax = Math.max(this.iHeightMax, dimension.height);
            vector.insertElementAt(dimension, n);
            ++n;
        }
        return vector;
    }

    private void _init() {
        this.strKeyNameRoot = "!!vRoot";
        this.strKeyNameLevel = "!!iLevel";
        this.strKeyNameTraversed = "!!zTraversed";
        this.iX = 0;
        this.iY = 0;
        this.fXSpacing = 0.7f;
        this.fYSpacing = 1.1f;
    }

    private void _setRoots(Net net) {
        block9: {
            try {
                Enumeration enumeration = net.enumerateConnectedComponents();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    Net net2 = (Net)enumeration.nextElement();
                    boolean bl = true;
                    Enumeration enumeration2 = net2.enumerateVerticesBySystemKeySetToValue((Object)this.strKeyNameRoot, true);
                    while (enumeration2.hasMoreElements()) {
                        object = (Vertex)enumeration2.nextElement();
                        ((GraphObject)object).systemdict.def((Object)this.strKeyNameRoot, bl);
                        bl = false;
                    }
                    if (bl) {
                        object = net2.enumerateVerticesBySystemKey(this.strKeyNameRoot);
                        if (object.hasMoreElements()) {
                            ((Vertex)object.nextElement()).systemdict.def((Object)this.strKeyNameRoot, true);
                        } else {
                            try {
                                net2.firstVertex().systemdict.def((Object)this.strKeyNameRoot, true);
                            }
                            catch (VertexMissingException vertexMissingException) {}
                        }
                    }
                    net2.delete();
                }
            }
            catch (NullPointerException nullPointerException) {
                if (this.iVerbose < 1) break block9;
                System.out.println("[" + strClassName + ".setRoots(" + net + ")] Warning: null net.");
            }
        }
    }

    public String getKeyNameCrossTree() {
        return this.strKeyNameTraversed;
    }

    public String getKeyNameLevel() {
        return this.strKeyNameLevel;
    }

    public String getKeyNameRoot() {
        return this.strKeyNameRoot;
    }

    public int getVerbose() {
        return this.iVerbose;
    }

    public float getXSpaceMultiplier() {
        return this.fXSpacing;
    }

    public float getYSpaceMultiplier() {
        return this.fYSpacing;
    }

    public void layout(Net net) {
        if (this.iVerbose >= 1) {
            System.out.println("[" + strClassName + ".layout(" + net + ")] Begin...");
        }
        if (net == null) {
            return;
        }
        int n = net.sizeVertices();
        if (n == 0) {
            return;
        }
        this._setRoots(net);
        this._doLayoutLevels(net);
        Vector vector = this._getLevelBBoxes(net);
        this._doLayoutLocations(net, vector);
        if (this.iVerbose >= 1) {
            System.out.println("[" + strClassName + ".layout(" + net + ")] ...done.");
        }
    }

    public void layoutRelocateOnly(Net net) {
        if (net == null) {
            return;
        }
        int n = net.sizeVertices();
        if (n == 0) {
            return;
        }
        Vector vector = this._getLevelBBoxes(net);
        this._doLayoutLocations(net, vector);
    }

    public void setKeyNameCrossTree(String string) {
        this.strKeyNameTraversed = string;
    }

    public void setKeyNameLevel(String string) {
        this.strKeyNameLevel = string;
    }

    public void setKeyNameRoot(String string) {
        this.strKeyNameRoot = string;
    }

    public void setRoot(Net net, Vertex vertex) {
        if (this.iVerbose >= 1) {
            System.out.println("[" + strClassName + ".setRoot(" + net + "," + vertex + ")]");
        }
        if (net == null || vertex == null || net.isEmpty()) {
            return;
        }
        if (this.iVerbose >= 2) {
            System.out.println("\tbefore enumeration of components...");
        }
        Enumeration enumeration = net.enumerateConnectedComponents();
        while (enumeration.hasMoreElements()) {
            Net net2 = (Net)enumeration.nextElement();
            if (net2.contains(vertex)) {
                net2.undefVertexSystemKey(this.strKeyNameRoot);
                vertex.systemdict.def((Object)this.strKeyNameRoot, true);
            }
            net2.delete();
        }
    }

    public void setRoots(Net net) {
        this._setRoots(net);
    }

    public void setSpaceMultipliers(float f, float f2) {
        this.fXSpacing = f;
        this.fYSpacing = f2;
    }

    public void setVerbose(int n) {
        this.iVerbose = n;
    }

    public void setX0(int n) {
        this.iX = n;
    }

    public void setXSpaceMultiplier(float f) {
        this.fXSpacing = f;
    }

    public void setY0(int n) {
        this.iY = n;
    }

    public void setYSpaceMultiplier(float f) {
        this.fYSpacing = f;
    }
}

