/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.ext.visual;

import com.ibm.graph.Drawable;
import com.ibm.graph.GraphDraw;
import com.ibm.graph.InvalidDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexBaseText;
import com.ibm.graph.draw.Draw3VertexCircle;
import com.ibm.graph.draw.Draw3VertexEllipse;
import com.ibm.graph.draw.Draw3VertexEllipseKeyText;
import com.ibm.graph.draw.Draw3VertexEllipseText;
import com.ibm.graph.draw.Draw3VertexFillArea;
import com.ibm.graph.draw.Draw3VertexFillAreaText;
import com.ibm.graph.draw.Draw3VertexKeyText;
import com.ibm.graph.draw.Draw3VertexRectangle;
import com.ibm.graph.draw.Draw3VertexRectangleKeyText;
import com.ibm.graph.draw.Draw3VertexRectangleText;
import com.ibm.graph.draw.Draw3VertexText;
import com.ibm.research.awt.FontMetricized;
import java.awt.Color;
import java.awt.Dimension;

public class VisualVertex
extends Vertex {
    public static final int NONE = 0;
    public static final int RECTANGLE = 1;
    public static final int CIRCLE = 2;
    public static final int ELLIPSE = 3;
    private static final String strClassName = "VisualVertex";
    private static boolean _zDoFillDefault = false;
    private static boolean _zDoBorderDefault = true;
    private static Color _colorFillDefault = Color.lightGray;
    private static Color _colorBorderDefault = Color.black;
    private static Color _colorTextDefault = Color.black;
    private static String _strFontNameDefault = "Helvetica";
    private static int _iFontStyleDefault = 0;
    private static int _iFontSizeDefault = 12;
    private static Dimension _dimSizeDefault = new Dimension(20, 10);
    private static int _iMarginLeftDefault = 10;
    private static int _iMarginRightDefault = 10;
    private static int _iMarginBottomDefault = 5;
    private static int _iMarginTopDefault = 5;

    private VisualVertex() {
    }

    public VisualVertex(int n) {
        this(n, null, _colorBorderDefault);
    }

    public VisualVertex(int n, Color color, Color color2) {
        this(n, _dimSizeDefault, color, color2);
    }

    public VisualVertex(int n, Color color, Color color2, boolean bl, String string, Color color3) {
        this(n, color, color2, bl, string, color3, _strFontNameDefault, _iFontStyleDefault, _iFontSizeDefault);
    }

    public VisualVertex(int n, Color color, Color color2, boolean bl, String string, Color color3, String string2, int n2, int n3) {
        this();
        if (!bl) {
            this._newTextDrawable(n, color, color2, string, color3, string2, n2, n3);
        } else {
            this._newKeyTextDrawable(n, color, color2, string, color3, string2, n2, n3);
        }
    }

    public VisualVertex(int n, Dimension dimension) {
        this(n, dimension, null, _colorBorderDefault);
    }

    public VisualVertex(int n, Dimension dimension, Color color, Color color2) {
        this();
        this._newDrawable(n, dimension, color, color2);
    }

    public VisualVertex(int n, boolean bl, String string) {
        this(n, null, _colorBorderDefault, bl, string, _colorTextDefault);
    }

    private void _initializeColors(Draw3VertexFillArea draw3VertexFillArea, Color color, Color color2) {
        if (color == null) {
            draw3VertexFillArea.setDoFill(false);
        } else {
            draw3VertexFillArea.setColorFill(color);
            draw3VertexFillArea.setDoFill(true);
        }
        if (color2 == null) {
            draw3VertexFillArea.setDoOutline(false);
        } else {
            draw3VertexFillArea.setColorOutline(color2);
            draw3VertexFillArea.setDoOutline(true);
        }
    }

    private void _initializeMargins(Draw3VertexFillAreaText draw3VertexFillAreaText) {
        draw3VertexFillAreaText.setMargins(_iMarginLeftDefault, _iMarginRightDefault, _iMarginBottomDefault, _iMarginTopDefault);
    }

    private void _newDrawable(int n, Dimension dimension, Color color, Color color2) {
        switch (n) {
            case 0: {
                System.out.println("[VisualVertex(" + n + ")] Invalid shape.");
                break;
            }
            case 1: {
                Draw3VertexRectangle draw3VertexRectangle = new Draw3VertexRectangle(dimension);
                draw3VertexRectangle.setVerbose(2);
                this._initializeColors(draw3VertexRectangle, color, color2);
                this.setDrawable(draw3VertexRectangle);
                break;
            }
            case 2: {
                Draw3VertexCircle draw3VertexCircle = new Draw3VertexCircle(dimension.width);
                this._initializeColors(draw3VertexCircle, color, color2);
                this.setDrawable(draw3VertexCircle);
                break;
            }
            case 3: {
                Draw3VertexEllipse draw3VertexEllipse = new Draw3VertexEllipse(dimension);
                this._initializeColors(draw3VertexEllipse, color, color2);
                this.setDrawable(draw3VertexEllipse);
                break;
            }
            default: {
                System.out.println("[VisualVertex(" + n + ")] Invalid shape.");
            }
        }
    }

    private void _newKeyTextDrawable(int n, Color color, Color color2, String string, Color color3, String string2, int n2, int n3) {
        switch (n) {
            case 0: {
                Draw3VertexKeyText draw3VertexKeyText = new Draw3VertexKeyText(string, string2, n2, n3);
                draw3VertexKeyText.setColor(color3);
                this.setDrawable(draw3VertexKeyText);
                break;
            }
            case 1: {
                this.setDrawable(new Draw3VertexRectangleKeyText(string, string2, n2, n3));
                Draw3VertexRectangleKeyText draw3VertexRectangleKeyText = new Draw3VertexRectangleKeyText(string);
                this._initializeMargins(draw3VertexRectangleKeyText);
                Draw3VertexRectangle draw3VertexRectangle = draw3VertexRectangleKeyText.getDraw3VertexRectangle();
                this._initializeColors(draw3VertexRectangle, color, color2);
                Draw3VertexKeyText draw3VertexKeyText = draw3VertexRectangleKeyText.getDraw3VertexKeyText();
                draw3VertexKeyText.setColor(color3);
                this.setDrawable(draw3VertexRectangleKeyText);
                break;
            }
            case 2: {
                System.out.println("[VisualVertex(" + n + ")] Invalid shape.");
                break;
            }
            case 3: {
                Draw3VertexEllipseKeyText draw3VertexEllipseKeyText = new Draw3VertexEllipseKeyText(string, string2, n2, n3);
                this._initializeMargins(draw3VertexEllipseKeyText);
                Draw3VertexEllipse draw3VertexEllipse = draw3VertexEllipseKeyText.getDraw3VertexEllipse();
                this._initializeColors(draw3VertexEllipse, color, color2);
                Draw3VertexKeyText draw3VertexKeyText = draw3VertexEllipseKeyText.getDraw3VertexKeyText();
                draw3VertexKeyText.setColor(color3);
                this.setDrawable(draw3VertexEllipseKeyText);
                break;
            }
            default: {
                System.out.println("[VisualVertex(" + n + ")] Invalid shape.");
            }
        }
    }

    private void _newTextDrawable(int n, Color color, Color color2, String string, Color color3, String string2, int n2, int n3) {
        switch (n) {
            case 0: {
                Draw3VertexText draw3VertexText = new Draw3VertexText(string, string2, n2, n3);
                draw3VertexText.setColor(color3);
                this.setDrawable(draw3VertexText);
                break;
            }
            case 1: {
                Draw3VertexRectangleText draw3VertexRectangleText = new Draw3VertexRectangleText(string, string2, n2, n3);
                this._initializeMargins(draw3VertexRectangleText);
                Draw3VertexRectangle draw3VertexRectangle = draw3VertexRectangleText.getDraw3VertexRectangle();
                this._initializeColors(draw3VertexRectangle, color, color2);
                Draw3VertexText draw3VertexText = draw3VertexRectangleText.getDraw3VertexText();
                draw3VertexText.setColor(color3);
                this.setDrawable(draw3VertexRectangleText);
                break;
            }
            case 2: {
                System.out.println("[VisualVertex(" + n + ")] Invalid shape.");
                break;
            }
            case 3: {
                Draw3VertexEllipseText draw3VertexEllipseText = new Draw3VertexEllipseText(string, string2, n2, n3);
                this._initializeMargins(draw3VertexEllipseText);
                Draw3VertexEllipse draw3VertexEllipse = draw3VertexEllipseText.getDraw3VertexEllipse();
                this._initializeColors(draw3VertexEllipse, color, color2);
                Draw3VertexText draw3VertexText = draw3VertexEllipseText.getDraw3VertexText();
                draw3VertexText.setColor(color3);
                this.setDrawable(draw3VertexEllipseText);
                break;
            }
            default: {
                System.out.println("[VisualVertex(" + n + ")] Invalid shape.");
            }
        }
    }

    public Color getColorBorder() throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (drawable instanceof Draw3VertexFillArea) {
            return ((Draw3VertexFillArea)drawable).getColorOutline();
        }
        throw new InvalidDrawableException();
    }

    public static Color getColorBorderDefault() {
        return _colorBorderDefault;
    }

    public Color getColorFill() throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (drawable instanceof Draw3VertexFillArea) {
            return ((Draw3VertexFillArea)drawable).getColorFill();
        }
        throw new InvalidDrawableException(drawable.getClass().getName());
    }

    public static Color getColorFillDefault() {
        return _colorFillDefault;
    }

    public Color getColorText() throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (drawable instanceof Draw3VertexBaseText) {
            return ((Draw3VertexBaseText)drawable).getColor();
        }
        throw new InvalidDrawableException();
    }

    public static Color getColorTextDefault() {
        return _colorTextDefault;
    }

    public boolean getDoBorder() throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (drawable instanceof Draw3VertexFillArea) {
            return ((Draw3VertexFillArea)drawable).getDoOutline();
        }
        throw new InvalidDrawableException();
    }

    public static boolean getDoBorderDefault() {
        return _zDoBorderDefault;
    }

    public boolean getDoFill() throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (drawable instanceof Draw3VertexFillArea) {
            return ((Draw3VertexFillArea)drawable).getDoFill();
        }
        throw new InvalidDrawableException();
    }

    public static boolean getDoFillDefault() {
        return _zDoFillDefault;
    }

    public FontMetricized getFont() throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (drawable instanceof Draw3VertexBaseText) {
            return ((Draw3VertexBaseText)drawable).getFont();
        }
        throw new InvalidDrawableException();
    }

    public static String getFontNameDefault() {
        return _strFontNameDefault;
    }

    public static int getFontSizeDefault() {
        return _iFontSizeDefault;
    }

    public static int getFontStyleDefault() {
        return _iFontStyleDefault;
    }

    public int getMarginBottom() throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (drawable instanceof Draw3VertexFillAreaText) {
            return ((Draw3VertexFillAreaText)drawable).getMarginBottom();
        }
        throw new InvalidDrawableException();
    }

    public static int getMarginBottomDefault() {
        return _iMarginBottomDefault;
    }

    public int getMarginLeft() throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (drawable instanceof Draw3VertexFillAreaText) {
            return ((Draw3VertexFillAreaText)drawable).getMarginLeft();
        }
        throw new InvalidDrawableException();
    }

    public static int getMarginLeftDefault() {
        return _iMarginLeftDefault;
    }

    public int getMarginRight() throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (drawable instanceof Draw3VertexFillAreaText) {
            return ((Draw3VertexFillAreaText)drawable).getMarginRight();
        }
        throw new InvalidDrawableException();
    }

    public static int getMarginRightDefault() {
        return _iMarginRightDefault;
    }

    public int getMarginTop() throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (drawable instanceof Draw3VertexFillAreaText) {
            return ((Draw3VertexFillAreaText)drawable).getMarginTop();
        }
        throw new InvalidDrawableException();
    }

    public static int getMarginTopDefault() {
        return _iMarginTopDefault;
    }

    public static Dimension getSizeDefault() {
        return _dimSizeDefault;
    }

    public void setColorBorder(Color color) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof Draw3VertexFillArea)) {
            throw new InvalidDrawableException();
        }
        ((Draw3VertexFillArea)drawable).setColorOutline(color);
    }

    public static void setColorBorderDefault(Color color) {
        _colorBorderDefault = color;
    }

    public void setColorFill(Color color) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof Draw3VertexFillArea)) {
            throw new InvalidDrawableException();
        }
        ((Draw3VertexFillArea)drawable).setColorFill(color);
    }

    public static void setColorFillDefault(Color color) {
        _colorFillDefault = color;
    }

    public void setColorText(Color color) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof Draw3VertexBaseText)) {
            throw new InvalidDrawableException();
        }
        ((Draw3VertexBaseText)drawable).setColor(color);
    }

    public static void setColorTextDefault(Color color) {
        _colorTextDefault = color;
    }

    public void setDoBorder(boolean bl) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof Draw3VertexFillArea)) {
            throw new InvalidDrawableException();
        }
        ((Draw3VertexFillArea)drawable).setDoOutline(bl);
    }

    public static void setDoBorderDefault(boolean bl) {
        _zDoBorderDefault = bl;
    }

    public void setDoFill(boolean bl) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof Draw3VertexFillArea)) {
            throw new InvalidDrawableException();
        }
        ((Draw3VertexFillArea)drawable).setDoFill(bl);
    }

    public static void setDoFillDefault(boolean bl) {
        _zDoFillDefault = bl;
    }

    public void setFont(String string, int n, int n2) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof Draw3VertexBaseText)) {
            throw new InvalidDrawableException();
        }
        ((Draw3VertexBaseText)drawable).setFont(string, n, n2);
    }

    public static void setFontNameDefault(String string) {
        _strFontNameDefault = string;
    }

    public static void setFontSizeDefault(int n) {
        _iFontSizeDefault = n;
    }

    public static void setFontStyleDefault(int n) {
        _iFontStyleDefault = n;
    }

    public void setMarginBottom(int n) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof Draw3VertexFillAreaText)) {
            throw new InvalidDrawableException();
        }
        ((Draw3VertexFillAreaText)drawable).setMarginBottom(n);
    }

    public static void setMarginBottomDefault(int n) {
        _iMarginBottomDefault = n;
    }

    public void setMarginLeft(int n) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof Draw3VertexFillAreaText)) {
            throw new InvalidDrawableException();
        }
        ((Draw3VertexFillAreaText)drawable).setMarginLeft(n);
    }

    public static void setMarginLeftDefault(int n) {
        _iMarginLeftDefault = n;
    }

    public void setMarginRight(int n) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof Draw3VertexFillAreaText)) {
            throw new InvalidDrawableException();
        }
        ((Draw3VertexFillAreaText)drawable).setMarginRight(n);
    }

    public static void setMarginRightDefault(int n) {
        _iMarginRightDefault = n;
    }

    public void setMarginTop(int n) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof Draw3VertexFillAreaText)) {
            throw new InvalidDrawableException();
        }
        ((Draw3VertexFillAreaText)drawable).setMarginTop(n);
    }

    public static void setMarginTopDefault(int n) {
        _iMarginTopDefault = n;
    }

    public void setMargins(int n, int n2, int n3, int n4) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof Draw3VertexFillAreaText)) {
            throw new InvalidDrawableException();
        }
        ((Draw3VertexFillAreaText)drawable).setMargins(n, n2, n3, n4);
    }

    public static void setMarginsDefault(int n, int n2, int n3, int n4) {
        _iMarginLeftDefault = n;
        _iMarginRightDefault = n2;
        _iMarginBottomDefault = n3;
        _iMarginTopDefault = n4;
    }

    public static void setSizeDefault(Dimension dimension) {
        _dimSizeDefault = dimension;
    }
}

