/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.ext.visual;

import com.ibm.graph.Drawable;
import com.ibm.graph.Edge;
import com.ibm.graph.GraphDraw;
import com.ibm.graph.InvalidDrawableException;
import com.ibm.graph.draw.DrawEdgeLine;
import com.ibm.graph.draw.DrawEdgeOrthogonalLine;
import com.ibm.graph.draw.DrawEdgePath;
import com.ibm.graph.ext.visual.VisualVertex;
import java.awt.Color;

public class VisualEdge
extends Edge {
    public static final int NONE = 0;
    public static final int STRAIGHT_LINE = 1;
    public static final int VERTICAL_HORIZONTAL = 2;
    private static final String strClassName = "VisualEdge";
    private static Color _colorPathDefault = Color.black;

    public VisualEdge(VisualVertex visualVertex, VisualVertex visualVertex2) {
        this(visualVertex, visualVertex2, 1, _colorPathDefault);
    }

    public VisualEdge(VisualVertex visualVertex, VisualVertex visualVertex2, int n) {
        this(visualVertex, visualVertex2, n, _colorPathDefault);
    }

    public VisualEdge(VisualVertex visualVertex, VisualVertex visualVertex2, int n, Color color) {
        super(visualVertex, visualVertex2);
        this._newDrawable(n, color);
    }

    private VisualEdge(VisualVertex visualVertex, VisualVertex visualVertex2, boolean bl) {
        super(visualVertex, visualVertex2, bl);
    }

    public VisualEdge(VisualVertex visualVertex, VisualVertex visualVertex2, boolean bl, int n) {
        this(visualVertex, visualVertex2, bl, n, _colorPathDefault);
    }

    public VisualEdge(VisualVertex visualVertex, VisualVertex visualVertex2, boolean bl, int n, Color color) {
        super(visualVertex, visualVertex2, bl);
        this._newDrawable(n, color);
    }

    private void _newDrawable(int n, Color color) {
        switch (n) {
            case 0: {
                System.out.println("[VisualEdge(" + n + ")] Invalid shape.");
                break;
            }
            case 1: {
                DrawEdgeLine drawEdgeLine = new DrawEdgeLine();
                drawEdgeLine.setColorPath(color);
                this.setDrawable(drawEdgeLine);
                break;
            }
            case 2: {
                DrawEdgeOrthogonalLine drawEdgeOrthogonalLine = new DrawEdgeOrthogonalLine();
                drawEdgeOrthogonalLine.setColorPath(color);
                this.setDrawable(drawEdgeOrthogonalLine);
                break;
            }
            default: {
                System.out.println("[VisualEdge(" + n + ")] Invalid shape.");
            }
        }
    }

    public Color getColorPath() throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (drawable instanceof DrawEdgePath) {
            return ((DrawEdgePath)drawable).getColorPath();
        }
        throw new InvalidDrawableException();
    }

    public static Color getColorPathDefault() {
        return _colorPathDefault;
    }

    public void setColorPath(Color color) throws InvalidDrawableException {
        Drawable drawable = GraphDraw.getDrawable(this.systemdict);
        if (!(drawable instanceof DrawEdgePath)) {
            throw new InvalidDrawableException();
        }
        ((DrawEdgePath)drawable).setColorPath(color);
    }

    public static void setColorPathDefault(Color color) {
        _colorPathDefault = color;
    }
}

