/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Drawable;
import com.ibm.graph.GraphDraw;
import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintStream;

public abstract class DrawVertex
implements Drawable {
    public static final int ALIGNMENT_BOTTOM = -1;
    public static final int ALIGNMENT_CENTER = 0;
    public static final int ALIGNMENT_TOP = 1;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = -1;
    public static final PrintStream out = System.out;
    public static final PrintStream err = System.err;
    protected static int iClassVerbose = 0;
    protected int iVerbose = 0;
    private static final String strClassName = "DrawVertex";
    private static final String _strAlignmentBottom = "ALIGNMENT_BOTTOM";
    private static final String _strAlignmentCenter = "ALIGNMENT_CENTER";
    private static final String _strAlignmentTop = "ALIGNMENT_TOP";
    private static final String _strAlignmentLeft = "ALIGNMENT_LEFT";
    private static final String _strAlignmentRight = "ALIGNMENT_RIGHT";
    private static final String _strAlignmentInvalid = "ALIGNMENT_INVALID";
    private int iAlignmentX = 0;
    private int iAlignmentY = 0;

    int _alignX(int n, int n2) {
        int n3 = n + (n2 * (this.iAlignmentX - 1) >> 1);
        if (this.iVerbose >= 3) {
            out.println("[DrawVertex._alignX(" + n + "," + n2 + ")]; " + n3);
        }
        if (this.iVerbose >= 4) {
            out.println("\tfor alignment " + this.toStringAlignmentX(this.iAlignmentX));
        }
        return n3;
    }

    int _alignY(int n, int n2) {
        int n3 = n + (n2 * (this.iAlignmentY - 1) >> 1);
        if (this.iVerbose >= 3) {
            System.out.println("[DrawVertex._alignY(" + n + "," + n2 + ")]; " + n3);
        }
        if (this.iVerbose >= 4) {
            out.println("\tfor alignment " + this.toStringAlignmentY(this.iAlignmentY));
        }
        return n3;
    }

    public boolean contains(GraphObject graphObject, int n, int n2) {
        try {
            return this.getBounds((Vertex)graphObject).contains(n, n2);
        }
        catch (NullPointerException nullPointerException) {
            if (graphObject == null) {
                System.out.println("?![DrawVertex.contains(" + graphObject + "," + n + "," + n2 + ")] Null vertex.");
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            System.out.println("?![DrawVertex.contains(" + graphObject + "," + n + "," + n2 + ")] Graph object is not an instance of Vertex.");
            return false;
        }
        catch (NotDrawableException notDrawableException) {
            return false;
        }
    }

    public void draw(GraphObject graphObject, Graphics graphics) {
        Vertex vertex;
        try {
            vertex = (Vertex)graphObject;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[DrawVertex.draw(" + graphObject + ",Graphics)] Graph object is not of class Vertex.");
            return;
        }
        try {
            this.drawVertex(vertex, graphics);
        }
        catch (NotDrawableException notDrawableException) {
            if (this.iVerbose > 0) {
                System.out.println("[DrawVertex.draw(Net," + graphObject + ",Graphics)] Not drawable: unspecified location.");
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            if (vertex == null) {
                System.out.println("[DrawVertex.draw(" + vertex + ",Graphics)] Vertex is null.");
            }
            if (graphics == null) {
                System.out.println("[DrawVertex.draw(" + vertex + ",Graphics)] Graphics is null.");
            }
            System.out.println("[DrawVertex.draw(" + vertex + ",Graphics)] Null pointer exception. [BUG?]");
            nullPointerException.printStackTrace();
            return;
        }
    }

    protected abstract void drawVertex(Vertex var1, Graphics var2) throws NotDrawableException;

    public int getAlignmentX() {
        return this.iAlignmentX;
    }

    public int getAlignmentY() {
        return this.iAlignmentY;
    }

    public Rectangle getBounds(GraphObject graphObject) throws NotDrawableException {
        Vertex vertex;
        try {
            vertex = (Vertex)graphObject;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[DrawVertex.getBounds(" + graphObject + ")] Graph object is not an instance of Vertex.");
            throw new NotDrawableException();
        }
        return this.getBoundsVertex(vertex);
    }

    protected abstract Rectangle getBoundsVertex(Vertex var1) throws NotDrawableException;

    public static int getClassVerbose() {
        return iClassVerbose;
    }

    public Dimension getSize(GraphObject graphObject) throws NotDrawableException {
        Vertex vertex;
        try {
            vertex = (Vertex)graphObject;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[DrawVertex.getSize(Net," + graphObject + ")] Graph object is not an instance of Vertex.");
            throw new NotDrawableException();
        }
        try {
            return this.getSizeVertex(vertex);
        }
        catch (NullPointerException nullPointerException) {
            if (vertex == null) {
                System.out.println("[DrawVertex.getSize(" + vertex + ")] Vertex is null.");
            }
            System.out.println("[DrawVertex.getSize(" + vertex + ")] Null pointer exception. [BUG?]");
            nullPointerException.printStackTrace();
            throw new NotDrawableException();
        }
    }

    protected abstract Dimension getSizeVertex(Vertex var1) throws NotDrawableException;

    public int getVerbose() {
        return this.iVerbose;
    }

    public static int getX(Vertex vertex) throws NotDrawableException {
        return DrawVertex.getX(vertex.systemdict);
    }

    static int getX(Dict dict) throws NotDrawableException {
        try {
            return dict.getInteger(GraphDraw.strKeyX);
        }
        catch (KeyMissingException keyMissingException) {
            throw new NotDrawableException();
        }
    }

    public static int getY(Vertex vertex) throws NotDrawableException {
        return DrawVertex.getY(vertex.systemdict);
    }

    static int getY(Dict dict) throws NotDrawableException {
        try {
            return dict.getInteger(GraphDraw.strKeyY);
        }
        catch (KeyMissingException keyMissingException) {
            throw new NotDrawableException();
        }
    }

    public void setAlignmentX(int n) {
        this.iAlignmentX = n;
    }

    public void setAlignmentY(int n) {
        this.iAlignmentY = n;
    }

    public void setAlignments(int n, int n2) {
        this.iAlignmentX = n;
        this.iAlignmentY = n2;
    }

    public static void setClassVerbose(int n) {
        iClassVerbose = n;
    }

    public void setVerbose(int n) {
        this.iVerbose = n;
    }

    public String toStringAlignmentX(int n) {
        switch (n) {
            case 1: {
                return _strAlignmentLeft;
            }
            case 0: {
                return _strAlignmentCenter;
            }
            case -1: {
                return _strAlignmentRight;
            }
        }
        return _strAlignmentInvalid;
    }

    public String toStringAlignmentY(int n) {
        switch (n) {
            case 1: {
                return _strAlignmentTop;
            }
            case 0: {
                return _strAlignmentCenter;
            }
            case -1: {
                return _strAlignmentBottom;
            }
        }
        return _strAlignmentInvalid;
    }
}

