/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Drawable;
import com.ibm.graph.DrawableNet;
import com.ibm.graph.Edge;
import com.ibm.graph.GraphDraw;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;

public class DrawNetVisibleEdgesThenVisibleVertices
implements DrawableNet {
    private static final String _$strClassName = "DrawNetVisibleEdgesThenVisibleVertices";
    private static String _$strKeyVisibleDefault = "%zVisible%";
    private static boolean _$zForceNetDictDefault = false;
    private String _strKeyVisible = _$strKeyVisibleDefault;
    private boolean _zForceNetDict = _$zForceNetDictDefault;
    private int _iVerbose = 0;

    private final String _drawMethod(GraphObject graphObject, Graphics graphics, String string) {
        return "[DrawNetVisibleEdgesThenVisibleVertices.draw(" + graphObject + ",Graphics)]" + string;
    }

    private Rectangle _getBounds(Net net) throws NotDrawableException {
        Rectangle rectangle = null;
        if (net == null) {
            return rectangle;
        }
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            if (!this.isVisible(net, vertex)) continue;
            try {
                if (vertex.getBounds((Net)net).x == 0 && vertex.getBounds((Net)net).y == 0) {
                    vertex.getLocation(net);
                }
                if (rectangle == null) {
                    rectangle = new Rectangle(vertex.getBounds(net));
                    continue;
                }
                rectangle.add(vertex.getBounds(net));
            }
            catch (NotDrawableException notDrawableException) {}
        }
        Enumeration enumeration2 = net.enumerateEdges();
        while (enumeration2.hasMoreElements()) {
            Edge edge = (Edge)enumeration2.nextElement();
            if (!this.isVisible(net, edge)) continue;
            try {
                Rectangle rectangle2 = edge.getBounds(net);
                if (rectangle2 == null || rectangle2.x == 0 && rectangle2.y == 0 && rectangle2.width == 0 && rectangle2.height == 0) continue;
                if (rectangle == null) {
                    rectangle = new Rectangle(rectangle2);
                    continue;
                }
                rectangle.add(rectangle2);
            }
            catch (NotDrawableException notDrawableException) {}
        }
        if (rectangle == null) {
            throw new NotDrawableException("[DrawNetVisibleEdgesThenVisibleVertices]");
        }
        return rectangle;
    }

    private final String _getBoundsMethod(GraphObject graphObject, String string) {
        return "[DrawNetVisibleEdgesThenVisibleVertices.getBounds(" + graphObject + ")]" + string;
    }

    private final String _getSizeMethod(GraphObject graphObject, String string) {
        return "[DrawNetVisibleEdgesThenVisibleVertices.getSize(" + graphObject + ")]" + string;
    }

    private boolean _isVisible(GraphObject graphObject) throws IllegalArgumentException {
        boolean bl = true;
        try {
            bl = graphObject.systemdict.getBoolean(this._strKeyVisible);
        }
        catch (NullPointerException nullPointerException) {
            if (graphObject == null) {
                throw new IllegalArgumentException(String.valueOf(this._isVisibleMethod(graphObject)) + " Null " + (graphObject instanceof Vertex ? "vertex." : "edge."));
            }
            nullPointerException.printStackTrace();
            throw nullPointerException;
        }
        catch (KeyMissingException keyMissingException) {}
        return bl;
    }

    private boolean _isVisible(Net net, GraphObject graphObject) throws IllegalArgumentException {
        boolean bl;
        block11: {
            bl = true;
            if (net == null) {
                bl = this._isVisible(graphObject);
            } else {
                try {
                    Dict dict;
                    if (!graphObject.systemdict.containsKey(net)) {
                        bl = this._isVisible(graphObject);
                        break block11;
                    }
                    try {
                        dict = (Dict)graphObject.systemdict.get(net);
                    }
                    catch (ClassCastException classCastException) {
                        dict = null;
                    }
                    if (dict == null) {
                        bl = this._isVisible(graphObject);
                    }
                    try {
                        bl = dict.getBoolean(this._strKeyVisible);
                    }
                    catch (KeyMissingException keyMissingException) {
                        bl = this._isVisible(graphObject);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if (graphObject == null) {
                        throw new IllegalArgumentException(String.valueOf(this._isVisibleMethod(net, graphObject)) + " Null " + (graphObject instanceof Vertex ? "vertex." : "edge."));
                    }
                    nullPointerException.printStackTrace();
                    throw nullPointerException;
                }
            }
        }
        return bl;
    }

    private final String _isVisibleMethod(GraphObject graphObject) {
        return "[DrawNetVisibleEdgesThenVisibleVertices.isVisible(" + graphObject + ")]";
    }

    private final String _isVisibleMethod(Net net, GraphObject graphObject) {
        return "[DrawNetVisibleEdgesThenVisibleVertices.isVisible(Net," + graphObject + ")]";
    }

    private void _setVisible(GraphObject graphObject, boolean bl) {
        try {
            graphObject.systemdict.def((Object)this._strKeyVisible, bl);
        }
        catch (NullPointerException nullPointerException) {
            if (graphObject == null) {
                return;
            }
            if (graphObject.systemdict == null) {
                return;
            }
            nullPointerException.printStackTrace();
            throw nullPointerException;
        }
    }

    public void _setVisible(Net net, Edge edge, boolean bl) {
        block3: {
            try {
                Dict dict = edge.getNetDict(net, this._zForceNetDict);
                if (dict == null) {
                    dict = new Dict();
                    edge.systemdict.def((Object)net, dict);
                }
                this._setVisible(dict, bl);
            }
            catch (NullPointerException nullPointerException) {
                if (edge == null) break block3;
                nullPointerException.printStackTrace();
                throw nullPointerException;
            }
        }
    }

    private void _setVisible(Net net, Vertex vertex, boolean bl) {
        block3: {
            try {
                Dict dict = vertex.getNetDict(net, this._zForceNetDict);
                if (dict == null) {
                    dict = new Dict();
                    vertex.systemdict.def((Object)net, dict);
                }
                this._setVisible(dict, bl);
            }
            catch (NullPointerException nullPointerException) {
                if (vertex == null) break block3;
                nullPointerException.printStackTrace();
                throw nullPointerException;
            }
        }
    }

    private void _setVisible(Dict dict, boolean bl) {
        dict.def((Object)this._strKeyVisible, bl);
    }

    public boolean contains(GraphObject graphObject, int n, int n2) {
        Net net = (Net)graphObject;
        return this.getGraphObject(net, n, n2) != null;
    }

    public void draw(GraphObject graphObject, Graphics graphics) {
        if (this._iVerbose > 0) {
            System.out.println(this._drawMethod(graphObject, graphics, "{"));
        }
        if (graphObject != null) {
            Object object;
            Net net;
            try {
                net = (Net)graphObject;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(this._drawMethod(graphObject, graphics, " Graph-object not instanceof Net."));
            }
            Enumeration enumeration = net.enumerateEdges();
            while (enumeration.hasMoreElements()) {
                object = (Edge)enumeration.nextElement();
                if (!this._isVisible(net, (GraphObject)object)) continue;
                ((GraphDraw)object).draw(net, graphics);
            }
            object = net.enumerateVerticesReversed();
            while (object.hasMoreElements()) {
                Vertex vertex = (Vertex)object.nextElement();
                if (!this._isVisible(net, vertex)) continue;
                vertex.draw(net, graphics);
            }
        }
        if (this._iVerbose > 0) {
            System.out.println(this._drawMethod(graphObject, graphics, "}"));
        }
    }

    public Rectangle getBounds(GraphObject graphObject) throws NotDrawableException {
        Net net = null;
        if (graphObject != null) {
            try {
                net = (Net)graphObject;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(this._getBoundsMethod(graphObject, " Graph-object not instanceof Net."));
            }
        } else {
            throw new IllegalArgumentException(this._getBoundsMethod(graphObject, " Null graph-object."));
        }
        return this._getBounds(net);
    }

    public boolean getForceNetDict() {
        return this._zForceNetDict;
    }

    public static boolean getForceNetDictDefault() {
        return _$zForceNetDictDefault;
    }

    public GraphObject getGraphObject(Net net, int n, int n2) {
        block6: {
            try {
                Object object;
                Object object2;
                Enumeration enumeration = net.enumerateVertices();
                while (enumeration.hasMoreElements()) {
                    object2 = (Vertex)enumeration.nextElement();
                    object = ((GraphDraw)object2).getDrawable();
                    boolean bl = object instanceof Drawable ? ((GraphDraw)object2).contains(n, n2) : ((GraphDraw)object2).contains(net, n, n2);
                    if (!bl) continue;
                    return object2;
                }
                object2 = net.enumerateEdges();
                while (object2.hasMoreElements()) {
                    object = (Edge)object2.nextElement();
                    Drawable drawable = ((GraphDraw)object).getDrawable();
                    boolean bl = drawable instanceof Drawable ? ((GraphDraw)object).contains(n, n2) : ((GraphDraw)object).contains(net, n, n2);
                    if (!bl) continue;
                    return object;
                }
                if (net.getBounds(net).contains(n, n2)) {
                    return net;
                }
            }
            catch (NotDrawableException notDrawableException) {
            }
            catch (NullPointerException nullPointerException) {
                if (net == null) break block6;
                nullPointerException.printStackTrace();
                throw nullPointerException;
            }
        }
        return null;
    }

    public String getKeyVisible() {
        return this._strKeyVisible;
    }

    public static String getKeyVisibleDefault() {
        return _$strKeyVisibleDefault;
    }

    public Dimension getSize(GraphObject graphObject) throws NotDrawableException {
        Net net = null;
        if (graphObject != null) {
            try {
                net = (Net)graphObject;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(this._getSizeMethod(graphObject, " Graph-object not instanceof Net."));
            }
        } else {
            throw new IllegalArgumentException(this._getSizeMethod(graphObject, " Null graph object."));
        }
        return this._getBounds(net).getSize();
    }

    public boolean isVisible(Edge edge) throws IllegalArgumentException {
        return this._isVisible(edge);
    }

    public boolean isVisible(Net net, Edge edge) throws IllegalArgumentException {
        return this._isVisible(net, edge);
    }

    public boolean isVisible(Net net, Vertex vertex) throws IllegalArgumentException {
        return this._isVisible(net, vertex);
    }

    public boolean isVisible(Vertex vertex) throws IllegalArgumentException {
        return this._isVisible(vertex);
    }

    public void setForceNetDict(boolean bl) {
        this._zForceNetDict = bl;
    }

    public static void setForceNetDictDefault(boolean bl) {
        _$zForceNetDictDefault = bl;
    }

    public void setKeyVisible(String string) {
        if (string == null) {
            return;
        }
        this._strKeyVisible = string;
    }

    public static void setKeyVisibleDefault(String string) {
        if (string == null) {
            return;
        }
        _$strKeyVisibleDefault = string;
    }

    public void setVisible(Edge edge, boolean bl) {
        this._setVisible(edge, bl);
    }

    public void setVisible(Net net, Edge edge, boolean bl) {
        if (net == null) {
            this._setVisible(edge, bl);
        } else {
            this._setVisible(net, edge, bl);
        }
    }

    public void setVisible(Net net, Vertex vertex, boolean bl) {
        if (net == null) {
            this._setVisible(vertex, bl);
        } else {
            this._setVisible(net, vertex, bl);
        }
    }

    public void setVisible(Vertex vertex, boolean bl) {
        this._setVisible(vertex, bl);
    }
}

