/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Drawable;
import com.ibm.graph.DrawableNet;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;

public class DrawNetVertices
implements DrawableNet {
    private static final String strClassName = "DrawNetVertices";

    private Rectangle _getBounds(Net net) throws NotDrawableException {
        Rectangle rectangle = null;
        if (net == null) {
            return rectangle;
        }
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            try {
                if (vertex.getBounds((Net)net).x == 0 && vertex.getBounds((Net)net).y == 0) {
                    vertex.getLocation(net);
                }
                if (rectangle == null) {
                    rectangle = new Rectangle(vertex.getBounds(net));
                    continue;
                }
                rectangle.add(vertex.getBounds(net));
            }
            catch (NotDrawableException notDrawableException) {}
        }
        if (rectangle == null) {
            throw new NotDrawableException("[DrawNetVertices]");
        }
        return rectangle;
    }

    public boolean contains(GraphObject graphObject, int n, int n2) {
        Net net = (Net)graphObject;
        return DrawNetVertices.findGraphObject(net, n, n2) != null;
    }

    public void draw(GraphObject graphObject, Graphics graphics) {
        Net net = (Net)graphObject;
        if (net == null) {
            return;
        }
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.draw(net, graphics);
        }
    }

    public static GraphObject findGraphObject(Net net, int n, int n2) {
        try {
            Enumeration enumeration = net.enumerateVertices();
            while (enumeration.hasMoreElements()) {
                Vertex vertex = (Vertex)enumeration.nextElement();
                Drawable drawable = vertex.getDrawable();
                boolean bl = drawable instanceof Drawable ? vertex.contains(n, n2) : vertex.contains(net, n, n2);
                if (!bl) continue;
                return vertex;
            }
            if (net.getBounds(net).contains(n, n2)) {
                return net;
            }
        }
        catch (NotDrawableException notDrawableException) {}
        return null;
    }

    public Rectangle getBounds(GraphObject graphObject) throws NotDrawableException {
        Net net = (Net)graphObject;
        return this._getBounds(net);
    }

    public GraphObject getGraphObject(Net net, int n, int n2) {
        if (net == null) {
            return null;
        }
        return DrawNetVertices.findGraphObject(net, n, n2);
    }

    public Dimension getSize(GraphObject graphObject) throws NotDrawableException {
        Net net = (Net)graphObject;
        return this._getBounds(net).getSize();
    }
}

