/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Drawable;
import com.ibm.graph.Edge;
import com.ibm.graph.GraphDraw;
import com.ibm.graph.GraphLayoutManager;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.layout.LayoutGraphAsTree;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;

public class DrawNetForLayoutGraphAsTree
implements Drawable {
    private static String strClassName = "DrawNetForLayoutGraphAsTree";
    private int iVerbose = 0;
    private Drawable drawableVertex = null;
    private Drawable drawableEdge = null;

    private Rectangle _getBounds(Net net) throws NotDrawableException {
        GraphLayoutManager graphLayoutManager = net.getGraphLayoutManager();
        if (!(graphLayoutManager instanceof LayoutGraphAsTree)) {
            System.out.println("[" + strClassName + ".getBounds(Net)] Incompatible graph layout manager.");
            throw new NotDrawableException();
        }
        LayoutGraphAsTree layoutGraphAsTree = (LayoutGraphAsTree)graphLayoutManager;
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._getBounds(Net)]");
        }
        Rectangle rectangle = null;
        if (net == null) {
            return rectangle;
        }
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            try {
                if (vertex.getBounds((Net)net).x == 0 && vertex.getBounds((Net)net).y == 0) {
                    vertex.getLocation(net);
                }
                if (rectangle == null) {
                    rectangle = new Rectangle(vertex.getBounds(net));
                } else {
                    rectangle.add(vertex.getBounds(net));
                }
                if (this.iVerbose < 4) continue;
                System.out.println("\t" + vertex + "\t" + vertex.getBounds(net) + "\t" + rectangle);
            }
            catch (NotDrawableException notDrawableException) {}
        }
        Enumeration enumeration2 = net.enumerateEdges();
        while (enumeration2.hasMoreElements()) {
            Rectangle rectangle2;
            Edge edge;
            block23: {
                edge = (Edge)enumeration2.nextElement();
                try {
                    rectangle2 = edge.getBounds(net);
                    if (rectangle2.x == 0 && rectangle2.y == 0 && rectangle2.width == 0 && rectangle2.height == 0) continue;
                    rectangle.add(rectangle2);
                    if (this.iVerbose < 4) break block23;
                    System.out.println("\t" + edge + "\t" + rectangle2 + "\t" + rectangle);
                }
                catch (NotDrawableException notDrawableException) {
                    continue;
                }
            }
            try {
                if (!edge.systemdict.getBoolean(layoutGraphAsTree.getKeyNameCrossTree())) continue;
                Dict dict = (Dict)edge.systemdict.get(layoutGraphAsTree.getKeyNameDictCrossTree());
                Vertex vertex = edge.getFromVertex();
                Vertex vertex2 = edge.getToVertex();
                try {
                    Point point = vertex.getLocation();
                    vertex.setLocation(vertex.getLocation((Dict)dict.get(vertex)));
                    try {
                        rectangle2 = vertex.getBounds();
                        if (rectangle2.x != 0 || rectangle2.y != 0 || rectangle2.width != 0 || rectangle2.height != 0) {
                            rectangle.add(rectangle2);
                        }
                    }
                    catch (NotDrawableException notDrawableException) {}
                    vertex.setLocation(point);
                    point = vertex2.getLocation();
                    vertex2.setLocation(vertex2.getLocation((Dict)dict.get(vertex2)));
                    try {
                        rectangle2 = vertex2.getBounds();
                        if (rectangle2.x != 0 || rectangle2.y != 0 || rectangle2.width != 0 || rectangle2.height != 0) {
                            rectangle.add(rectangle2);
                        }
                    }
                    catch (NotDrawableException notDrawableException) {}
                    vertex2.setLocation(point);
                }
                catch (NotDrawableException notDrawableException) {
                    System.out.println("[" + strClassName + ".getBounds(GraphObject)] Cross-tree edge not drawable.");
                }
            }
            catch (KeyMissingException keyMissingException) {}
        }
        if (rectangle == null) {
            throw new NotDrawableException("[DrawNetForLayoutGraphAsTree]");
        }
        return rectangle;
    }

    public boolean contains(GraphObject graphObject, int n, int n2) {
        Net net = (Net)graphObject;
        boolean bl = false;
        if (net == null) {
            return bl;
        }
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            boolean bl2 = bl = bl || ((Vertex)enumeration.nextElement()).contains(net, n, n2);
            if (bl) break;
        }
        Enumeration enumeration2 = net.enumerateEdges();
        while (enumeration2.hasMoreElements()) {
            boolean bl3 = bl = bl || ((Edge)enumeration2.nextElement()).contains(net, n, n2);
            if (bl) break;
        }
        try {
            if (this._getBounds(net).contains(n, n2)) {
                bl = true;
            }
        }
        catch (NotDrawableException notDrawableException) {}
        return bl;
    }

    public void draw(GraphObject graphObject, Graphics graphics) {
        Cloneable cloneable;
        Vertex vertex;
        Cloneable cloneable2;
        Object object;
        Object object2;
        if (graphObject == null) {
            if (this.iVerbose > 0) {
                System.out.println("[" + strClassName + ".draw(" + graphObject + "," + graphics + ")] Null net.");
            }
            return;
        }
        if (graphics == null) {
            if (this.iVerbose > 0) {
                System.out.println("[" + strClassName + ".draw(" + graphObject + "," + graphics + ")] Null graphics.");
            }
            return;
        }
        if (!(graphObject instanceof Net)) {
            System.out.println("[" + strClassName + ".draw(" + graphObject + "," + graphics + ")] Graph object is not a net.");
            return;
        }
        Net net = (Net)graphObject;
        GraphLayoutManager graphLayoutManager = net.getGraphLayoutManager();
        if (!(graphLayoutManager instanceof LayoutGraphAsTree)) {
            System.out.println("[" + strClassName + ".draw(" + graphObject + "," + graphics + ")] Incompatible graph layout manager.");
            return;
        }
        LayoutGraphAsTree layoutGraphAsTree = (LayoutGraphAsTree)graphLayoutManager;
        Enumeration enumeration = net.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            object2 = (Edge)enumeration.nextElement();
            try {
                if (((GraphObject)object2).systemdict.getBoolean(layoutGraphAsTree.getKeyNameCrossTree())) {
                    object = (Dict)((GraphObject)object2).systemdict.get(layoutGraphAsTree.getKeyNameDictCrossTree());
                    cloneable2 = ((Edge)object2).getFromVertex();
                    vertex = ((Edge)object2).getToVertex();
                    try {
                        cloneable = ((GraphDraw)cloneable2).getLocation();
                        ((GraphDraw)cloneable2).setLocation(((GraphDraw)cloneable2).getLocation((Dict)((Hashtable)object).get(cloneable2)));
                        ((GraphDraw)object2).draw(graphics);
                        ((GraphDraw)cloneable2).setLocation((Point)cloneable);
                        cloneable = vertex.getLocation();
                        vertex.setLocation(vertex.getLocation((Dict)((Hashtable)object).get(vertex)));
                        ((GraphDraw)object2).draw(graphics);
                        vertex.setLocation((Point)cloneable);
                    }
                    catch (NotDrawableException notDrawableException) {
                        System.out.println("[" + strClassName + ".draw(GraphObject,Graphics)] Cross-tree edge not drawable.");
                    }
                    continue;
                }
                ((GraphDraw)object2).draw(net, graphics);
            }
            catch (KeyMissingException keyMissingException) {
                System.out.println("??[" + strClassName + ".draw(GraphObject,Graphics)]?? Key (" + layoutGraphAsTree.getKeyNameCrossTree() + ") missing exception for " + object2 + ".");
            }
        }
        object2 = net.enumerateEdges();
        while (object2.hasMoreElements()) {
            object = (Edge)object2.nextElement();
            try {
                if (!((GraphObject)object).systemdict.getBoolean(layoutGraphAsTree.getKeyNameCrossTree())) continue;
                cloneable2 = (Dict)((GraphObject)object).systemdict.get(layoutGraphAsTree.getKeyNameDictCrossTree());
                vertex = ((Edge)object).getFromVertex();
                cloneable = ((Edge)object).getToVertex();
                Dict dict = (Dict)((Hashtable)cloneable2).get(vertex);
                Dict dict2 = (Dict)((Hashtable)cloneable2).get(cloneable);
                GraphDraw.setDrawable(dict, this.drawableVertex);
                GraphDraw.setDrawable(dict2, this.drawableVertex);
                vertex.draw(dict, graphics);
                ((GraphDraw)cloneable).draw(dict2, graphics);
            }
            catch (KeyMissingException keyMissingException) {
                System.out.println("??[" + strClassName + ".draw(GraphObject,Graphics)]?? Key (" + layoutGraphAsTree.getKeyNameCrossTree() + ") missing exception for " + object + ".");
            }
        }
        object = net.enumerateVertices();
        while (object.hasMoreElements()) {
            cloneable2 = (Vertex)object.nextElement();
            ((GraphDraw)cloneable2).draw(net, graphics);
        }
    }

    public Rectangle getBounds(GraphObject graphObject) throws NotDrawableException {
        Net net = (Net)graphObject;
        return this._getBounds(net);
    }

    public Drawable getCrossTreeVertexDrawable() {
        return this.drawableVertex;
    }

    public Dimension getSize(GraphObject graphObject) throws NotDrawableException {
        Net net = (Net)graphObject;
        return this._getBounds(net).getSize();
    }

    public int getVerbose() {
        return this.iVerbose;
    }

    public void setCrossTreeVertexDrawable(Drawable drawable) {
        this.drawableVertex = drawable;
    }

    public void setVerbose(int n) {
        this.iVerbose = n;
    }
}

