/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Drawable;
import com.ibm.graph.DrawableNet;
import com.ibm.graph.Edge;
import com.ibm.graph.GraphDraw;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;

public class DrawNetEdgesThenVertices
implements DrawableNet {
    private static final String _$strClassName = "DrawNetEdgesThenVertices";
    private int _iVerbose = 0;
    private static final String strClassName = "DrawNetEdgesThenVertices";

    private String _drawMethod(GraphObject graphObject, Graphics graphics, String string) {
        return "[DrawNetEdgesThenVertices.draw(" + graphObject + ",Graphics)]" + string;
    }

    private Rectangle _getBounds(Net net) throws NotDrawableException {
        Rectangle rectangle = null;
        if (net == null) {
            return rectangle;
        }
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            try {
                if (vertex.getBounds((Net)net).x == 0 && vertex.getBounds((Net)net).y == 0) {
                    vertex.getLocation(net);
                }
                if (rectangle == null) {
                    rectangle = new Rectangle(vertex.getBounds(net));
                    continue;
                }
                rectangle.add(vertex.getBounds(net));
            }
            catch (NotDrawableException notDrawableException) {}
        }
        Enumeration enumeration2 = net.enumerateEdges();
        while (enumeration2.hasMoreElements()) {
            Edge edge = (Edge)enumeration2.nextElement();
            try {
                Rectangle rectangle2 = edge.getBounds(net);
                if (rectangle2 == null || rectangle2.x == 0 && rectangle2.y == 0 && rectangle2.width == 0 && rectangle2.height == 0) continue;
                if (rectangle == null) {
                    rectangle = new Rectangle(rectangle2);
                    continue;
                }
                rectangle.add(rectangle2);
            }
            catch (NotDrawableException notDrawableException) {}
        }
        if (rectangle == null) {
            throw new NotDrawableException("[DrawNetEdgesThenVertices]");
        }
        return rectangle;
    }

    public boolean contains(GraphObject graphObject, int n, int n2) {
        Net net = (Net)graphObject;
        return DrawNetEdgesThenVertices.findGraphObject(net, n, n2) != null;
    }

    public void draw(GraphObject graphObject, Graphics graphics) {
        Object object;
        Net net;
        if (this._iVerbose > 0) {
            System.out.println(this._drawMethod(graphObject, graphics, "{"));
        }
        if ((net = (Net)graphObject) == null) {
            return;
        }
        Enumeration enumeration = net.enumerateEdges();
        while (enumeration.hasMoreElements()) {
            object = (Edge)enumeration.nextElement();
            ((GraphDraw)object).draw(net, graphics);
        }
        object = net.enumerateVerticesReversed();
        while (object.hasMoreElements()) {
            Vertex vertex = (Vertex)object.nextElement();
            vertex.draw(net, graphics);
        }
        if (this._iVerbose > 0) {
            System.out.println(this._drawMethod(graphObject, graphics, "}"));
        }
    }

    public static GraphObject findGraphObject(Net net, int n, int n2) {
        try {
            Object object;
            Object object2;
            Enumeration enumeration = net.enumerateVertices();
            while (enumeration.hasMoreElements()) {
                object2 = (Vertex)enumeration.nextElement();
                object = ((GraphDraw)object2).getDrawable();
                boolean bl = object instanceof Drawable ? ((GraphDraw)object2).contains(n, n2) : ((GraphDraw)object2).contains(net, n, n2);
                if (!bl) continue;
                return object2;
            }
            object2 = net.enumerateEdges();
            while (object2.hasMoreElements()) {
                object = (Edge)object2.nextElement();
                Drawable drawable = ((GraphDraw)object).getDrawable();
                boolean bl = drawable instanceof Drawable ? ((GraphDraw)object).contains(n, n2) : ((GraphDraw)object).contains(net, n, n2);
                if (!bl) continue;
                return object;
            }
            if (net.getBounds(net).contains(n, n2)) {
                return net;
            }
        }
        catch (NotDrawableException notDrawableException) {}
        return null;
    }

    public Rectangle getBounds(GraphObject graphObject) throws NotDrawableException {
        Net net = (Net)graphObject;
        return this._getBounds(net);
    }

    public GraphObject getGraphObject(Net net, int n, int n2) {
        if (net == null) {
            return null;
        }
        return DrawNetEdgesThenVertices.findGraphObject(net, n, n2);
    }

    public Dimension getSize(GraphObject graphObject) throws NotDrawableException {
        Net net = (Net)graphObject;
        return this._getBounds(net).getSize();
    }
}

