/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Edge;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.DrawEdgePath;
import com.ibm.research.geometry.Line;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class DrawEdgeOrthogonalLine
extends DrawEdgePath {
    public static final int HORIZONTAL_VERTICAL_LEFT_RIGHT = 0;
    public static final int HORIZONTAL_VERTICAL_TOP_BOTTOM = 1;
    public static final int VERTICAL_HORIZONTAL_LEFT_RIGHT = 2;
    public static final int VERTICAL_HORIZONTAL_TOP_BOTTOM = 3;
    protected int iTurnDirection = 2;
    protected boolean zFromToSensitive = false;
    private static String strClassName = "DrawEdgeOrthogonalLine";
    private double dContainment;
    Vertex vertexFrom;
    Vertex vertexTo;
    Point pointFrom;
    Point pointTo;
    Point point1;
    Point point2 = new Point();
    Point point3;
    Point pointTemp = new Point();

    private boolean _contains(Edge edge, int n, int n2) throws NullPointerException {
        try {
            this._getEndPoints(edge);
            if (!this.getBounds(edge).contains(n, n2)) {
                return false;
            }
        }
        catch (NotDrawableException notDrawableException) {
            System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
            return false;
        }
        this.pointTemp.x = n;
        this.pointTemp.y = n2;
        if (Line.getDistance(this.point1, this.point2, this.pointTemp) < this.dContainment) {
            return true;
        }
        return Line.getDistance(this.point2, this.point3, this.pointTemp) < this.dContainment;
    }

    private void _draw(Edge edge, Graphics graphics) {
        try {
            this._getEndPoints(edge);
        }
        catch (NotDrawableException notDrawableException) {
            System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
            return;
        }
        graphics.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
        graphics.drawLine(this.point2.x, this.point2.y, this.point3.x, this.point3.y);
    }

    private Rectangle _getBounds(Edge edge) throws NullPointerException {
        try {
            this._getEndPoints(edge);
        }
        catch (NotDrawableException notDrawableException) {
            System.out.println("[" + strClassName + "._getBounds(" + edge + ")] Edge has either or both end vertices without a location.  Edge not drawn.");
            return null;
        }
        Rectangle rectangle = new Rectangle(this.pointFrom.x, this.pointFrom.y, 0, 0);
        rectangle.add(this.pointTo.x, this.pointTo.y);
        return rectangle;
    }

    private void _getEndPoints(Edge edge) throws NotDrawableException, NullPointerException {
        this.vertexFrom = edge.getFromVertex();
        this.vertexTo = edge.getToVertex();
        this.pointFrom = this.vertexFrom.getLocation();
        this.pointTo = this.vertexTo.getLocation();
        if (this.zFromToSensitive) {
            this.point1 = this.pointFrom;
            this.point3 = this.pointTo;
        } else {
            switch (this.iTurnDirection) {
                case 0: 
                case 2: {
                    if (this.pointFrom.x <= this.pointTo.x) {
                        this.point1 = this.pointFrom;
                        this.point3 = this.pointTo;
                        break;
                    }
                    this.point1 = this.pointTo;
                    this.point3 = this.pointFrom;
                    break;
                }
                case 1: 
                case 3: {
                    if (this.pointFrom.y <= this.pointTo.y) {
                        this.point1 = this.pointFrom;
                        this.point3 = this.pointTo;
                        break;
                    }
                    this.point1 = this.pointTo;
                    this.point3 = this.pointFrom;
                    break;
                }
                default: {
                    System.out.println("??[" + strClassName + "] Invalid turn direction (" + this.iTurnDirection + "). BUG!");
                    throw new NotDrawableException();
                }
            }
        }
        switch (this.iTurnDirection) {
            case 0: 
            case 1: {
                this.point2.x = this.point3.x;
                this.point2.y = this.point1.y;
                break;
            }
            case 2: 
            case 3: {
                this.point2.x = this.point1.x;
                this.point2.y = this.point3.y;
                break;
            }
            default: {
                System.out.println("??[" + strClassName + "] Invalid turn direction (" + this.iTurnDirection + "). BUG!");
                throw new NotDrawableException();
            }
        }
    }

    private Dimension _getSize(Edge edge) throws NullPointerException {
        Rectangle rectangle = this._getBounds(edge);
        try {
            return new Dimension(rectangle.width, rectangle.height);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("[" + strClassName + ".getSize(" + edge + ") ] Edge has either or both end vertices without a location.  Size can not be determined.");
            return null;
        }
    }

    protected boolean containsEdge(Edge edge, int n, int n2) {
        return this._contains(edge, n, n2);
    }

    public void drawEdge(Edge edge, Graphics graphics) {
        this._draw(edge, graphics);
    }

    protected Rectangle getBoundsEdge(Edge edge) throws NotDrawableException {
        return this._getBounds(edge);
    }

    public double getContainment() {
        return this.dContainment;
    }

    public boolean getFromToSensitivity() {
        return this.zFromToSensitive;
    }

    protected Dimension getSizeEdge(Edge edge) throws NotDrawableException {
        return this._getSize(edge);
    }

    public int getTurnDirection() {
        return this.iTurnDirection;
    }

    public boolean isFromToSensitive() {
        return this.zFromToSensitive;
    }

    public void setContainment(double d) {
        this.dContainment = d;
    }

    public void setFromToSensitivity(boolean bl) {
        this.zFromToSensitive = bl;
    }

    public void setTurnDirection(int n) {
        this.iTurnDirection = n;
    }
}

