/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Edge;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.DrawEdgeLineText;
import com.ibm.research.awt.FontMetricized;
import com.ibm.research.geometry.Line;
import com.ibm.research.util.KeyMissingException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class DrawEdgeLineThenText
extends DrawEdgeLineText {
    private static final String strClassName = "DrawEdgeLineThenText";
    private static String strKeyPass = "pass";
    private Font fontText = null;
    private FontMetricized fontmText = new FontMetricized("Helvetica", 0, 12);

    private boolean _contains(Edge edge, int n, int n2) {
        if (this.zVisible) {
            EdgeEnds edgeEnds;
            try {
                edgeEnds = this._getEdgeEnds(edge);
                if (!this.getBounds(edge).contains(n, n2)) {
                    return false;
                }
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println("[DrawEdgeLineThenText] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
                return false;
            }
            Point point = new Point(n, n2);
            if (Math.abs(Line.getDistance(edgeEnds.pointFrom, edgeEnds.pointTo, point)) < this.dContainment) {
                return true;
            }
        }
        return false;
    }

    private void _drawEdge(Edge edge, Graphics graphics) {
        if (this.zVisible) {
            EdgeEnds edgeEnds;
            try {
                edgeEnds = this._getEdgeEnds(edge);
            }
            catch (NotDrawableException notDrawableException) {
                return;
            }
            Color color = graphics.getColor();
            int n = this._getPass(edge);
            switch (n) {
                default: {
                    graphics.setColor(this.getColorPath());
                    graphics.drawLine(edgeEnds.pointFrom.x, edgeEnds.pointFrom.y, edgeEnds.pointTo.x, edgeEnds.pointTo.y);
                }
                case 2: 
            }
            switch (n) {
                default: {
                    Font font = graphics.getFont();
                    graphics.setColor(this.getColorText());
                    graphics.setFont(this.fontmText);
                    graphics.drawString(this.getText(), (edgeEnds.pointTo.x - edgeEnds.pointFrom.x >> 1) + edgeEnds.pointFrom.x - (this.fontmText.metrics.stringWidth(this.getText()) >> 1), (edgeEnds.pointTo.y - edgeEnds.pointFrom.y >> 1) + edgeEnds.pointFrom.y);
                    graphics.setFont(font);
                }
                case 1: 
            }
            graphics.setColor(color);
        }
    }

    private Rectangle _getBounds(Edge edge) throws NotDrawableException {
        EdgeEnds edgeEnds = this._getEdgeEnds(edge);
        Rectangle rectangle = new Rectangle(edgeEnds.pointFrom.x - 1, edgeEnds.pointFrom.y - 1, 2, 2);
        rectangle.add(edgeEnds.pointTo.x, edgeEnds.pointTo.y);
        return rectangle;
    }

    private EdgeEnds _getEdgeEnds(Edge edge) throws NotDrawableException {
        EdgeEnds edgeEnds = new EdgeEnds();
        edgeEnds.vertexFrom = edge.getFromVertex();
        edgeEnds.vertexTo = edge.getToVertex();
        edgeEnds.pointFrom = edgeEnds.vertexFrom.getLocation();
        edgeEnds.pointTo = edgeEnds.vertexTo.getLocation();
        return edgeEnds;
    }

    private int _getPass(Edge edge) {
        try {
            return edge.systemdict.getInteger(strKeyPass);
        }
        catch (KeyMissingException keyMissingException) {
            return 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    private Dimension _getSize(Edge edge) throws NotDrawableException {
        Rectangle rectangle = this._getBounds(edge);
        try {
            return new Dimension(rectangle.width, rectangle.height);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("[DrawEdgeLineThenText] Edge (" + edge + ") has either or both end vertices without a location.  Size can not be determined.");
            return null;
        }
    }

    protected boolean containsEdge(Edge edge, int n, int n2) {
        return this._contains(edge, n, n2);
    }

    protected void drawEdge(Edge edge, Graphics graphics) {
        this._drawEdge(edge, graphics);
    }

    protected Rectangle getBoundsEdge(Edge edge) throws NotDrawableException {
        return this._getBounds(edge);
    }

    public Font getFontText() {
        if (this.fontText == null) {
            return this.fontmText;
        }
        return this.fontText;
    }

    public static String getKeyPass() {
        return strKeyPass;
    }

    protected Dimension getSizeEdge(Edge edge) throws NotDrawableException {
        return this._getSize(edge);
    }

    public void setFontText(Font font) {
        this.fontText = font;
        this.fontmText = new FontMetricized(font.getName(), font.getStyle(), font.getSize());
    }

    public static void setKeyPass(String string) {
        strKeyPass = string;
    }

    private class EdgeEnds {
        public Vertex vertexFrom;
        public Vertex vertexTo;
        public Point pointFrom;
        public Point pointTo;

        EdgeEnds() {
        }
    }
}

