/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Edge;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.DrawEdgePathKeyVisible;
import com.ibm.research.geometry.Line;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class DrawEdgeLineKeyVisible
extends DrawEdgePathKeyVisible {
    private static String strClassName = "DrawEdgeLineKeyVisible";
    private double dContainment = 3.0;
    Vertex vertexFrom;
    Vertex vertexTo;
    Point pointFrom;
    Point pointTo;

    private boolean _contains(Edge edge, int n, int n2) {
        if (DrawEdgePathKeyVisible.isVisible(edge)) {
            try {
                this._getEndPoints(edge);
                if (!this.getBounds(edge).contains(n, n2)) {
                    return false;
                }
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
                return false;
            }
            Point point = new Point(n, n2);
            if (Math.abs(Line.getDistance(this.pointFrom, this.pointTo, point)) < this.dContainment) {
                return true;
            }
        }
        return false;
    }

    private void _draw(Edge edge, Graphics graphics) throws NotDrawableException {
        if (DrawEdgePathKeyVisible.isVisible(edge)) {
            this._getEndPoints(edge);
            graphics.setColor(this.colorPath);
            graphics.drawLine(this.pointFrom.x, this.pointFrom.y, this.pointTo.x, this.pointTo.y);
        }
    }

    private Rectangle _getBounds(Edge edge) {
        try {
            this._getEndPoints(edge);
        }
        catch (NotDrawableException notDrawableException) {
            if (this.iVerbose >= 1) {
                System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
            }
            return null;
        }
        Rectangle rectangle = new Rectangle(this.pointFrom.x - 1, this.pointFrom.y - 1, 2, 2);
        rectangle.add(this.pointTo.x, this.pointTo.y);
        return rectangle;
    }

    private void _getEndPoints(Edge edge) throws NotDrawableException, NullPointerException {
        this.vertexFrom = edge.getFromVertex();
        this.vertexTo = edge.getToVertex();
        this.pointFrom = this.vertexFrom.getLocation();
        this.pointTo = this.vertexTo.getLocation();
    }

    private Dimension _getSize(Edge edge) throws NullPointerException {
        Rectangle rectangle = this._getBounds(edge);
        try {
            return new Dimension(rectangle.width, rectangle.height);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Size can not be determined.");
            return null;
        }
    }

    protected boolean containsEdge(Edge edge, int n, int n2) {
        return this._contains(edge, n, n2);
    }

    public void drawEdge(Edge edge, Graphics graphics) throws NotDrawableException {
        this._draw(edge, graphics);
    }

    protected Rectangle getBoundsEdge(Edge edge) throws NotDrawableException {
        return this._getBounds(edge);
    }

    public double getContainment() {
        return this.dContainment;
    }

    protected Dimension getSizeEdge(Edge edge) throws NotDrawableException {
        return this._getSize(edge);
    }

    public void setContainment(double d) {
        this.dContainment = d;
    }
}

