/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Edge;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.draw.DrawEdgeLine;
import com.ibm.research.geometry.Line;
import com.ibm.research.util.KeyMissingException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class DrawEdgeLineKeyText
extends DrawEdgeLine {
    private static final String strClassName = "DrawEdgeLineKeyText";
    private String strKeyText = null;
    private String strText = null;
    private Color colorText = Color.black;

    private boolean _contains(Edge edge, int n, int n2) {
        if (this.zVisible) {
            try {
                this._getEndPoints(edge);
                if (!this.getBounds(edge).contains(n, n2)) {
                    return false;
                }
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println("[DrawEdgeLineKeyText] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
                return false;
            }
            Point point = new Point(n, n2);
            if (Math.abs(Line.getDistance(this.pointFrom, this.pointTo, point)) < this.dContainment) {
                return true;
            }
        }
        return false;
    }

    private void _draw(Edge edge, Graphics graphics) {
        if (this.zVisible) {
            try {
                this._getEndPoints(edge);
            }
            catch (NotDrawableException notDrawableException) {
                return;
            }
            Color color = graphics.getColor();
            graphics.setColor(this.colorPath);
            graphics.drawLine(this.pointFrom.x, this.pointFrom.y, this.pointTo.x, this.pointTo.y);
            graphics.setColor(this.colorText);
            String string = this._getTextLabel(edge);
            graphics.drawString(string, (this.pointTo.x - this.pointFrom.x >> 1) + this.pointFrom.x, (this.pointTo.y - this.pointFrom.y >> 1) + this.pointFrom.y);
            graphics.setColor(color);
        }
    }

    private Rectangle _getBounds(Edge edge) {
        try {
            this._getEndPoints(edge);
        }
        catch (NotDrawableException notDrawableException) {
            if (this.iVerbose >= 1) {
                System.out.println("[DrawEdgeLineKeyText] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
            }
            return null;
        }
        Rectangle rectangle = new Rectangle(this.pointFrom.x - 1, this.pointFrom.y - 1, 2, 2);
        rectangle.add(this.pointTo.x, this.pointTo.y);
        return rectangle;
    }

    private void _getEndPoints(Edge edge) throws NotDrawableException, NullPointerException {
        this.vertexFrom = edge.getFromVertex();
        this.vertexTo = edge.getToVertex();
        this.pointFrom = this.vertexFrom.getLocation();
        this.pointTo = this.vertexTo.getLocation();
    }

    private Dimension _getSize(Edge edge) throws NullPointerException {
        Rectangle rectangle = this._getBounds(edge);
        try {
            return new Dimension(rectangle.width, rectangle.height);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("[DrawEdgeLineKeyText] Edge (" + edge + ") has either or both end vertices without a location.  Size can not be determined.");
            return null;
        }
    }

    private String _getTextLabel(Edge edge) {
        if (this.strKeyText != null) {
            try {
                return edge.userdict.getString(this.strKeyText);
            }
            catch (KeyMissingException keyMissingException) {}
        }
        if (this.strText != null) {
            return this.strText;
        }
        return edge.getName();
    }

    protected boolean containsEdge(Edge edge, int n, int n2) {
        return this._contains(edge, n, n2);
    }

    public void drawEdge(Edge edge, Graphics graphics) {
        this._draw(edge, graphics);
    }

    protected Rectangle getBoundsEdge(Edge edge) throws NotDrawableException {
        return this._getBounds(edge);
    }

    public Color getColorText() {
        return this.colorText;
    }

    public String getKeyText() {
        return this.strKeyText;
    }

    protected Dimension getSizeEdge(Edge edge) throws NotDrawableException {
        return this._getSize(edge);
    }

    public String getTextDefault() {
        return this.strText;
    }

    public void setColorText(Color color) {
        this.colorText = color;
    }

    public void setKeyText(String string) {
        this.strKeyText = string;
    }

    public void setTextDefault(String string) {
        this.strText = this.strText;
    }
}

