/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Edge;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.draw.DrawEdgeLine;
import com.ibm.research.awt.PolygonUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class DrawEdgeDirectedArrow
extends DrawEdgeLine {
    private static final String _strClassName = "DrawEdgeDirectedArrow";
    private static int _iDefaultArrowHeadLength = 20;
    private static int _iDefaultArrowHeadWidth = 12;
    private float _fArrowHeadTipPositionAlongEdge = 0.7f;
    private Polygon _polygonPath;
    private boolean _zArrowHeadStroke = true;
    private boolean _zArrowHeadFill = false;
    private Color _colorArrowHeadStroke = Color.black;
    private Color _colorArrowHeadFill = Color.black;
    private Polygon _polygonPathTransformed;

    public DrawEdgeDirectedArrow() {
        this._polygonPath = new Polygon();
        this._polygonPath.addPoint(0, 0);
        this._polygonPath.addPoint(-_iDefaultArrowHeadLength, _iDefaultArrowHeadWidth >> 1);
        this._polygonPath.addPoint(-_iDefaultArrowHeadLength, -_iDefaultArrowHeadWidth >> 1);
        this._polygonPath.addPoint(0, 0);
        this._polygonPathTransformed = new Polygon((int[])this._polygonPath.xpoints.clone(), (int[])this._polygonPath.ypoints.clone(), this._polygonPath.npoints);
    }

    private void _draw(Edge edge, Graphics graphics) throws NotDrawableException {
        if (this.zVisible) {
            Color color = graphics.getColor();
            Point point = edge.getFromVertex().getLocation();
            Point point2 = edge.getToVertex().getLocation();
            graphics.setColor(this.colorPath);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            float f = point2.x - point.x;
            float f2 = point2.y - point.y;
            Point point3 = new Point(point);
            point3.translate((int)(f * this._fArrowHeadTipPositionAlongEdge), (int)(f2 * this._fArrowHeadTipPositionAlongEdge));
            double d = Math.atan2(f2, f);
            PolygonUtil.rotate_translate(this._polygonPath, d, point3.x, point3.y, this._polygonPathTransformed);
            if (this._zArrowHeadFill && this._colorArrowHeadFill != null) {
                graphics.setColor(this._colorArrowHeadFill);
                graphics.fillPolygon(this._polygonPathTransformed);
            }
            if (this._zArrowHeadStroke && this._colorArrowHeadStroke != null) {
                graphics.setColor(this._colorArrowHeadStroke);
                graphics.drawPolygon(this._polygonPathTransformed);
            }
            graphics.setColor(color);
        }
    }

    public void drawEdge(Edge edge, Graphics graphics) throws NotDrawableException {
        this._draw(edge, graphics);
    }

    public boolean getArrowHeadFill() {
        return this._zArrowHeadFill;
    }

    public boolean getArrowHeadStroke() {
        return this._zArrowHeadStroke;
    }

    public float getArrowHeadTipPositionAlongEdge() {
        return this._fArrowHeadTipPositionAlongEdge;
    }

    public Color getColorArrowHeadFill() {
        return this._colorArrowHeadFill;
    }

    public Color getColorArrowHeadStroke() {
        return this._colorArrowHeadStroke;
    }

    public static int getDefaultArrowHeadLength() {
        return _iDefaultArrowHeadLength;
    }

    public static int getDefaultArrowHeadWidth() {
        return _iDefaultArrowHeadWidth;
    }

    public void setArrowHeadFill(boolean bl) {
        this._zArrowHeadFill = bl;
    }

    public void setArrowHeadPath(Polygon polygon) {
        this._polygonPath = polygon;
    }

    public void setArrowHeadStroke(boolean bl) {
        this._zArrowHeadStroke = bl;
    }

    public void setArrowHeadTipPositionAlongEdge(float f) {
        this._fArrowHeadTipPositionAlongEdge = f;
    }

    public void setColorArrowHeadFill(Color color) {
        this._colorArrowHeadFill = color;
    }

    public void setColorArrowHeadStroke(Color color) {
        this._colorArrowHeadStroke = color;
    }

    public static void setDefaultArrowHeadLength(int n) {
        _iDefaultArrowHeadLength = n;
    }

    public static void setDefaultArrowHeadWidth(int n) {
        _iDefaultArrowHeadWidth = n;
    }
}

