/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Edge;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.DrawEdgePath;
import com.ibm.research.geometry.Line;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class DrawEdgeCircularArc
extends DrawEdgePath {
    private static String strClassName = "DrawEdgeCircularArc";
    private double _dAngle = -1.0471975511965976;
    private int iRadiusSelfLoop = 18;
    private double dContainment = 3.0;
    Vertex vertexFrom;
    Vertex vertexTo;
    Point pointFrom;
    Point pointTo;

    private boolean _contains(Edge edge, int n, int n2) {
        if (this.zVisible) {
            try {
                this._getEndPoints(edge);
                if (!this.getBounds(edge).contains(n, n2)) {
                    return false;
                }
            }
            catch (NotDrawableException notDrawableException) {
                System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
                return false;
            }
            Point point = new Point(n, n2);
            if (Math.abs(Line.getDistance(this.pointFrom, this.pointTo, point)) < this.dContainment) {
                return true;
            }
        }
        return false;
    }

    private void _draw(Edge edge, Graphics graphics) throws NotDrawableException {
        if (this.zVisible) {
            double d;
            double d2;
            int n;
            Point point;
            this._getEndPoints(edge);
            if (this.pointFrom.equals(this.pointTo)) {
                point = new Point(this.pointFrom.x + this.iRadiusSelfLoop, this.pointFrom.y);
                n = this.iRadiusSelfLoop;
                if (this._dAngle < 0.0) {
                    d2 = Math.PI;
                    d = -Math.PI;
                } else {
                    d2 = -Math.PI;
                    d = Math.PI;
                }
            } else {
                point = this._getCircularArcCenter(this.pointFrom.x, this.pointFrom.y, this.pointTo.x, this.pointTo.y, this._dAngle);
                n = (int)this._getRadius(point.x, point.y, this.pointFrom.x, this.pointFrom.y);
                d2 = -Math.atan2(this.pointFrom.y - point.y, this.pointFrom.x - point.x);
                d = -Math.atan2(this.pointTo.y - point.y, this.pointTo.x - point.x);
            }
            Color color = graphics.getColor();
            graphics.setColor(this.colorPath);
            int n2 = this._toDegree(d2);
            int n3 = this._toDegree(d) - this._toDegree(d2);
            if (this._dAngle < 0.0) {
                if (n3 > 0) {
                    n3 -= 360;
                }
            } else if (n3 < 0) {
                n3 += 360;
            }
            graphics.drawArc(point.x - n, point.y - n, n * 2, n * 2, n2, n3);
            graphics.setColor(color);
        }
    }

    private Rectangle _getBounds(Edge edge) {
        try {
            this._getEndPoints(edge);
        }
        catch (NotDrawableException notDrawableException) {
            if (this.iVerbose >= 1) {
                System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Edge not drawn.");
            }
            return null;
        }
        Rectangle rectangle = new Rectangle(this.pointFrom.x - 1, this.pointFrom.y - 1, 2, 2);
        rectangle.add(this.pointTo.x, this.pointTo.y);
        return rectangle;
    }

    private Point _getCircularArcCenter(int n, int n2, int n3, int n4, double d) {
        double d2 = (double)(n3 - n) / 2.0;
        double d3 = (double)(n4 - n2) / 2.0;
        double d4 = Math.tan(d);
        return new Point(n + (int)(d2 + d3 * d4), n2 - (int)(d2 * d4 - d3));
    }

    private void _getEndPoints(Edge edge) throws NotDrawableException, NullPointerException {
        this.vertexFrom = edge.getFromVertex();
        this.vertexTo = edge.getToVertex();
        this.pointFrom = this.vertexFrom.getLocation();
        this.pointTo = this.vertexTo.getLocation();
    }

    private double _getRadius(int n, int n2, int n3, int n4) {
        return Math.sqrt(Math.pow(n3 - n, 2.0) + Math.pow(n4 - n2, 2.0));
    }

    private Dimension _getSize(Edge edge) throws NullPointerException {
        Rectangle rectangle = this._getBounds(edge);
        try {
            return new Dimension(rectangle.width, rectangle.height);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("[" + strClassName + "] Edge (" + edge + ") has either or both end vertices without a location.  Size can not be determined.");
            return null;
        }
    }

    private int _toDegree(double d) {
        int n = (int)(d * 180.0 / Math.PI);
        return n;
    }

    protected boolean containsEdge(Edge edge, int n, int n2) {
        return this._contains(edge, n, n2);
    }

    public void drawEdge(Edge edge, Graphics graphics) throws NotDrawableException {
        this._draw(edge, graphics);
    }

    public double getAngle() {
        return this._dAngle;
    }

    protected Rectangle getBoundsEdge(Edge edge) throws NotDrawableException {
        return this._getBounds(edge);
    }

    public double getContainment() {
        return this.dContainment;
    }

    public int getRadiusSelfLoop() {
        return this.iRadiusSelfLoop;
    }

    protected Dimension getSizeEdge(Edge edge) throws NotDrawableException {
        return this._getSize(edge);
    }

    public void setAngle(double d) {
        this._dAngle = d;
    }

    public void setContainment(double d) {
        this.dContainment = d;
    }

    public void setRadiusSelfLoop(int n) {
        this.iRadiusSelfLoop = n;
    }
}

