/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Drawable;
import com.ibm.graph.Edge;
import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.research.io.ConditionalPrintStream;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class DrawEdge
implements Drawable {
    static ConditionalPrintStream stdout = new ConditionalPrintStream(System.out);
    static ConditionalPrintStream stderr = new ConditionalPrintStream(System.err);
    protected int iVerbose = 0;
    private static final String _$strClassName = "DrawEdge";
    private static final String _$$drawMethod = "[DrawEdge.draw(";
    private static final String _$$drawMethodGraphicsParm = ",Graphics)]";

    private final StringBuffer _drawEdgeMethod(GraphObject graphObject) {
        StringBuffer stringBuffer = new StringBuffer(_$$drawMethod);
        stringBuffer.append(graphObject);
        stringBuffer.append(_$$drawMethodGraphicsParm);
        return stringBuffer;
    }

    public boolean contains(GraphObject graphObject, int n, int n2) {
        Edge edge;
        try {
            edge = (Edge)graphObject;
        }
        catch (ClassCastException classCastException) {
            stdout.println("[DrawEdge.contains(" + graphObject + "," + n + "," + n2 + ")] Graph object is not an instance of Edge.");
            return false;
        }
        try {
            return this.containsEdge(edge, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            if (edge == null) {
                stdout.println("[DrawEdge.contains(" + edge + "," + n + "," + n2 + ")] Null edge.");
            }
            return false;
        }
    }

    protected abstract boolean containsEdge(Edge var1, int var2, int var3);

    public void draw(GraphObject graphObject, Graphics graphics) {
        Edge edge;
        try {
            edge = (Edge)graphObject;
        }
        catch (ClassCastException classCastException) {
            stderr.println(this._drawEdgeMethod(graphObject).append("Graph object is not an instance of class Edge."));
            return;
        }
        try {
            this.drawEdge(edge, graphics);
        }
        catch (NotDrawableException notDrawableException) {
            stderr.println(this._drawEdgeMethod(graphObject).append("Undefined edge's end-vertex location."));
            return;
        }
        catch (NullPointerException nullPointerException) {
            if (edge == null) {
                stderr.println(this._drawEdgeMethod(graphObject).append("Null edge."));
            }
            if (graphics == null) {
                stderr.println(this._drawEdgeMethod(graphObject).append("Null graphics."));
            }
            stderr.println(this._drawEdgeMethod(graphObject).append("Null pointer exception. [BUG?]"));
            nullPointerException.printStackTrace(stderr);
            return;
        }
    }

    protected abstract void drawEdge(Edge var1, Graphics var2) throws NotDrawableException;

    public Rectangle getBounds(GraphObject graphObject) throws NotDrawableException {
        Edge edge;
        try {
            edge = (Edge)graphObject;
        }
        catch (ClassCastException classCastException) {
            stdout.println("[DrawEdge.getBounds(" + graphObject + ")] Graph object is not an instance of class Edge.");
            return null;
        }
        try {
            return this.getBoundsEdge(edge);
        }
        catch (NullPointerException nullPointerException) {
            if (edge == null) {
                stdout.println("[DrawEdge.getBounds(" + edge + ")] Null edge.");
            }
            return null;
        }
    }

    protected abstract Rectangle getBoundsEdge(Edge var1) throws NotDrawableException;

    public Dimension getSize(GraphObject graphObject) throws NotDrawableException {
        Edge edge;
        try {
            edge = (Edge)graphObject;
        }
        catch (ClassCastException classCastException) {
            stdout.println("[DrawEdge.getSize(Net," + graphObject + ")] Graph object is not an instance of Edge.");
            throw new NotDrawableException();
        }
        try {
            return this.getSizeEdge(edge);
        }
        catch (NullPointerException nullPointerException) {
            if (edge == null) {
                stdout.println("[DrawEdge.getSize(" + edge + ")] Null edge.");
            }
            return null;
        }
    }

    protected abstract Dimension getSizeEdge(Edge var1) throws NotDrawableException;

    public int getVerbose() {
        return this.iVerbose;
    }

    public void setVerbose(int n) {
        this.iVerbose = n;
    }
}

