/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexBaseText;
import com.ibm.research.awt.FontMetricized;
import com.ibm.research.util.Dict;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Draw3VertexTextArray
extends Draw3VertexBaseText {
    private static String strClassName = "Draw3VertexTextArray";
    private static String _strDefaultFontName = "Helvetica";
    private static int _iDefaultFontStyle = 0;
    private static int _iDefaultFontSize = 12;
    private String[] _straTextArray;

    public Draw3VertexTextArray() {
        this(null, _strDefaultFontName, _iDefaultFontStyle, _iDefaultFontSize);
    }

    public Draw3VertexTextArray(FontMetricized fontMetricized) {
        this(null, fontMetricized);
    }

    public Draw3VertexTextArray(String string, int n, int n2) {
        this(null, string, n, n2);
    }

    public Draw3VertexTextArray(String[] stringArray) {
        this(stringArray, _strDefaultFontName, _iDefaultFontStyle, _iDefaultFontSize);
    }

    public Draw3VertexTextArray(String[] stringArray, FontMetricized fontMetricized) {
        this.setTextArray(stringArray);
        this.setFont(fontMetricized);
    }

    public Draw3VertexTextArray(String[] stringArray, String string, int n, int n2) {
        this.setTextArray(stringArray);
        this.setFont(string, n, n2);
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        Point point = this.getLocation(dict, vertex);
        Dimension dimension = this._getSize(dict, vertex);
        if (this._straTextArray == null) {
            return;
        }
        int n = 0;
        while (n < this._straTextArray.length) {
            this._drawText(this._straTextArray[n], this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height) + dimension.height - this._fontText.descent - this._fontText.height * (this._straTextArray.length - 1 - n), graphics);
            ++n;
        }
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._getBounds(Dict,Vertex)]");
        }
        Point point = this.getLocation(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex location: " + point);
        }
        Dimension dimension = this._getSize(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex size: " + dimension);
        }
        Rectangle rectangle = new Rectangle(this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height), dimension.width, dimension.height);
        if (this.iVerbose >= 3) {
            System.out.println("\tvertex bounds: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getMinimumSize(Dict dict, Vertex vertex) {
        int n = 0;
        int n2 = 0;
        while (n2 < this._straTextArray.length) {
            n = Math.max(n, this._fontText.metrics.stringWidth(this._straTextArray[n2]));
            ++n2;
        }
        int n3 = this._fontText.height * this._straTextArray.length;
        return new Dimension(n, n3);
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getMinimumSize(dict, vertex);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public String[] getTextArray() {
        return this._straTextArray;
    }

    public void setTextArray(String[] stringArray) {
        if (this.iVerbose >= 1 && stringArray == null) {
            System.out.println("[" + strClassName + ".setTextArray(\"" + stringArray + "\")] Warning: Null text.");
        }
        this._straTextArray = stringArray;
    }
}

