/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexBaseText;
import com.ibm.research.awt.FontMetricized;
import com.ibm.research.util.Dict;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Draw3VertexText
extends Draw3VertexBaseText {
    private static String strClassName = "Draw3VertexText";
    private static String _strDefaultFontName = "Helvetica";
    private static int _iDefaultFontStyle = 0;
    private static int _iDefaultFontSize = 12;
    private String _strText;

    public Draw3VertexText() {
        this(null, _strDefaultFontName, _iDefaultFontStyle, _iDefaultFontSize);
    }

    public Draw3VertexText(FontMetricized fontMetricized) {
        this(null, fontMetricized);
    }

    public Draw3VertexText(String string) {
        this(string, _strDefaultFontName, _iDefaultFontStyle, _iDefaultFontSize);
    }

    public Draw3VertexText(String string, int n, int n2) {
        this(null, string, n, n2);
    }

    public Draw3VertexText(String string, FontMetricized fontMetricized) {
        this.setText(string);
        this.setFont(fontMetricized);
    }

    public Draw3VertexText(String string, String string2, int n, int n2) {
        this.setText(string);
        this.setFont(string2, n, n2);
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        Point point = this.getLocation(dict, vertex);
        Dimension dimension = this._getSize(dict, vertex);
        this._drawText(this._strText, this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height) + dimension.height - this._fontText.descent, graphics);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._getBounds(Dict,Vertex)]");
        }
        Point point = this.getLocation(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex location: " + point);
        }
        Dimension dimension = this._getSize(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex size: " + dimension);
        }
        Rectangle rectangle = new Rectangle(this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height), dimension.width, dimension.height);
        if (this.iVerbose >= 3) {
            System.out.println("\tvertex bounds: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getMinimumSize(Dict dict, Vertex vertex) {
        int n = this._fontText.metrics.stringWidth(this._strText);
        int n2 = this._fontText.height;
        return new Dimension(n, n2);
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getMinimumSize(dict, vertex);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException, NullPointerException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public String getText() {
        return this._strText;
    }

    public void setText(String string) {
        if (this.iVerbose >= 1 && string == null) {
            System.out.println("[" + strClassName + ".setText(\"" + string + "\")] Warning: Null text.");
        }
        this._strText = string;
    }
}

