/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexFillAreaText;
import com.ibm.graph.draw.Draw3VertexRectangle;
import com.ibm.graph.draw.Draw3VertexTextArray;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Draw3VertexRectangleTextArray
extends Draw3VertexFillAreaText {
    private static String strClassName = "Draw3VertexRectangleTextArray";
    private Draw3VertexRectangle d3vRectangle;
    private Draw3VertexTextArray d3vTextArray;
    private int iMarginLeft = 0;
    private int iMarginRight = 0;
    private int iMarginTop = 0;
    private int iMarginBottom = 0;
    private boolean _zValidAlignments = false;

    public Draw3VertexRectangleTextArray() {
        this.d3vTextArray = new Draw3VertexTextArray();
        this.d3vRectangle = new Draw3VertexRectangle();
        this._init();
    }

    public Draw3VertexRectangleTextArray(String string, int n, int n2) {
        this.d3vTextArray = new Draw3VertexTextArray(string, n, n2);
        this.d3vRectangle = new Draw3VertexRectangle();
        this._init();
    }

    public Draw3VertexRectangleTextArray(String[] stringArray) {
        this.d3vTextArray = new Draw3VertexTextArray(stringArray);
        this.d3vRectangle = new Draw3VertexRectangle();
        this._init();
    }

    public Draw3VertexRectangleTextArray(String[] stringArray, String string, int n, int n2) {
        this.d3vTextArray = new Draw3VertexTextArray(stringArray, string, n, n2);
        this.d3vRectangle = new Draw3VertexRectangle();
        this._init();
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        Color color = graphics.getColor();
        this.d3vRectangle.setDimension(this._getSize(dict, vertex));
        this.d3vRectangle.draw(dict, (GraphObject)vertex, graphics);
        if (!this._zValidAlignments) {
            this._validateAlignments();
        }
        this.d3vTextArray.draw(dict, (GraphObject)vertex, graphics);
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._getBounds(Dict," + vertex + ")]");
        }
        if (!this._zValidAlignments) {
            this._validateAlignments();
        }
        Rectangle rectangle = this.d3vTextArray.getBounds(dict, (GraphObject)vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\ttext bounds: " + rectangle);
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle.add(n + rectangle.width + this.iMarginRight, n2 + rectangle.height + this.iMarginBottom);
        rectangle.add(n - this.iMarginLeft, n2 - this.iMarginTop);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex bounds: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        Dimension dimension = this.d3vTextArray.getSize(dict, (GraphObject)vertex);
        dimension.setSize(dimension.width + this.iMarginLeft + this.iMarginRight, dimension.height + this.iMarginTop + this.iMarginBottom);
        return dimension;
    }

    private void _init() {
        this.d3vRectangle.setAlignments(0, 0);
    }

    private void _setMarginBottom(int n) {
        if (this.iMarginBottom != n) {
            this.iMarginBottom = n;
            this._zValidAlignments = false;
        }
    }

    private void _setMarginLeft(int n) {
        if (this.iMarginLeft != n) {
            this.iMarginLeft = n;
            this._zValidAlignments = false;
        }
    }

    private void _setMarginRight(int n) {
        if (this.iMarginRight != n) {
            this.iMarginRight = n;
            this._zValidAlignments = false;
        }
    }

    private void _setMarginTop(int n) {
        if (this.iMarginTop != n) {
            this.iMarginTop = n;
            this._zValidAlignments = false;
        }
    }

    private void _validateAlignments() {
        int n = this.d3vRectangle.getTranslationX();
        switch (this.d3vRectangle.getAlignmentX()) {
            case 1: {
                n += this.iMarginLeft;
                break;
            }
            case -1: {
                n -= this.iMarginRight;
                break;
            }
        }
        this.d3vTextArray.setTranslationX(n);
        int n2 = this.d3vRectangle.getTranslationY();
        switch (this.d3vRectangle.getAlignmentY()) {
            case 1: {
                n2 += this.iMarginTop;
                break;
            }
            case -1: {
                n2 -= this.iMarginBottom;
                break;
            }
        }
        this.d3vTextArray.setTranslationY(n2);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Color getColorFill() {
        return this.d3vRectangle.getColorFill();
    }

    public Color getColorOutline() {
        return this.d3vRectangle.getColorOutline();
    }

    public Draw3VertexRectangle getDraw3VertexRectangle() {
        return this.d3vRectangle;
    }

    public Draw3VertexTextArray getDraw3VertexTextArray() {
        return this.d3vTextArray;
    }

    public int getMarginBottom() {
        return this.iMarginBottom;
    }

    public int getMarginLeft() {
        return this.iMarginLeft;
    }

    public int getMarginRight() {
        return this.iMarginRight;
    }

    public int getMarginTop() {
        return this.iMarginTop;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public int getTranslationX() {
        return this.d3vRectangle.getTranslationX();
    }

    public int getTranslationY() {
        return this.d3vRectangle.getTranslationY();
    }

    public void setAlignmentX(int n) {
        this.d3vRectangle.setAlignmentX(n);
        this.d3vTextArray.setAlignmentX(n);
        this._zValidAlignments = false;
    }

    public void setAlignmentY(int n) {
        this.d3vRectangle.setAlignmentY(n);
        this.d3vTextArray.setAlignmentY(n);
        this._zValidAlignments = false;
    }

    public void setAlignments(int n, int n2) {
        this.d3vRectangle.setAlignments(n, n2);
        this.d3vTextArray.setAlignments(n, n2);
        this._zValidAlignments = false;
    }

    public void setColorFill(Color color) {
        this.d3vRectangle.setColorFill(color);
    }

    public void setColorOutline(Color color) {
        this.d3vRectangle.setColorOutline(color);
    }

    public void setDraw3VertexRectangle(Draw3VertexRectangle draw3VertexRectangle) {
        this.d3vRectangle = draw3VertexRectangle;
    }

    public void setDraw3VertexTextArray(Draw3VertexTextArray draw3VertexTextArray) {
        this.d3vTextArray = draw3VertexTextArray;
    }

    public void setMarginBottom(int n) {
        this._setMarginBottom(n);
    }

    public void setMarginLeft(int n) {
        this._setMarginLeft(n);
    }

    public void setMarginRight(int n) {
        this._setMarginRight(n);
    }

    public void setMarginTop(int n) {
        this._setMarginTop(n);
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this._setMarginLeft(n);
        this._setMarginRight(n2);
        this._setMarginBottom(n3);
        this._setMarginTop(n4);
    }

    public void setTranslationX(int n) {
        this.d3vRectangle.setTranslationX(n);
        this._zValidAlignments = false;
    }

    public void setTranslationY(int n) {
        this.d3vRectangle.setTranslationY(n);
        this._zValidAlignments = false;
    }

    public void setVerbose(int n) {
        super.setVerbose(n);
        this.d3vRectangle.setVerbose(n);
        this.d3vTextArray.setVerbose(n);
    }

    public void validateAlignments() {
        this._validateAlignments();
        this._zValidAlignments = true;
    }
}

