/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexCheckbox;
import com.ibm.graph.draw.Draw3VertexFillAreaText;
import com.ibm.graph.draw.Draw3VertexKeyText;
import com.ibm.graph.draw.Draw3VertexRectangle;
import com.ibm.research.awt.FontMetricized;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Draw3VertexRectangleCheckboxKeyText
extends Draw3VertexFillAreaText {
    private static final String strClassName = "Draw3VertexRectangleCheckboxKeyText";
    private Draw3VertexRectangle d3vRect;
    private Draw3VertexKeyText d3vKeyText;
    private Draw3VertexCheckbox d3vCheckbox;
    private int iMarginLeft = 0;
    private int iMarginRight = 0;
    private int iMarginTop = 0;
    private int iMarginBottom = 0;
    private int _iGutter = 0;
    private Dimension _dimCheckboxDefault = new Dimension(20, 20);
    private boolean _zValidAlignments = false;

    public Draw3VertexRectangleCheckboxKeyText() {
        this.d3vCheckbox = new Draw3VertexCheckbox(this._dimCheckboxDefault);
        this.d3vKeyText = new Draw3VertexKeyText();
        this.d3vRect = new Draw3VertexRectangle();
        this._init();
    }

    public Draw3VertexRectangleCheckboxKeyText(FontMetricized fontMetricized) {
        this.d3vCheckbox = new Draw3VertexCheckbox(this._dimCheckboxDefault);
        this.d3vKeyText = new Draw3VertexKeyText(fontMetricized);
        this.d3vRect = new Draw3VertexRectangle();
        this._init();
    }

    public Draw3VertexRectangleCheckboxKeyText(String string) {
        this.d3vCheckbox = new Draw3VertexCheckbox(this._dimCheckboxDefault);
        this.d3vKeyText = new Draw3VertexKeyText(string);
        this.d3vRect = new Draw3VertexRectangle();
        this._init();
    }

    public Draw3VertexRectangleCheckboxKeyText(String string, int n, int n2) {
        this.d3vCheckbox = new Draw3VertexCheckbox(this._dimCheckboxDefault);
        this.d3vKeyText = new Draw3VertexKeyText(string, n, n2);
        this.d3vRect = new Draw3VertexRectangle();
        this._init();
    }

    public Draw3VertexRectangleCheckboxKeyText(String string, FontMetricized fontMetricized) {
        this.d3vCheckbox = new Draw3VertexCheckbox(this._dimCheckboxDefault);
        this.d3vKeyText = new Draw3VertexKeyText(string, fontMetricized);
        this.d3vRect = new Draw3VertexRectangle();
        this._init();
    }

    public Draw3VertexRectangleCheckboxKeyText(String string, String string2, int n, int n2) {
        this.d3vCheckbox = new Draw3VertexCheckbox(this._dimCheckboxDefault);
        this.d3vKeyText = new Draw3VertexKeyText(string, string2, n, n2);
        this.d3vRect = new Draw3VertexRectangle();
        this._init();
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexRectangleCheckboxKeyText._draw(Dict," + vertex + ",Graphics)]");
        }
        Color color = graphics.getColor();
        this.d3vRect.setDimension(this._getSize(dict, vertex));
        this.d3vRect.draw(dict, (GraphObject)vertex, graphics);
        if (!this._zValidAlignments) {
            this._validateAlignments(dict, vertex);
        }
        this.d3vCheckbox.draw(dict, (GraphObject)vertex, graphics);
        this.d3vKeyText.draw(dict, (GraphObject)vertex, graphics);
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexRectangleCheckboxKeyText._getBounds(Dict," + vertex + ")]");
        }
        if (!this._zValidAlignments) {
            this._validateAlignments(dict, vertex);
        }
        Rectangle rectangle = this.d3vKeyText.getBounds(dict, (GraphObject)vertex);
        rectangle.add(this.d3vCheckbox.getBounds(dict, (GraphObject)vertex));
        if (this.iVerbose >= 4) {
            System.out.println("\ttext bounds: " + rectangle);
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle.add(n + rectangle.width + this.iMarginRight, n2 + rectangle.height + this.iMarginBottom);
        rectangle.add(n - this.iMarginLeft, n2 - this.iMarginTop);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex bounds: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        Dimension dimension = this.d3vKeyText.getSize(dict, (GraphObject)vertex);
        Dimension dimension2 = this.d3vCheckbox.getSize(dict, (GraphObject)vertex);
        try {
            dimension.setSize(dimension2.width + this._iGutter + dimension.width + this.iMarginLeft + this.iMarginRight, Math.max(dimension2.height, dimension.height) + this.iMarginTop + this.iMarginBottom);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            dimension.width = dimension2.width + this._iGutter + dimension.width + this.iMarginLeft + this.iMarginRight;
            dimension.height = Math.max(dimension2.height, dimension.height) + this.iMarginTop + this.iMarginBottom;
        }
        return dimension;
    }

    private void _init() {
        this.d3vRect.setAlignments(0, 0);
        this.d3vKeyText.setAlignments(0, 0);
        this.d3vCheckbox.setAlignments(0, 0);
    }

    private void _setMarginBottom(int n) {
        if (this.iMarginBottom != n) {
            this.iMarginBottom = n;
            this._zValidAlignments = false;
        }
    }

    private void _setMarginLeft(int n) {
        if (this.iMarginLeft != n) {
            this.iMarginLeft = n;
            this._zValidAlignments = false;
        }
    }

    private void _setMarginRight(int n) {
        if (this.iMarginRight != n) {
            this.iMarginRight = n;
            this._zValidAlignments = false;
        }
    }

    private void _setMarginTop(int n) {
        if (this.iMarginTop != n) {
            this.iMarginTop = n;
            this._zValidAlignments = false;
        }
    }

    private void _validateAlignments(Dict dict, Vertex vertex) {
        Dimension dimension;
        Dimension dimension2;
        int n = this.d3vRect.getTranslationX();
        try {
            dimension2 = this.d3vCheckbox.getSize(dict, (GraphObject)vertex);
        }
        catch (NotDrawableException notDrawableException) {
            dimension2 = new Dimension(0, 0);
        }
        try {
            dimension = this.d3vKeyText.getSize(dict, (GraphObject)vertex);
        }
        catch (NotDrawableException notDrawableException) {
            dimension = new Dimension(0, 0);
        }
        int n2 = dimension2.width + this._iGutter + dimension.width;
        switch (this.d3vRect.getAlignmentX()) {
            case 1: {
                this.d3vCheckbox.setTranslationX(n += this.iMarginLeft);
                this.d3vKeyText.setTranslationX(n + dimension2.width + this._iGutter);
                break;
            }
            case 0: {
                this.d3vCheckbox.setTranslationX(n - (n2 - dimension2.width >> 1));
                this.d3vKeyText.setTranslationX(n + (n2 - dimension.width >> 1));
                break;
            }
            case -1: {
                this.d3vCheckbox.setTranslationX((n -= this.iMarginRight) - dimension.width - this._iGutter);
                this.d3vKeyText.setTranslationX(n);
                break;
            }
        }
        int n3 = this.d3vRect.getTranslationY();
        switch (this.d3vRect.getAlignmentY()) {
            case 1: {
                n3 += this.iMarginTop;
                break;
            }
            case -1: {
                n3 -= this.iMarginBottom;
                break;
            }
        }
        this.d3vCheckbox.setTranslationY(n3);
        this.d3vKeyText.setTranslationY(n3);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Color getColorFill() {
        return this.d3vRect.getColorFill();
    }

    public Color getColorNotRaised() {
        return this.d3vCheckbox.getColorNotRaised();
    }

    public Color getColorOutline() {
        return this.d3vRect.getColorOutline();
    }

    public Color getColorRaised() {
        return this.d3vCheckbox.getColorRaised();
    }

    public Dimension getDimensionCheckbox() {
        return this.d3vCheckbox.getDimension();
    }

    public Draw3VertexCheckbox getDraw3VertexCheckbox() {
        return this.d3vCheckbox;
    }

    public Draw3VertexKeyText getDraw3VertexKeyText() {
        return this.d3vKeyText;
    }

    public Draw3VertexRectangle getDraw3VertexRectangle() {
        return this.d3vRect;
    }

    public int getGutter() {
        return this._iGutter;
    }

    public int getMarginBottom() {
        return this.iMarginBottom;
    }

    public int getMarginLeft() {
        return this.iMarginLeft;
    }

    public int getMarginRight() {
        return this.iMarginRight;
    }

    public int getMarginTop() {
        return this.iMarginTop;
    }

    public boolean getRaised() {
        return this.d3vCheckbox.getRaised();
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public int getTranslationX() {
        return this.d3vRect.getTranslationX();
    }

    public int getTranslationY() {
        return this.d3vRect.getTranslationY();
    }

    public void setAlignmentX(int n) {
        this.d3vRect.setAlignmentX(n);
        this.d3vKeyText.setAlignmentX(n);
        this.d3vCheckbox.setAlignmentX(n);
        this._zValidAlignments = false;
    }

    public void setAlignmentY(int n) {
        this.d3vRect.setAlignmentY(n);
        this.d3vKeyText.setAlignmentY(n);
        this.d3vCheckbox.setAlignmentY(n);
        this._zValidAlignments = false;
    }

    public void setAlignments(int n, int n2) {
        this.d3vRect.setAlignments(n, n2);
        this.d3vKeyText.setAlignments(n, n2);
        this.d3vCheckbox.setAlignments(n, n2);
        this._zValidAlignments = false;
    }

    public void setColorFill(Color color) {
        this.d3vRect.setColorFill(color);
    }

    public void setColorNotRaised(Color color) {
        this.d3vCheckbox.setColorNotRaised(color);
    }

    public void setColorOutline(Color color) {
        this.d3vRect.setColorOutline(color);
    }

    public void setColorRaised(Color color) {
        this.d3vCheckbox.setColorRaised(color);
    }

    public void setDimensionCheckbox(Dimension dimension) {
        this.d3vCheckbox.setDimension(dimension);
    }

    public void setDraw3VertexCheckbox(Draw3VertexCheckbox draw3VertexCheckbox) {
        this.d3vCheckbox = draw3VertexCheckbox;
    }

    public void setDraw3VertexKeyText(Draw3VertexKeyText draw3VertexKeyText) {
        this.d3vKeyText = draw3VertexKeyText;
    }

    public void setDraw3VertexRectangle(Draw3VertexRectangle draw3VertexRectangle) {
        this.d3vRect = draw3VertexRectangle;
    }

    public void setGutter(int n) {
        this._iGutter = n;
    }

    public void setMarginBottom(int n) {
        this._setMarginBottom(n);
    }

    public void setMarginLeft(int n) {
        this._setMarginLeft(n);
    }

    public void setMarginRight(int n) {
        this._setMarginRight(n);
    }

    public void setMarginTop(int n) {
        this._setMarginTop(n);
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this._setMarginLeft(n);
        this._setMarginRight(n2);
        this._setMarginBottom(n3);
        this._setMarginTop(n4);
    }

    public void setRaised(boolean bl) {
        this.d3vCheckbox.setRaised(bl);
    }

    public void setTranslationX(int n) {
        this.d3vRect.setTranslationX(n);
        this._zValidAlignments = false;
    }

    public void setTranslationY(int n) {
        this.d3vRect.setTranslationY(n);
        this._zValidAlignments = false;
    }

    public void setVerbose(int n) {
        super.setVerbose(n);
        this.d3vRect.setVerbose(n);
        this.d3vKeyText.setVerbose(n);
        this.d3vCheckbox.setVerbose(n);
    }

    public void toggleRaised() {
        this.d3vCheckbox.toggleRaised();
    }

    public void validateAlignments(Dict dict, Vertex vertex) {
        this._validateAlignments(dict, vertex);
        this._zValidAlignments = true;
    }
}

