/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.GraphDraw;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexFillArea;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Draw3VertexRectangle
extends Draw3VertexFillArea {
    Dimension dimRectangle = null;
    private static final String strClassName = "Draw3VertexRectangle";

    public Draw3VertexRectangle() {
    }

    public Draw3VertexRectangle(Dimension dimension) {
        this.dimRectangle = dimension;
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexRectangle._draw(" + dict + "," + vertex + ",Graphics)] ...");
        }
        Color color = graphics.getColor();
        this.drawRectangle(dict, vertex, graphics);
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexRectangle._getBounds(Dict,Vertex)]");
        }
        Point point = this.getLocation(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tlocation of vertex: " + point);
        }
        Dimension dimension = this._getSize(dict, vertex);
        Rectangle rectangle = new Rectangle(this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height), dimension.width, dimension.height);
        if (this.iVerbose >= 3) {
            System.out.println("\treturns: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        try {
            return new Dimension(dict.getInteger(GraphDraw.strKeyWidth), dict.getInteger(GraphDraw.strKeyHeight));
        }
        catch (KeyMissingException keyMissingException) {
            try {
                return new Dimension(vertex.systemdict.getInteger(GraphDraw.strKeyWidth), vertex.systemdict.getInteger(GraphDraw.strKeyHeight));
            }
            catch (KeyMissingException keyMissingException2) {
                if (this.dimRectangle != null) {
                    return this.dimRectangle;
                }
                if (this.iVerbose >= 1) {
                    System.out.println("[Draw3VertexRectangle._getSize(Dict," + vertex + ")] Could not determine dimension of rectangle.");
                }
                throw new NotDrawableException();
            }
        }
    }

    void drawRectangle(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexRectangle.drawRectangle(" + dict + "," + vertex + ",Graphics)] ...");
        }
        Rectangle rectangle = this._getBounds(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\trectangle bounds: " + rectangle);
        }
        if (this.zFill) {
            if (this.colorFill == null) {
                graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.setColor(this.colorFill);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (this.zOutline && this.colorOutline != null) {
            graphics.setColor(this.colorOutline);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException, NullPointerException {
        this._draw(dict, vertex, graphics);
    }

    protected void finalize() {
        this.dimRectangle = null;
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Dimension getDimension() {
        return this.dimRectangle;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setDimension(Dimension dimension) {
        this.dimRectangle = dimension;
    }
}

