/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexBaseText;
import com.ibm.research.awt.FontMetricized;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Draw3VertexKeyText
extends Draw3VertexBaseText {
    private static String strClassName = "Draw3VertexKeyText";
    private static String _strDefaultFontName = "Helvetica";
    private static int _iDefaultFontStyle = 0;
    private static int _iDefaultFontSize = 12;
    private String _strKeyText = GraphObject.strKeyName;

    public Draw3VertexKeyText() {
        this(null, _strDefaultFontName, _iDefaultFontStyle, _iDefaultFontSize);
    }

    public Draw3VertexKeyText(FontMetricized fontMetricized) {
        this(null, fontMetricized);
    }

    public Draw3VertexKeyText(String string) {
        this(string, _strDefaultFontName, _iDefaultFontStyle, _iDefaultFontSize);
    }

    public Draw3VertexKeyText(String string, int n, int n2) {
        this(null, string, n, n2);
    }

    public Draw3VertexKeyText(String string, FontMetricized fontMetricized) {
        if (string != null) {
            this.setKeyText(string);
        }
        this.setFont(fontMetricized);
    }

    public Draw3VertexKeyText(String string, String string2, int n, int n2) {
        if (string != null) {
            this.setKeyText(string);
        }
        this.setFont(string2, n, n2);
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException, NullPointerException {
        Point point = this.getLocation(dict, vertex);
        Dimension dimension = this._getSize(dict, vertex);
        this._drawText(this._getText(dict, vertex), this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height) + dimension.height - this._fontText.descent, graphics);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._getBounds(Dict,Vertex)]");
        }
        Point point = this.getLocation(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex location: " + point);
        }
        Dimension dimension = this._getSize(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex size: " + dimension);
        }
        Rectangle rectangle = new Rectangle(this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height), dimension.width, dimension.height);
        if (this.iVerbose >= 3) {
            System.out.println("\tvertex bounds: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getMinimumSize(Dict dict, Vertex vertex) {
        String string = this._getText(dict, vertex);
        int n = string != null ? this._fontText.metrics.stringWidth(string) : 0;
        int n2 = string != null ? this._fontText.height : 0;
        return new Dimension(n, n2);
    }

    private Dimension _getSize(Dict dict, Vertex vertex) {
        return this._getMinimumSize(dict, vertex);
    }

    private final String _getText(Vertex vertex) {
        try {
            return vertex.systemdict.getString(this._strKeyText);
        }
        catch (KeyMissingException keyMissingException) {
            return vertex.getName();
        }
    }

    private String _getText(Dict dict, Vertex vertex) {
        if (dict != null) {
            try {
                return dict.getString(this._strKeyText);
            }
            catch (KeyMissingException keyMissingException) {
                return this._getText(vertex);
            }
        }
        return this._getText(vertex);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException, NullPointerException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public String getKeyText() {
        return this._strKeyText;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setKeyText(String string) {
        this._strKeyText = string;
    }
}

