/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexFillAreaText;
import com.ibm.graph.draw.Draw3VertexKeyColorRectangle;
import com.ibm.graph.draw.Draw3VertexText;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Draw3VertexKeyColorRectangleText
extends Draw3VertexFillAreaText {
    private static String strClassName = "Draw3VertexKeyColorRectangleText";
    private Draw3VertexKeyColorRectangle d3vRect;
    private Draw3VertexText d3vText;
    private int iMarginLeft = 0;
    private int iMarginRight = 0;
    private int iMarginTop = 0;
    private int iMarginBottom = 0;

    public Draw3VertexKeyColorRectangleText() {
        this.d3vText = new Draw3VertexText();
        this.d3vRect = new Draw3VertexKeyColorRectangle();
        this._init();
    }

    public Draw3VertexKeyColorRectangleText(String string, int n, int n2) {
        this.d3vText = new Draw3VertexText(string, n, n2);
        this.d3vRect = new Draw3VertexKeyColorRectangle();
        this._init();
    }

    public Draw3VertexKeyColorRectangleText(String string, int n, int n2, String string2) {
        this.d3vText = new Draw3VertexText(string2, string, n, n2);
        this.d3vRect = new Draw3VertexKeyColorRectangle();
        this._init();
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        Color color = graphics.getColor();
        Dimension dimension = this.d3vText.getSize(dict, (GraphObject)vertex);
        this.d3vRect.setTranslationX(-((dimension.width >> 1) + this.iMarginLeft));
        this.d3vRect.setTranslationY(-((dimension.height >> 1) + this.iMarginTop));
        this.d3vRect.setDimension(this._getSize(dict, vertex));
        this.d3vRect.draw(dict, (GraphObject)vertex, graphics);
        this.d3vText.draw(dict, (GraphObject)vertex, graphics);
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._getBounds(Dict," + vertex + ")]");
        }
        Rectangle rectangle = this.d3vText.getBounds(dict, (GraphObject)vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\ttext bounds: " + rectangle);
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle.add(n + rectangle.width + this.iMarginRight, n2 + rectangle.height + this.iMarginBottom);
        rectangle.add(n - this.iMarginLeft, n2 - this.iMarginTop);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex bounds: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        Dimension dimension = this.d3vText.getSize(dict, (GraphObject)vertex);
        dimension.setSize(dimension.width + this.iMarginLeft + this.iMarginRight, dimension.height + this.iMarginTop + this.iMarginBottom);
        return dimension;
    }

    private void _init() {
        this.d3vRect.setAlignments(1, 1);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Draw3VertexKeyColorRectangle getDraw3VertexKeyColorRectangle() {
        return this.d3vRect;
    }

    public Draw3VertexText getDraw3VertexText() {
        return this.d3vText;
    }

    public int getMarginBottom() {
        return this.iMarginBottom;
    }

    public int getMarginLeft() {
        return this.iMarginLeft;
    }

    public int getMarginRight() {
        return this.iMarginRight;
    }

    public int getMarginTop() {
        return this.iMarginTop;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setDraw3VertexKeyColorRectangle(Draw3VertexKeyColorRectangle draw3VertexKeyColorRectangle) {
        this.d3vRect = draw3VertexKeyColorRectangle;
    }

    public void setDraw3VertexText(Draw3VertexText draw3VertexText) {
        this.d3vText = draw3VertexText;
    }

    public void setMarginBottom(int n) {
        this.iMarginBottom = n;
    }

    public void setMarginLeft(int n) {
        this.iMarginLeft = n;
    }

    public void setMarginRight(int n) {
        this.iMarginRight = n;
    }

    public void setMarginTop(int n) {
        this.iMarginTop = n;
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.iMarginLeft = n;
        this.iMarginRight = n2;
        this.iMarginBottom = n3;
        this.iMarginTop = n4;
    }
}

