/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexFillAreaText;
import com.ibm.graph.draw.Draw3VertexKeyColorRectangle;
import com.ibm.graph.draw.Draw3VertexKeyText;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Draw3VertexKeyColorRectangleKeyText
extends Draw3VertexFillAreaText {
    private static final String strClassName = "Draw3VertexKeyColorRectangleKeyText";
    private Draw3VertexKeyColorRectangle d3vRect;
    private Draw3VertexKeyText d3vKeyText;
    private int iMarginLeft = 0;
    private int iMarginRight = 0;
    private int iMarginTop = 0;
    private int iMarginBottom = 0;

    public Draw3VertexKeyColorRectangleKeyText() {
        this.d3vKeyText = new Draw3VertexKeyText();
        this.d3vRect = new Draw3VertexKeyColorRectangle();
        this._init();
    }

    public Draw3VertexKeyColorRectangleKeyText(String string, int n, int n2) {
        this.d3vKeyText = new Draw3VertexKeyText(string, n, n2);
        this.d3vRect = new Draw3VertexKeyColorRectangle();
        this._init();
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        Color color = graphics.getColor();
        Dimension dimension = this.d3vKeyText.getSize(dict, (GraphObject)vertex);
        this.d3vRect.setTranslationX(-((dimension.width >> 1) + this.iMarginLeft));
        this.d3vRect.setTranslationY(-((dimension.height >> 1) + this.iMarginTop));
        this.d3vRect.setDimension(this._getSize(dict, vertex));
        this.d3vRect.draw(dict, (GraphObject)vertex, graphics);
        this.d3vKeyText.draw(dict, (GraphObject)vertex, graphics);
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexKeyColorRectangleKeyText._getBounds(Dict," + vertex + ")]");
        }
        Rectangle rectangle = this.d3vKeyText.getBounds(dict, (GraphObject)vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\ttext bounds: " + rectangle);
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle.add(n + rectangle.width + this.iMarginRight, n2 + rectangle.height + this.iMarginBottom);
        rectangle.add(n - this.iMarginLeft, n2 - this.iMarginTop);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex bounds: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        Dimension dimension = this.d3vKeyText.getSize(dict, (GraphObject)vertex);
        dimension.setSize(dimension.width + this.iMarginLeft + this.iMarginRight, dimension.height + this.iMarginTop + this.iMarginBottom);
        return dimension;
    }

    private void _init() {
        this.d3vRect.setAlignments(1, 1);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Color getColorFill() {
        return this.d3vRect.getColorFill();
    }

    public Color getColorFill(Vertex vertex) {
        Color color;
        try {
            color = (Color)vertex.systemdict.get(this.d3vRect.getKeyColorFill());
        }
        catch (ClassCastException classCastException) {
            System.out.println("[Draw3VertexKeyColorRectangleKeyText.getColorFill(" + vertex + ")] Key \"" + this.d3vRect.getKeyColorFill() + "\" in vertex' systemdict has a value that is not of type Color.");
            color = null;
        }
        if (color == null) {
            color = this.d3vRect.getColorFill();
        }
        return color;
    }

    public Color getColorOutline() {
        return this.d3vRect.getColorOutline();
    }

    public Color getColorOutline(Vertex vertex) {
        Color color;
        try {
            color = (Color)vertex.systemdict.get(this.d3vRect.getKeyColorOutline());
        }
        catch (ClassCastException classCastException) {
            System.out.println("[Draw3VertexKeyColorRectangleKeyText.getColorOutline(" + vertex + ")] Key \"" + this.d3vRect.getKeyColorOutline() + "\" in vertex' systemdict has a value that is not of type Color.");
            color = null;
        }
        if (color == null) {
            color = this.d3vRect.getColorOutline();
        }
        return color;
    }

    public Draw3VertexKeyColorRectangle getDraw3VertexKeyColorRectangle() {
        return this.d3vRect;
    }

    public Draw3VertexKeyText getDraw3VertexKeyText() {
        return this.d3vKeyText;
    }

    public String getKeyColorFill() {
        return this.d3vRect.getKeyColorFill();
    }

    public String getKeyColorOutline() {
        return this.d3vRect.getKeyColorOutline();
    }

    public int getMarginBottom() {
        return this.iMarginBottom;
    }

    public int getMarginLeft() {
        return this.iMarginLeft;
    }

    public int getMarginRight() {
        return this.iMarginRight;
    }

    public int getMarginTop() {
        return this.iMarginTop;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setColorFill(Vertex vertex, Color color) {
        vertex.systemdict.def((Object)this.d3vRect.getKeyColorFill(), color);
    }

    public void setColorFill(Color color) {
        this.d3vRect.setColorFill(color);
    }

    public void setColorOutline(Vertex vertex, Color color) {
        vertex.systemdict.def((Object)this.d3vRect.getKeyColorOutline(), color);
    }

    public void setColorOutline(Color color) {
        this.d3vRect.setColorOutline(color);
    }

    public void setDraw3VertexKeyColorRectangle(Draw3VertexKeyColorRectangle draw3VertexKeyColorRectangle) {
        this.d3vRect = draw3VertexKeyColorRectangle;
    }

    public void setDraw3VertexKeyText(Draw3VertexKeyText draw3VertexKeyText) {
        this.d3vKeyText = draw3VertexKeyText;
    }

    public void setKeyColorFill(String string) {
        this.d3vRect.setKeyColorFill(string);
    }

    public void setKeyColorOutline(String string) {
        this.d3vRect.setKeyColorOutline(string);
    }

    public void setMarginBottom(int n) {
        this.iMarginBottom = n;
    }

    public void setMarginLeft(int n) {
        this.iMarginLeft = n;
    }

    public void setMarginRight(int n) {
        this.iMarginRight = n;
    }

    public void setMarginTop(int n) {
        this.iMarginTop = n;
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.iMarginLeft = n;
        this.iMarginRight = n2;
        this.iMarginBottom = n3;
        this.iMarginTop = n4;
    }
}

