/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.GraphDraw;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3Vertex;
import com.ibm.research.util.Dict;
import com.ibm.research.util.KeyMissingException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Draw3VertexKeyCheckbox
extends Draw3Vertex {
    public static String strKeyCheckboxDefault = "!!Raised";
    private static final String strClassName = "Draw3VertexKeyCheckbox";
    private Dimension _dimKeyCheckbox = null;
    private Color _colorRaised = Color.lightGray;
    private Color _colorNotRaised = Color.darkGray;
    private String _strKeyCheckbox = strKeyCheckboxDefault;

    public Draw3VertexKeyCheckbox() {
        this._init();
    }

    public Draw3VertexKeyCheckbox(Dimension dimension) {
        this._dimKeyCheckbox = dimension;
        this._init();
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException, NullPointerException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexKeyCheckbox._draw(" + dict + "," + vertex + ",Graphics)] ...");
        }
        Color color = graphics.getColor();
        Rectangle rectangle = this._getBounds(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\trectangle bounds: " + rectangle);
        }
        if (this._getRaised(vertex)) {
            graphics.setColor(this._colorRaised);
        } else {
            graphics.setColor(this._colorNotRaised);
        }
        graphics.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this._getRaised(vertex));
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexKeyCheckbox._getBounds(Dict,Vertex)]");
        }
        Point point = this.getLocation(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tlocation of vertex: " + point);
        }
        Dimension dimension = this._getSize(dict, vertex);
        Rectangle rectangle = new Rectangle(this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height), dimension.width, dimension.height);
        if (this.iVerbose >= 3) {
            System.out.println("\treturns: " + rectangle);
        }
        return rectangle;
    }

    private boolean _getRaised(Vertex vertex) {
        try {
            return vertex.systemdict.getBoolean(this._strKeyCheckbox);
        }
        catch (KeyMissingException keyMissingException) {
            return false;
        }
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        try {
            return new Dimension(dict.getInteger(GraphDraw.strKeyWidth), dict.getInteger(GraphDraw.strKeyHeight));
        }
        catch (KeyMissingException keyMissingException) {
            try {
                return new Dimension(vertex.systemdict.getInteger(GraphDraw.strKeyWidth), vertex.systemdict.getInteger(GraphDraw.strKeyHeight));
            }
            catch (KeyMissingException keyMissingException2) {
                if (this._dimKeyCheckbox != null) {
                    return this._dimKeyCheckbox;
                }
                if (this.iVerbose >= 1) {
                    System.out.println("[Draw3VertexKeyCheckbox._getSize(Dict," + vertex + ")] Could not determine dimension of rectangle.");
                }
                throw new NotDrawableException();
            }
        }
    }

    private void _init() {
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException, NullPointerException {
        this._draw(dict, vertex, graphics);
    }

    protected void finalize() {
        this._dimKeyCheckbox = null;
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Color getColorNotRaised() {
        return this._colorNotRaised;
    }

    public Color getColorRaised() {
        return this._colorRaised;
    }

    public Dimension getDimension() {
        return this._dimKeyCheckbox;
    }

    public String getKeyCheckbox() {
        return this._strKeyCheckbox;
    }

    public static String getKeyCheckboxDefault() {
        return strKeyCheckboxDefault;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setColorNotRaised(Color color) {
        this._colorNotRaised = color;
    }

    public void setColorRaised(Color color) {
        this._colorRaised = color;
    }

    public void setDimension(Dimension dimension) {
        this._dimKeyCheckbox = dimension;
    }

    public void setKeyCheckbox(String string) {
        this._strKeyCheckbox = string;
    }

    public static void setKeyCheckboxDefault(String string) {
        strKeyCheckboxDefault = string;
    }
}

