/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexFillAreaText;
import com.ibm.graph.draw.Draw3VertexImage;
import com.ibm.graph.draw.Draw3VertexKeyText;
import com.ibm.research.awt.FontMetricized;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class Draw3VertexImageKeyText
extends Draw3VertexFillAreaText {
    private static final String _strClassName = "Draw3VertexImageKeyText";
    private Draw3VertexImage _d3vImage;
    private Draw3VertexKeyText _d3vKeyText;
    private int iMarginLeft = 0;
    private int iMarginRight = 0;
    private int iMarginTop = 0;
    private int iMarginBottom = 0;
    private boolean _zValidAlignments = false;

    public Draw3VertexImageKeyText() {
        this((Image)null);
    }

    public Draw3VertexImageKeyText(FontMetricized fontMetricized) {
        this((Image)null, fontMetricized);
    }

    public Draw3VertexImageKeyText(Image image) {
        this._d3vKeyText = new Draw3VertexKeyText();
        this._d3vImage = new Draw3VertexImage(image);
        this._init();
    }

    public Draw3VertexImageKeyText(Image image, FontMetricized fontMetricized) {
        this._d3vKeyText = new Draw3VertexKeyText(fontMetricized);
        this._d3vImage = new Draw3VertexImage(image);
        this._init();
    }

    public Draw3VertexImageKeyText(Image image, String string) {
        this._d3vKeyText = new Draw3VertexKeyText(string);
        this._d3vImage = new Draw3VertexImage(image);
        this._init();
    }

    public Draw3VertexImageKeyText(Image image, String string, int n, int n2) {
        this._d3vKeyText = new Draw3VertexKeyText(string, n, n2);
        this._d3vImage = new Draw3VertexImage(image);
        this._init();
    }

    public Draw3VertexImageKeyText(Image image, String string, FontMetricized fontMetricized) {
        this._d3vKeyText = new Draw3VertexKeyText(string, fontMetricized);
        this._d3vImage = new Draw3VertexImage(image);
        this._init();
    }

    public Draw3VertexImageKeyText(Image image, String string, String string2, int n, int n2) {
        this._d3vKeyText = new Draw3VertexKeyText(string, string2, n, n2);
        this._d3vImage = new Draw3VertexImage(image);
        this._init();
    }

    public Draw3VertexImageKeyText(String string) {
        this(null, string);
    }

    public Draw3VertexImageKeyText(String string, int n, int n2) {
        this((Image)null, string, n, n2);
    }

    public Draw3VertexImageKeyText(String string, FontMetricized fontMetricized) {
        this(null, string, fontMetricized);
    }

    public Draw3VertexImageKeyText(String string, String string2, int n, int n2) {
        this(null, string, string2, n, n2);
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexImageKeyText._draw(Dict," + vertex + ",Graphics)]");
        }
        Color color = graphics.getColor();
        this._d3vImage.draw(dict, (GraphObject)vertex, graphics);
        if (!this._zValidAlignments) {
            this._validateAlignments();
        }
        this._d3vKeyText.draw(dict, (GraphObject)vertex, graphics);
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexImageKeyText._getBounds(Dict," + vertex + ")]");
        }
        if (!this._zValidAlignments) {
            this._validateAlignments();
        }
        Rectangle rectangle = this._d3vImage.getBounds(dict, (GraphObject)vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\timage bounds: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        Dimension dimension = this._d3vImage.getSize(dict, (GraphObject)vertex);
        return dimension;
    }

    private void _init() {
        this._d3vImage.setAlignments(0, 0);
        this._d3vKeyText.setAlignments(0, 0);
    }

    private void _setMarginBottom(int n) {
        if (this.iMarginBottom != n) {
            this.iMarginBottom = n;
            this._zValidAlignments = false;
        }
    }

    private void _setMarginLeft(int n) {
        if (this.iMarginLeft != n) {
            this.iMarginLeft = n;
            this._zValidAlignments = false;
        }
    }

    private void _setMarginRight(int n) {
        if (this.iMarginRight != n) {
            this.iMarginRight = n;
            this._zValidAlignments = false;
        }
    }

    private void _setMarginTop(int n) {
        if (this.iMarginTop != n) {
            this.iMarginTop = n;
            this._zValidAlignments = false;
        }
    }

    private void _validateAlignments() {
        int n = this._d3vImage.getTranslationX();
        switch (this._d3vKeyText.getAlignmentX()) {
            case 1: {
                n += this.iMarginLeft;
                break;
            }
            case -1: {
                n -= this.iMarginRight;
                break;
            }
        }
        this._d3vKeyText.setTranslationX(n);
        int n2 = this._d3vImage.getTranslationY();
        switch (this._d3vKeyText.getAlignmentY()) {
            case 1: {
                n2 += this.iMarginTop;
                break;
            }
            case -1: {
                n2 -= this.iMarginBottom;
                break;
            }
        }
        this._d3vKeyText.setTranslationY(n2);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Draw3VertexImage getDraw3VertexImage() {
        return this._d3vImage;
    }

    public Draw3VertexKeyText getDraw3VertexKeyText() {
        return this._d3vKeyText;
    }

    public Image getImage() {
        return this._d3vImage.getImage();
    }

    public int getMarginBottom() {
        return this.iMarginBottom;
    }

    public int getMarginLeft() {
        return this.iMarginLeft;
    }

    public int getMarginRight() {
        return this.iMarginRight;
    }

    public int getMarginTop() {
        return this.iMarginTop;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public int getTranslationX() {
        return this._d3vImage.getTranslationX();
    }

    public int getTranslationY() {
        return this._d3vImage.getTranslationY();
    }

    public void setAlignmentX(int n) {
        this._d3vImage.setAlignmentX(n);
        this._d3vKeyText.setAlignmentX(n);
        this._zValidAlignments = false;
    }

    public void setAlignmentY(int n) {
        this._d3vImage.setAlignmentY(n);
        this._d3vKeyText.setAlignmentY(n);
        this._zValidAlignments = false;
    }

    public void setAlignments(int n, int n2) {
        this._d3vImage.setAlignments(n, n2);
        this._d3vKeyText.setAlignments(n, n2);
        this._zValidAlignments = false;
    }

    public void setDraw3VertexImage(Draw3VertexImage draw3VertexImage) {
        this._d3vImage = draw3VertexImage;
    }

    public void setDraw3VertexKeyText(Draw3VertexKeyText draw3VertexKeyText) {
        this._d3vKeyText = draw3VertexKeyText;
    }

    public void setImage(Image image) {
        this._d3vImage.setImage(image);
    }

    public void setMarginBottom(int n) {
        this._setMarginBottom(n);
    }

    public void setMarginLeft(int n) {
        this._setMarginLeft(n);
    }

    public void setMarginRight(int n) {
        this._setMarginRight(n);
    }

    public void setMarginTop(int n) {
        this._setMarginTop(n);
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this._setMarginLeft(n);
        this._setMarginRight(n2);
        this._setMarginBottom(n3);
        this._setMarginTop(n4);
    }

    public void setTranslationX(int n) {
        this._d3vImage.setTranslationX(n);
        this._zValidAlignments = false;
    }

    public void setTranslationY(int n) {
        this._d3vImage.setTranslationY(n);
        this._zValidAlignments = false;
    }

    public void setVerbose(int n) {
        super.setVerbose(n);
        this._d3vImage.setVerbose(n);
        this._d3vKeyText.setVerbose(n);
    }

    public void validateAlignments() {
        this._validateAlignments();
        this._zValidAlignments = true;
    }
}

