/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3Vertex;
import com.ibm.research.util.Dict;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;

public class Draw3VertexImage
extends Draw3Vertex
implements ImageObserver {
    private static String strClassName = "Draw3VertexImage";
    private Image image = null;

    public Draw3VertexImage() {
        this.image = null;
    }

    public Draw3VertexImage(Image image) {
        this.image = image;
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._draw(Dict,Vertex,Graphics)] ...");
        }
        Point point = this.getLocation(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex location: " + point);
        }
        Dimension dimension = this._getSize(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex size: " + dimension);
        }
        if (this.image != null) {
            graphics.drawImage(this.image, this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height), this);
            if (this.iVerbose >= 4) {
                int n = this._alignX(point.x, dimension.width);
                int n2 = this._alignY(point.y, dimension.height);
                System.out.println("\tvertex aligned location: " + n + ", " + n2);
            }
        } else if (this.iVerbose >= 1) {
            System.out.println("!?[Draw3VertexImage.draw()] Warning: null image. Nothing drawn.");
        }
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        Point point = this.getLocation(dict, vertex);
        Dimension dimension = this._getSize(dict, vertex);
        return new Rectangle(this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height), dimension.width, dimension.height);
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        int n;
        int n2;
        Dimension dimension = null;
        if (this.image != null) {
            n2 = this.image.getWidth(this);
            n = this.image.getHeight(this);
            if (n2 == -1 || n == -1) {
                throw new NotDrawableException("[" + strClassName + ".getSize()] Image with no size. Suggestion: check that the image has finished loading.");
            }
        } else {
            throw new NotDrawableException("[" + strClassName + ".getSize()] Null image. Suggestion: check that the image exists and has finished loading.");
        }
        dimension = new Dimension(n2, n);
        return dimension;
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Image getImage() {
        return this.image;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    public void setImage(Image image) {
        this.image = image;
    }
}

