/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexEllipse;
import com.ibm.graph.draw.Draw3VertexFillAreaText;
import com.ibm.graph.draw.Draw3VertexText;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Draw3VertexEllipseText
extends Draw3VertexFillAreaText {
    private static String strClassName = "Draw3VertexEllipseText";
    private Draw3VertexEllipse d3vEllipse;
    private Draw3VertexText d3vText;

    public Draw3VertexEllipseText() {
        this.d3vText = new Draw3VertexText();
        this.d3vEllipse = new Draw3VertexEllipse();
        this._init();
    }

    public Draw3VertexEllipseText(String string, int n, int n2) {
        this.d3vText = new Draw3VertexText(string, n, n2);
        this.d3vEllipse = new Draw3VertexEllipse();
        this._init();
    }

    public Draw3VertexEllipseText(String string, String string2, int n, int n2) {
        this.d3vText = new Draw3VertexText(string, string2, n, n2);
        this.d3vEllipse = new Draw3VertexEllipse();
        this._init();
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        Color color = graphics.getColor();
        Dimension dimension = this.d3vText.getSize(dict, (GraphObject)vertex);
        this.d3vEllipse.setTranslationX(-((dimension.width >> 1) + this.iMarginLeft));
        this.d3vEllipse.setTranslationY(-((dimension.height >> 1) + this.iMarginTop));
        this.d3vEllipse.setDimension(this._getSize(dict, vertex));
        this.d3vEllipse.draw(dict, (GraphObject)vertex, graphics);
        this.d3vText.draw(dict, (GraphObject)vertex, graphics);
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._getBounds(Dict," + vertex + ")]");
        }
        Rectangle rectangle = this.d3vText.getBounds(dict, (GraphObject)vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\ttext bounds: " + rectangle);
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle.add(n + rectangle.width + this.iMarginRight, n2 + rectangle.height + this.iMarginBottom);
        rectangle.add(n - this.iMarginLeft, n2 - this.iMarginTop);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex bounds: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        Dimension dimension = this.d3vText.getSize(dict, (GraphObject)vertex);
        dimension.setSize(dimension.width + this.iMarginLeft + this.iMarginRight, dimension.height + this.iMarginTop + this.iMarginBottom);
        return dimension;
    }

    private void _init() {
        this.d3vEllipse.setAlignments(1, 1);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Draw3VertexEllipse getDraw3VertexEllipse() {
        return this.d3vEllipse;
    }

    public Draw3VertexText getDraw3VertexText() {
        return this.d3vText;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setDraw3VertexEllipse(Draw3VertexEllipse draw3VertexEllipse) {
        this.d3vEllipse = draw3VertexEllipse;
    }

    public void setDraw3VertexText(Draw3VertexText draw3VertexText) {
        this.d3vText = draw3VertexText;
    }
}

