/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexFillArea;
import com.ibm.graph.draw.Draw3VertexRectangle;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Draw3VertexEllipseRectangleRectangle
extends Draw3VertexFillArea {
    private static String strClassName = "Draw3VertexEllipseRectangleRectangle";
    private Dimension dimEllipseRectangleRectangle = null;

    public Draw3VertexEllipseRectangleRectangle() {
        this(new Dimension(50, 30));
    }

    public Draw3VertexEllipseRectangleRectangle(Dimension dimension) {
        this.zOutline = true;
        this.colorOutline = Color.black;
        this.zFill = true;
        this.colorFill = Color.lightGray;
        this.dimEllipseRectangleRectangle = dimension;
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._draw(" + dict + "," + vertex + ",Graphics)] ...");
        }
        Color color = graphics.getColor();
        Rectangle rectangle = this._getBounds(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tellipse bounds: " + rectangle);
        }
        if (this.zFill) {
            if (this.colorFill == null) {
                graphics.setColor(color);
                graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.setColor(this.colorFill);
                graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (this.zOutline && this.colorOutline != null) {
            graphics.setColor(this.colorOutline);
            graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this._drawRectangle(dict, vertex, graphics, vertex.userdict.get("rectangle1"), -20, 0);
        this._drawRectangle(dict, vertex, graphics, vertex.userdict.get("rectangle2"), 20, 0);
        graphics.setColor(color);
    }

    private void _drawRectangle(Dict dict, Vertex vertex, Graphics graphics, Object object, int n, int n2) {
        Point point;
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._drawRectangle(Dict," + vertex + ",Graphics," + object + "," + n + "," + n2 + ")]{");
        }
        try {
            point = this.getLocation(dict, vertex);
        }
        catch (NotDrawableException notDrawableException) {
            return;
        }
        try {
            Point point2;
            Vertex vertex2 = (Vertex)object;
            try {
                point2 = vertex2.getLocation();
                point2.move(point.x + n, point.y + n2);
            }
            catch (NotDrawableException notDrawableException) {
                point2 = new Point(point.x + n, point.y + n2);
            }
            vertex2.setLocation(point2);
            if (this.iVerbose >= 3) {
                System.out.println("\t" + point2);
            }
            if (vertex2.getDrawable() == null) {
                Draw3VertexRectangle draw3VertexRectangle = new Draw3VertexRectangle(new Dimension(30, 10));
                draw3VertexRectangle.setColorOutline(Color.blue);
                vertex2.setDrawable(draw3VertexRectangle);
            }
            vertex2.draw(graphics);
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._drawRectangle(Dict," + vertex + ",Graphics," + object + "," + n + "," + n2 + ")]}");
        }
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._getBounds(Dict,Vertex)]");
        }
        Point point = this.getLocation(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tlocation of vertex: " + point);
        }
        try {
            return new Rectangle(this._alignX(point.x, this.dimEllipseRectangleRectangle.width), this._alignY(point.y, this.dimEllipseRectangleRectangle.height), this.dimEllipseRectangleRectangle.width, this.dimEllipseRectangleRectangle.height);
        }
        catch (NullPointerException nullPointerException) {
            throw new NotDrawableException();
        }
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.dimEllipseRectangleRectangle != null) {
            return this.dimEllipseRectangleRectangle;
        }
        throw new NotDrawableException();
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Dimension getDimension() {
        return this.dimEllipseRectangleRectangle;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setDimension(Dimension dimension) {
        if (dimension == null && this.iVerbose >= 1) {
            System.out.println("[" + strClassName + ".setDimension(" + dimension + ")] Warning: null dimension.");
        }
        this.dimEllipseRectangleRectangle = dimension;
    }
}

