/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexEllipse;
import com.ibm.graph.draw.Draw3VertexFillAreaText;
import com.ibm.graph.draw.Draw3VertexKeyText;
import com.ibm.research.awt.FontMetricized;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Draw3VertexEllipseKeyText
extends Draw3VertexFillAreaText {
    private static final String strClassName = "Draw3VertexEllipseKeyText";
    private Draw3VertexEllipse d3vEllipse;
    private Draw3VertexKeyText d3vKeyText;
    private int iMarginLeft = 0;
    private int iMarginRight = 0;
    private int iMarginTop = 0;
    private int iMarginBottom = 0;

    public Draw3VertexEllipseKeyText() {
        this.d3vKeyText = new Draw3VertexKeyText();
        this.d3vEllipse = new Draw3VertexEllipse();
        this._init();
    }

    public Draw3VertexEllipseKeyText(FontMetricized fontMetricized) {
        this.d3vKeyText = new Draw3VertexKeyText(fontMetricized);
        this.d3vEllipse = new Draw3VertexEllipse();
        this._init();
    }

    public Draw3VertexEllipseKeyText(String string) {
        this.d3vKeyText = new Draw3VertexKeyText(string);
        this.d3vEllipse = new Draw3VertexEllipse();
        this._init();
    }

    public Draw3VertexEllipseKeyText(String string, int n, int n2) {
        this.d3vKeyText = new Draw3VertexKeyText(string, n, n2);
        this.d3vEllipse = new Draw3VertexEllipse();
        this._init();
    }

    public Draw3VertexEllipseKeyText(String string, FontMetricized fontMetricized) {
        this.d3vKeyText = new Draw3VertexKeyText(string, fontMetricized);
        this.d3vEllipse = new Draw3VertexEllipse();
        this._init();
    }

    public Draw3VertexEllipseKeyText(String string, String string2, int n, int n2) {
        this.d3vKeyText = new Draw3VertexKeyText(string, string2, n, n2);
        this.d3vEllipse = new Draw3VertexEllipse();
        this._init();
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        Color color = graphics.getColor();
        Dimension dimension = this.d3vKeyText.getSize(dict, (GraphObject)vertex);
        this.d3vEllipse.setTranslationX(-((dimension.width >> 1) + this.iMarginLeft));
        this.d3vEllipse.setTranslationY(-((dimension.height >> 1) + this.iMarginTop));
        this.d3vEllipse.setDimension(this._getSize(dict, vertex));
        this.d3vEllipse.draw(dict, (GraphObject)vertex, graphics);
        this.d3vKeyText.draw(dict, (GraphObject)vertex, graphics);
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexEllipseKeyText._getBounds(Dict," + vertex + ")]");
        }
        Rectangle rectangle = this.d3vKeyText.getBounds(dict, (GraphObject)vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\ttext bounds: " + rectangle);
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle.add(n + rectangle.width + this.iMarginRight, n2 + rectangle.height + this.iMarginBottom);
        rectangle.add(n - this.iMarginLeft, n2 - this.iMarginTop);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex bounds: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        Dimension dimension = this.d3vKeyText.getSize(dict, (GraphObject)vertex);
        dimension.setSize(dimension.width + this.iMarginLeft + this.iMarginRight, dimension.height + this.iMarginTop + this.iMarginBottom);
        return dimension;
    }

    private void _init() {
        this.d3vEllipse.setAlignments(1, 1);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Color getColorFill() {
        return this.d3vEllipse.getColorFill();
    }

    public Color getColorOutline() {
        return this.d3vEllipse.getColorOutline();
    }

    public boolean getDoFill() {
        return this.d3vEllipse.getDoFill();
    }

    public boolean getDoOutline() {
        return this.d3vEllipse.getDoOutline();
    }

    public Draw3VertexEllipse getDraw3VertexEllipse() {
        return this.d3vEllipse;
    }

    public Draw3VertexKeyText getDraw3VertexKeyText() {
        return this.d3vKeyText;
    }

    public int getMarginBottom() {
        return this.iMarginBottom;
    }

    public int getMarginLeft() {
        return this.iMarginLeft;
    }

    public int getMarginRight() {
        return this.iMarginRight;
    }

    public int getMarginTop() {
        return this.iMarginTop;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setColorFill(Color color) {
        this.d3vEllipse.setColorFill(color);
    }

    public void setColorOutline(Color color) {
        this.d3vEllipse.setColorOutline(color);
    }

    public void setDoFill(boolean bl) {
        this.d3vEllipse.setDoFill(bl);
    }

    public void setDoOutline(boolean bl) {
        this.d3vEllipse.setDoOutline(bl);
    }

    public void setDraw3VertexEllipse(Draw3VertexEllipse draw3VertexEllipse) {
        this.d3vEllipse = draw3VertexEllipse;
    }

    public void setDraw3VertexKeyText(Draw3VertexKeyText draw3VertexKeyText) {
        this.d3vKeyText = draw3VertexKeyText;
    }

    public void setMarginBottom(int n) {
        this.iMarginBottom = n;
    }

    public void setMarginLeft(int n) {
        this.iMarginLeft = n;
    }

    public void setMarginRight(int n) {
        this.iMarginRight = n;
    }

    public void setMarginTop(int n) {
        this.iMarginTop = n;
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.iMarginLeft = n;
        this.iMarginRight = n2;
        this.iMarginBottom = n3;
        this.iMarginTop = n4;
    }
}

