/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexFillArea;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Draw3VertexEllipse
extends Draw3VertexFillArea {
    private static String strClassName = "Draw3VertexEllipse";
    private Dimension dimEllipse = null;

    public Draw3VertexEllipse() {
        this(new Dimension(40, 20));
    }

    public Draw3VertexEllipse(Dimension dimension) {
        this.zOutline = true;
        this.colorOutline = Color.black;
        this.zFill = true;
        this.colorFill = Color.lightGray;
        this.dimEllipse = dimension;
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException, NullPointerException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._draw(" + dict + "," + vertex + ",Graphics)] ...");
        }
        Color color = graphics.getColor();
        Rectangle rectangle = this._getBounds(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tellipse bounds: " + rectangle);
        }
        if (this.zFill) {
            if (this.colorFill == null) {
                graphics.setColor(color);
                graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.setColor(this.colorFill);
                graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (this.zOutline && this.colorOutline != null) {
            graphics.setColor(this.colorOutline);
            graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._getBounds(Dict,Vertex)]");
        }
        Point point = this.getLocation(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tlocation of vertex: " + point);
        }
        try {
            return new Rectangle(this._alignX(point.x, this.dimEllipse.width), this._alignY(point.y, this.dimEllipse.height), this.dimEllipse.width, this.dimEllipse.height);
        }
        catch (NullPointerException nullPointerException) {
            throw new NotDrawableException();
        }
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.dimEllipse != null) {
            return this.dimEllipse;
        }
        throw new NotDrawableException();
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Dimension getDimension() {
        return this.dimEllipse;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setDimension(Dimension dimension) {
        if (dimension == null && this.iVerbose >= 1) {
            System.out.println("[" + strClassName + ".setDimension(" + dimension + ")] Warning: null dimension.");
        }
        this.dimEllipse = dimension;
    }
}

