/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexCircle;
import com.ibm.graph.draw.Draw3VertexFillAreaText;
import com.ibm.graph.draw.Draw3VertexText;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Draw3VertexCircleText
extends Draw3VertexFillAreaText {
    private static String _$strClassName = "Draw3VertexCircleText";
    private Draw3VertexCircle d3vCirc;
    private Draw3VertexText d3vText;

    public Draw3VertexCircleText() {
        this.d3vText = new Draw3VertexText();
        this.d3vCirc = new Draw3VertexCircle();
        this._init();
    }

    public Draw3VertexCircleText(String string, int n, int n2) {
        this.d3vText = new Draw3VertexText(string, n, n2);
        this.d3vCirc = new Draw3VertexCircle();
        this._init();
    }

    public Draw3VertexCircleText(String string, String string2, int n, int n2) {
        this.d3vText = new Draw3VertexText(string, string2, n, n2);
        this.d3vCirc = new Draw3VertexCircle();
        this._init();
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        Color color = graphics.getColor();
        Dimension dimension = this.d3vText.getSize(dict, (GraphObject)vertex);
        int n = Math.max(dimension.width, dimension.height) >> 1;
        int n2 = Math.max(dimension.width + this.iMarginLeft + this.iMarginRight, dimension.height + this.iMarginBottom + this.iMarginTop) >> 1;
        this.d3vCirc.setTranslationX(-(n + this.iMarginLeft));
        this.d3vCirc.setTranslationY(-(n + this.iMarginTop));
        Dimension dimension2 = this._getSize(dict, vertex);
        this.d3vCirc.setRadius(n2);
        this.d3vCirc.draw(dict, (GraphObject)vertex, graphics);
        this.d3vText.draw(dict, (GraphObject)vertex, graphics);
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + _$strClassName + "._getBounds(Dict," + vertex + ")]");
        }
        Rectangle rectangle = this.d3vText.getBounds(dict, (GraphObject)vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\ttext bounds: " + rectangle);
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle.add(n + rectangle.width + this.iMarginRight, n2 + rectangle.height + this.iMarginBottom);
        rectangle.add(n - this.iMarginLeft, n2 - this.iMarginTop);
        if (this.iVerbose >= 4) {
            System.out.println("\tvertex bounds: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        Dimension dimension = this.d3vText.getSize(dict, (GraphObject)vertex);
        dimension.setSize(dimension.width + this.iMarginLeft + this.iMarginRight, dimension.height + this.iMarginTop + this.iMarginBottom);
        return dimension;
    }

    private void _init() {
        this.d3vCirc.setAlignments(1, 1);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Color getColorFill() {
        return this.d3vCirc.colorFill;
    }

    public Color getColorOutline() {
        return this.d3vCirc.colorOutline;
    }

    public boolean getDoFill() {
        return this.d3vCirc.zFill;
    }

    public boolean getDoOutline() {
        return this.d3vCirc.zOutline;
    }

    public Draw3VertexCircle getDraw3VertexCircle() {
        return this.d3vCirc;
    }

    public Draw3VertexText getDraw3VertexText() {
        return this.d3vText;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setColorFill(Color color) {
        this.d3vCirc.colorFill = color;
    }

    public void setColorOutline(Color color) {
        this.d3vCirc.colorOutline = color;
    }

    public void setDoFill(boolean bl) {
        this.d3vCirc.zFill = bl;
    }

    public void setDoOutline(boolean bl) {
        this.d3vCirc.zOutline = bl;
    }

    public void setDraw3VertexCircle(Draw3VertexCircle draw3VertexCircle) {
        this.d3vCirc = draw3VertexCircle;
    }

    public void setDraw3VertexText(Draw3VertexText draw3VertexText) {
        this.d3vText = draw3VertexText;
    }
}

