/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3VertexFillArea;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Draw3VertexCircle
extends Draw3VertexFillArea {
    private static String strClassName = "Draw3VertexCircle";
    private int iRadius;

    public Draw3VertexCircle() {
        this(10);
    }

    public Draw3VertexCircle(int n) {
        this.zOutline = true;
        this.colorOutline = Color.black;
        this.zFill = true;
        this.colorFill = Color.lightGray;
        this.iRadius = n;
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException, NullPointerException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._draw(" + dict + "," + vertex + ",Graphics)] ...");
        }
        Color color = graphics.getColor();
        Rectangle rectangle = this._getBounds(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tcircle bounds: " + rectangle);
        }
        if (this.zFill) {
            if (this.colorFill == null) {
                graphics.setColor(color);
                graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.setColor(this.colorFill);
                graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (this.zOutline && this.colorOutline != null) {
            graphics.setColor(this.colorOutline);
            graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[" + strClassName + "._getBounds(Dict,Vertex)]");
        }
        Point point = this.getLocation(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tlocation of vertex: " + point);
        }
        int n = this.iRadius + this.iRadius;
        return new Rectangle(this._alignX(point.x, n), this._alignY(point.y, n), n, n);
    }

    private Dimension _getSize(Dict dict, Vertex vertex) {
        return new Dimension(this.iRadius + this.iRadius, this.iRadius + this.iRadius);
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException {
        this._draw(dict, vertex, graphics);
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public int getRadius() {
        return this.iRadius;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setRadius(int n) {
        this.iRadius = n;
    }
}

