/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw3Vertex;
import com.ibm.research.util.Dict;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Draw3VertexCheckbox
extends Draw3Vertex {
    private static final String strClassName = "Draw3VertexCheckbox";
    private Dimension _dimCheckbox = null;
    private boolean _zRaised = true;
    private Color _colorRaised = Color.lightGray;
    private Color _colorNotRaised = Color.darkGray;

    public Draw3VertexCheckbox() {
        this(new Dimension(20, 20));
    }

    public Draw3VertexCheckbox(Dimension dimension) {
        this._dimCheckbox = dimension;
        this._init();
    }

    private void _draw(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException, NullPointerException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexCheckbox._draw(" + dict + "," + vertex + ",Graphics)] ...");
        }
        Color color = graphics.getColor();
        Rectangle rectangle = this._getBounds(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\trectangle bounds: " + rectangle);
        }
        if (this._zRaised) {
            graphics.setColor(this._colorRaised);
        } else {
            graphics.setColor(this._colorNotRaised);
        }
        graphics.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this._zRaised);
        graphics.setColor(color);
    }

    private Rectangle _getBounds(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this.iVerbose >= 3) {
            System.out.println("[Draw3VertexCheckbox._getBounds(Dict,Vertex)]");
        }
        Point point = this.getLocation(dict, vertex);
        if (this.iVerbose >= 4) {
            System.out.println("\tlocation of vertex: " + point);
        }
        Dimension dimension = this._getSize(dict, vertex);
        Rectangle rectangle = new Rectangle(this._alignX(point.x, dimension.width), this._alignY(point.y, dimension.height), dimension.width, dimension.height);
        if (this.iVerbose >= 3) {
            System.out.println("\treturns: " + rectangle);
        }
        return rectangle;
    }

    private Dimension _getSize(Dict dict, Vertex vertex) throws NotDrawableException {
        if (this._dimCheckbox != null) {
            return this._dimCheckbox;
        }
        if (this.iVerbose >= 1) {
            System.out.println("[Draw3VertexCheckbox._getSize(Dict," + vertex + ")] Could not determine dimension of rectangle.");
        }
        throw new NotDrawableException();
    }

    private void _init() {
    }

    public void drawVertex(Dict dict, Vertex vertex, Graphics graphics) throws NotDrawableException, NullPointerException {
        this._draw(dict, vertex, graphics);
    }

    protected void finalize() {
        this._dimCheckbox = null;
    }

    public Rectangle getBoundsVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getBounds(dict, vertex);
    }

    public Color getColorNotRaised() {
        return this._colorNotRaised;
    }

    public Color getColorRaised() {
        return this._colorRaised;
    }

    public Dimension getDimension() {
        return this._dimCheckbox;
    }

    public boolean getRaised() {
        return this._zRaised;
    }

    public Dimension getSizeVertex(Dict dict, Vertex vertex) throws NotDrawableException {
        return this._getSize(dict, vertex);
    }

    public void setColorNotRaised(Color color) {
        this._colorNotRaised = color;
    }

    public void setColorRaised(Color color) {
        this._colorRaised = color;
    }

    public void setDimension(Dimension dimension) {
        this._dimCheckbox = dimension;
    }

    public void setRaised(boolean bl) {
        this._zRaised = bl;
    }

    public void toggleRaised() {
        this._zRaised ^= true;
    }
}

