/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.graph.draw;

import com.ibm.graph.Drawable3;
import com.ibm.graph.GraphObject;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.draw.Draw2Vertex;
import com.ibm.graph.draw.DrawVertex;
import com.ibm.research.util.Dict;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class Draw3Vertex
extends Draw2Vertex
implements Drawable3 {
    private static String strClassName = "Draw3Vertex";

    public boolean contains(Dict dict, GraphObject graphObject, int n, int n2) {
        try {
            return this.containsVertex(dict, (Vertex)graphObject, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            if (dict == null) {
                System.out.println("?![" + strClassName + ".contains(Dict," + graphObject + "," + n + "," + n2 + ")] Null dict.");
            }
            if (graphObject == null) {
                System.out.println("?![" + strClassName + ".contains(Dict," + graphObject + "," + n + "," + n2 + ")] Null vertex.");
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            System.out.println("?![" + strClassName + ".contains(Dict," + graphObject + "," + n + "," + n2 + ")] Graph object is not an instance of Vertex.");
            return false;
        }
        catch (NotDrawableException notDrawableException) {
            return false;
        }
    }

    protected boolean containsVertex(Dict dict, Vertex vertex, int n, int n2) throws NotDrawableException {
        return this.getBoundsVertex(dict, vertex).contains(n, n2);
    }

    public void draw(Dict dict, GraphObject graphObject, Graphics graphics) {
        Vertex vertex;
        if (this.iVerbose >= 1) {
            System.out.println("[" + strClassName + ".draw(" + dict + "," + graphObject + ",Graphics)]");
        }
        try {
            vertex = (Vertex)graphObject;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[" + strClassName + ".draw(Dict," + graphObject + ",Graphics)] Graph object is not of class Vertex.");
            return;
        }
        try {
            if (dict != null) {
                this.drawVertex(dict, vertex, graphics);
            } else {
                this.drawVertex(vertex.systemdict, vertex, graphics);
            }
        }
        catch (NotDrawableException notDrawableException) {
            if (this.iVerbose > 0) {
                System.out.println("[" + strClassName + ".draw(Dict," + graphObject + ",Graphics)] Not drawable: unspecified location.");
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            if (vertex == null) {
                System.out.println("[" + strClassName + ".draw(Dict," + vertex + ",Graphics)] Vertex is null.");
            }
            if (graphics == null) {
                System.out.println("[" + strClassName + ".draw(Dict," + vertex + ",Graphics)] Graphics is null.");
            }
            System.out.println("[" + strClassName + ".draw(Dict," + vertex + ",Graphics)] Null pointer exception. [BUG?]");
            nullPointerException.printStackTrace();
            return;
        }
    }

    public Rectangle getBounds(Dict dict, GraphObject graphObject) throws NotDrawableException {
        Vertex vertex;
        try {
            vertex = (Vertex)graphObject;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[Draw2VertexText.getBounds(Dict," + graphObject + ")] Graph object is not an instance of Vertex.");
            throw new NotDrawableException();
        }
        if (dict == null) {
            return this.getBoundsVertex(vertex.systemdict, vertex);
        }
        return this.getBoundsVertex(dict, vertex);
    }

    protected Point getLocation(Dict dict, Vertex vertex) throws NotDrawableException {
        Point point;
        try {
            point = vertex.getLocation(dict);
        }
        catch (NotDrawableException notDrawableException) {
            point = vertex.getLocation();
        }
        return this.translate(point);
    }

    public Dimension getSize(Dict dict, GraphObject graphObject) throws NotDrawableException {
        Vertex vertex;
        try {
            vertex = (Vertex)graphObject;
        }
        catch (ClassCastException classCastException) {
            System.out.println("[" + strClassName + ".getSize(Dict," + graphObject + ")] Graph object is not an instance of Vertex.");
            throw new NotDrawableException();
        }
        try {
            if (dict == null) {
                return this.getSizeVertex(vertex.systemdict, vertex);
            }
            return this.getSizeVertex(dict, vertex);
        }
        catch (NullPointerException nullPointerException) {
            if (vertex == null) {
                System.out.println("[" + strClassName + ".getSize(Dict," + vertex + ")] Vertex is null.");
            }
            System.out.println("[" + strClassName + ".getSize(Dict," + vertex + ")] Null pointer exception. [BUG?]");
            nullPointerException.printStackTrace();
            throw new NotDrawableException();
        }
    }

    public static int getX(Dict dict, Vertex vertex) throws NotDrawableException {
        if (DrawVertex.iClassVerbose >= 1) {
            System.out.println("[" + strClassName + ".getLocationX(" + dict + ")]");
        }
        if (dict != null) {
            if (DrawVertex.iClassVerbose >= 2) {
                System.out.println("\treturn from dict: " + DrawVertex.getX(dict));
            }
            return DrawVertex.getX(dict);
        }
        if (DrawVertex.iClassVerbose >= 2) {
            System.out.println("\treturn from systemdict: " + DrawVertex.getX(dict));
        }
        return DrawVertex.getX(vertex.systemdict);
    }

    public static int getY(Dict dict, Vertex vertex) throws NotDrawableException {
        if (DrawVertex.iClassVerbose >= 1) {
            System.out.println("[" + strClassName + ".getLocationY(" + dict + ")]");
        }
        if (dict != null) {
            if (DrawVertex.iClassVerbose >= 2) {
                System.out.println("\treturn from dict: " + DrawVertex.getY(dict));
            }
            return DrawVertex.getY(dict);
        }
        if (DrawVertex.iClassVerbose >= 2) {
            System.out.println("\treturn from systemdict: " + DrawVertex.getY(dict));
        }
        return DrawVertex.getY(vertex.systemdict);
    }
}

